/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.paddlepaddle.jni;

import ai.djl.util.Platform;
import ai.djl.util.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LibUtils {
    private static final Logger logger = LoggerFactory.getLogger(LibUtils.class);
    private static final String NATIVE_LIB_NAME = "paddle_inference";
    private static final String LIB_NAME = "djl_paddle";
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+\\.\\d+\\.\\d+)(-SNAPSHOT)?(-\\d+)?");

    private LibUtils() {
    }

    public static void loadLibrary() {
        String libName = LibUtils.findOverrideLibrary();
        AtomicBoolean fallback = new AtomicBoolean(false);
        if (libName == null && (libName = LibUtils.findLibraryInClasspath(fallback)) == null) {
            throw new IllegalStateException("Native library not found");
        }
        if (System.getProperty("os.name").startsWith("Linux")) {
            LibUtils.loadLinuxDependencies(libName);
        } else if (System.getProperty("os.name").startsWith("Win")) {
            LibUtils.loadWindowsDependencies(libName);
        }
        logger.debug("Now loading " + libName);
        System.load(libName);
        Path nativeLibDir = Paths.get(libName, new String[0]).getParent();
        if (nativeLibDir == null || !nativeLibDir.toFile().isDirectory()) {
            throw new IllegalStateException("Native folder cannot be found");
        }
        libName = LibUtils.copyJniLibraryFromClasspath(nativeLibDir, fallback.get());
        logger.debug("Loading paddle library from: {}", (Object)libName);
        System.load(libName);
    }

    public static void loadLinuxDependencies(String libName) {
        Path libDir = Paths.get(libName, new String[0]).getParent();
        if (libDir != null) {
            logger.info("Paddle MKL/GPU requires user to set LD_LIBRARY_PATH=" + libDir + ", the current one is set to: " + System.getenv("LD_LIBRARY_PATH"));
            List<String> names = Arrays.asList("libdnnl.so.2", "libiomp5.so", "libmklml_intel.so");
            names.forEach(name -> {
                Path path = libDir.resolve((String)name);
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    String lib = path.toAbsolutePath().toString();
                    logger.debug("Now loading " + lib);
                    System.load(lib);
                } else {
                    logger.debug(name + " is not found, skip loading...");
                }
            });
        }
    }

    public static void loadWindowsDependencies(String libName) {
        Path libDir = Paths.get(libName, new String[0]).getParent();
        List<String> names = Collections.singletonList("openblas.dll");
        names.forEach(name -> {
            String lib = libDir.resolve((String)name).toAbsolutePath().toString();
            logger.debug("Now loading " + lib);
            System.load(libDir.resolve((String)name).toAbsolutePath().toString());
        });
    }

    private static String findOverrideLibrary() {
        String libName;
        String libPath = System.getenv("PADDLE_LIBRARY_PATH");
        if (libPath != null && (libName = LibUtils.findLibraryInPath(libPath)) != null) {
            return libName;
        }
        libPath = System.getProperty("java.library.path");
        if (libPath != null) {
            return LibUtils.findLibraryInPath(libPath);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private static String copyJniLibraryFromClasspath(Path nativeDir, boolean fallback) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static synchronized String findLibraryInClasspath(AtomicBoolean fallback) {
        Enumeration<URL> urls;
        try {
            urls = Thread.currentThread().getContextClassLoader().getResources("native/lib/paddlepaddle.properties");
        }
        catch (IOException e) {
            logger.warn("", (Throwable)e);
            return null;
        }
        if (!urls.hasMoreElements()) {
            String preferredVersion;
            try (InputStream is = LibUtils.class.getResourceAsStream("/jnilib/paddlepaddle.properties");){
                Properties prop = new Properties();
                prop.load(is);
                preferredVersion = prop.getProperty("paddlepaddle_version");
            }
            catch (IOException e) {
                throw new IllegalStateException("paddlepaddle.properties not found.", e);
            }
            Platform platform = Platform.fromSystem((String)preferredVersion);
            return LibUtils.downloadLibrary(platform, fallback);
        }
        Platform systemPlatform = Platform.fromSystem();
        try {
            Platform matching = null;
            Platform placeholder = null;
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                Platform platform = Platform.fromUrl((URL)url);
                if (platform.isPlaceholder()) {
                    placeholder = platform;
                    continue;
                }
                if (!platform.matches(systemPlatform)) continue;
                matching = platform;
                break;
            }
            if (matching != null) {
                String flavor = matching.getFlavor();
                if ("cpu".equals(flavor)) {
                    fallback.set(true);
                }
                return LibUtils.loadLibraryFromClasspath(matching);
            }
            if (placeholder != null) {
                return LibUtils.downloadLibrary(placeholder, fallback);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read PaddlePaddle native library jar properties", e);
        }
        throw new IllegalStateException("Your PaddlePaddle native library jar does not match your operating system. Make sure that the Maven Dependency Classifier matches your system type.");
    }

    private static String loadLibraryFromClasspath(Platform platform) {
        String string;
        block34: {
            Path tmp = null;
            try {
                String libName = System.mapLibraryName(NATIVE_LIB_NAME);
                Path cacheFolder = Utils.getEngineCacheDir((String)"paddle");
                String version = platform.getVersion();
                String flavor = platform.getFlavor();
                String classifier = platform.getClassifier();
                Path dir = cacheFolder.resolve(version + '-' + flavor + '-' + classifier);
                logger.debug("Using cache dir: {}", (Object)dir);
                Path path = dir.resolve(libName);
                if (Files.exists(path, new LinkOption[0])) {
                    String string2 = path.toAbsolutePath().toString();
                    return string2;
                }
                Files.createDirectories(cacheFolder, new FileAttribute[0]);
                tmp = Files.createTempDirectory(cacheFolder, "tmp", new FileAttribute[0]);
                for (String file : platform.getLibraries()) {
                    String libPath = "/native/lib/" + file;
                    logger.info("Extracting {} to cache ...", (Object)file);
                    if (file.endsWith(".gz")) {
                        String f = file.substring(0, file.length() - 3);
                        try (GZIPInputStream is = new GZIPInputStream(LibUtils.class.getResourceAsStream(libPath));){
                            Files.copy(is, tmp.resolve(f), StandardCopyOption.REPLACE_EXISTING);
                            continue;
                        }
                    }
                    try (InputStream is = LibUtils.class.getResourceAsStream(libPath);){
                        Files.copy(is, tmp.resolve(file), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                Utils.moveQuietly((Path)tmp, (Path)dir);
                string = path.toAbsolutePath().toString();
                if (tmp == null) break block34;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to extract PaddlePaddle native library", e);
            }
            finally {
                if (tmp != null) {
                    Utils.deleteQuietly(tmp);
                }
            }
            Utils.deleteQuietly((Path)tmp);
        }
        return string;
    }

    private static String findLibraryInPath(String libPath) {
        String[] paths = libPath.split(File.pathSeparator);
        String mappedLibNames = System.mapLibraryName(NATIVE_LIB_NAME);
        for (String path : paths) {
            File p = new File(path);
            if (!p.exists()) continue;
            if (p.isFile() && p.getName().endsWith(mappedLibNames)) {
                return p.getAbsolutePath();
            }
            File file = new File(path, mappedLibNames);
            if (!file.exists() || !file.isFile()) continue;
            return file.getAbsolutePath();
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private static String downloadLibrary(Platform platform, AtomicBoolean fallback) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

