/*
 * Decompiled with CFR 0.152.
 */
package cc.openkit.kitChat.rongcloud.rong.methods;

import cc.openkit.kitChat.rongcloud.rong.models.ChatRoomInfo;
import cc.openkit.kitChat.rongcloud.rong.models.ChatroomQueryResult;
import cc.openkit.kitChat.rongcloud.rong.models.ChatroomUserQueryResult;
import cc.openkit.kitChat.rongcloud.rong.models.CodeSuccessResult;
import cc.openkit.kitChat.rongcloud.rong.models.ListBlockChatroomUserResult;
import cc.openkit.kitChat.rongcloud.rong.models.ListGagChatroomUserResult;
import cc.openkit.kitChat.rongcloud.rong.util.GsonUtil;
import cc.openkit.kitChat.rongcloud.rong.util.HostType;
import cc.openkit.kitChat.rongcloud.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URLEncoder;

public class Chatroom {
    private static final String UTF8 = "UTF-8";
    private String appKey;
    private String appSecret;

    public Chatroom(String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public CodeSuccessResult create(ChatRoomInfo[] chatRoomInfo) throws Exception {
        if (chatRoomInfo == null) {
            throw new IllegalArgumentException("Paramer 'chatRoomInfo' is required");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < chatRoomInfo.length; ++i) {
            ChatRoomInfo child = chatRoomInfo[i];
            sb.append("&chatroom[" + child.getId() + "]=").append(URLEncoder.encode(child.getName(), UTF8));
        }
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/chatroom/create.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (CodeSuccessResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), CodeSuccessResult.class);
    }

    public CodeSuccessResult join(String[] userId, String chatroomId) throws Exception {
        if (userId == null) {
            throw new IllegalArgumentException("Paramer 'userId' is required");
        }
        if (chatroomId == null) {
            throw new IllegalArgumentException("Paramer 'chatroomId' is required");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < userId.length; ++i) {
            String child = userId[i];
            sb.append("&userId=").append(URLEncoder.encode(child, UTF8));
        }
        sb.append("&chatroomId=").append(URLEncoder.encode(chatroomId.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/chatroom/join.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (CodeSuccessResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), CodeSuccessResult.class);
    }

    public ChatroomQueryResult query(String[] chatroomId) throws Exception {
        if (chatroomId == null) {
            throw new IllegalArgumentException("Paramer 'chatroomId' is required");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < chatroomId.length; ++i) {
            String child = chatroomId[i];
            sb.append("&chatroomId=").append(URLEncoder.encode(child, UTF8));
        }
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/chatroom/query.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (ChatroomQueryResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), ChatroomQueryResult.class);
    }

    public ChatroomUserQueryResult queryUser(String chatroomId, String count, String order) throws Exception {
        if (chatroomId == null) {
            throw new IllegalArgumentException("Paramer 'chatroomId' is required");
        }
        if (count == null) {
            throw new IllegalArgumentException("Paramer 'count' is required");
        }
        if (order == null) {
            throw new IllegalArgumentException("Paramer 'order' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&chatroomId=").append(URLEncoder.encode(chatroomId.toString(), UTF8));
        sb.append("&count=").append(URLEncoder.encode(count.toString(), UTF8));
        sb.append("&order=").append(URLEncoder.encode(order.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/chatroom/user/query.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (ChatroomUserQueryResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), ChatroomUserQueryResult.class);
    }

    public CodeSuccessResult stopDistributionMessage(String chatroomId) throws Exception {
        if (chatroomId == null) {
            throw new IllegalArgumentException("Paramer 'chatroomId' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&chatroomId=").append(URLEncoder.encode(chatroomId.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/chatroom/message/stopDistribution.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (CodeSuccessResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), CodeSuccessResult.class);
    }

    public CodeSuccessResult resumeDistributionMessage(String chatroomId) throws Exception {
        if (chatroomId == null) {
            throw new IllegalArgumentException("Paramer 'chatroomId' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&chatroomId=").append(URLEncoder.encode(chatroomId.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/chatroom/message/resumeDistribution.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (CodeSuccessResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), CodeSuccessResult.class);
    }

    public CodeSuccessResult addGagUser(String userId, String chatroomId, String minute) throws Exception {
        if (userId == null) {
            throw new IllegalArgumentException("Paramer 'userId' is required");
        }
        if (chatroomId == null) {
            throw new IllegalArgumentException("Paramer 'chatroomId' is required");
        }
        if (minute == null) {
            throw new IllegalArgumentException("Paramer 'minute' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&userId=").append(URLEncoder.encode(userId.toString(), UTF8));
        sb.append("&chatroomId=").append(URLEncoder.encode(chatroomId.toString(), UTF8));
        sb.append("&minute=").append(URLEncoder.encode(minute.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/chatroom/user/gag/add.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (CodeSuccessResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), CodeSuccessResult.class);
    }

    public ListGagChatroomUserResult ListGagUser(String chatroomId) throws Exception {
        if (chatroomId == null) {
            throw new IllegalArgumentException("Paramer 'chatroomId' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&chatroomId=").append(URLEncoder.encode(chatroomId.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/chatroom/user/gag/list.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (ListGagChatroomUserResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), ListGagChatroomUserResult.class);
    }

    public CodeSuccessResult rollbackGagUser(String userId, String chatroomId) throws Exception {
        if (userId == null) {
            throw new IllegalArgumentException("Paramer 'userId' is required");
        }
        if (chatroomId == null) {
            throw new IllegalArgumentException("Paramer 'chatroomId' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&userId=").append(URLEncoder.encode(userId.toString(), UTF8));
        sb.append("&chatroomId=").append(URLEncoder.encode(chatroomId.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/chatroom/user/gag/rollback.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (CodeSuccessResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), CodeSuccessResult.class);
    }

    public CodeSuccessResult addBlockUser(String userId, String chatroomId, String minute) throws Exception {
        if (userId == null) {
            throw new IllegalArgumentException("Paramer 'userId' is required");
        }
        if (chatroomId == null) {
            throw new IllegalArgumentException("Paramer 'chatroomId' is required");
        }
        if (minute == null) {
            throw new IllegalArgumentException("Paramer 'minute' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&userId=").append(URLEncoder.encode(userId.toString(), UTF8));
        sb.append("&chatroomId=").append(URLEncoder.encode(chatroomId.toString(), UTF8));
        sb.append("&minute=").append(URLEncoder.encode(minute.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/chatroom/user/block/add.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (CodeSuccessResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), CodeSuccessResult.class);
    }

    public ListBlockChatroomUserResult getListBlockUser(String chatroomId) throws Exception {
        if (chatroomId == null) {
            throw new IllegalArgumentException("Paramer 'chatroomId' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&chatroomId=").append(URLEncoder.encode(chatroomId.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/chatroom/user/block/list.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (ListBlockChatroomUserResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), ListBlockChatroomUserResult.class);
    }

    public CodeSuccessResult rollbackBlockUser(String userId, String chatroomId) throws Exception {
        if (userId == null) {
            throw new IllegalArgumentException("Paramer 'userId' is required");
        }
        if (chatroomId == null) {
            throw new IllegalArgumentException("Paramer 'chatroomId' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&userId=").append(URLEncoder.encode(userId.toString(), UTF8));
        sb.append("&chatroomId=").append(URLEncoder.encode(chatroomId.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/chatroom/user/block/rollback.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (CodeSuccessResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), CodeSuccessResult.class);
    }

    public CodeSuccessResult addPriority(String[] objectName) throws Exception {
        if (objectName == null) {
            throw new IllegalArgumentException("Paramer 'objectName' is required");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < objectName.length; ++i) {
            String child = objectName[i];
            sb.append("&objectName=").append(URLEncoder.encode(child, UTF8));
        }
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/chatroom/message/priority/add.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (CodeSuccessResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), CodeSuccessResult.class);
    }

    public CodeSuccessResult destroy(String[] chatroomId) throws Exception {
        if (chatroomId == null) {
            throw new IllegalArgumentException("Paramer 'chatroomId' is required");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < chatroomId.length; ++i) {
            String child = chatroomId[i];
            sb.append("&chatroomId=").append(URLEncoder.encode(child, UTF8));
        }
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/chatroom/destroy.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (CodeSuccessResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), CodeSuccessResult.class);
    }

    public CodeSuccessResult addWhiteListUser(String chatroomId, String[] userId) throws Exception {
        if (chatroomId == null) {
            throw new IllegalArgumentException("Paramer 'chatroomId' is required");
        }
        if (userId == null) {
            throw new IllegalArgumentException("Paramer 'userId' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&chatroomId=").append(URLEncoder.encode(chatroomId.toString(), UTF8));
        for (int i = 0; i < userId.length; ++i) {
            String child = userId[i];
            sb.append("&userId=").append(URLEncoder.encode(child, UTF8));
        }
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/chatroom/user/whitelist/add.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (CodeSuccessResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), CodeSuccessResult.class);
    }
}

