/*
 * Decompiled with CFR 0.152.
 */
package cc.openkit.kitChat.rongcloud.rong.methods;

import cc.openkit.kitChat.rongcloud.rong.models.SMSImageCodeResult;
import cc.openkit.kitChat.rongcloud.rong.models.SMSSendCodeResult;
import cc.openkit.kitChat.rongcloud.rong.models.SMSVerifyCodeResult;
import cc.openkit.kitChat.rongcloud.rong.util.GsonUtil;
import cc.openkit.kitChat.rongcloud.rong.util.HostType;
import cc.openkit.kitChat.rongcloud.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URLEncoder;

public class SMS {
    private static final String UTF8 = "UTF-8";
    private String appKey;
    private String appSecret;

    public SMS(String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public SMSImageCodeResult getImageCode(String appKey) throws Exception {
        if (appKey == null) {
            throw new IllegalArgumentException("Paramer 'appKey' is required");
        }
        StringBuilder sb = new StringBuilder(HostType.SMS.getStrType() + "/getImgCode.json");
        sb.append("?appKey=").append(URLEncoder.encode(appKey, UTF8));
        HttpURLConnection conn = HttpUtil.CreateGetHttpConnection(sb.toString());
        return (SMSImageCodeResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), SMSImageCodeResult.class);
    }

    public SMSSendCodeResult sendCode(String mobile, String templateId, String region, String verifyId, String verifyCode) throws Exception {
        String body;
        if (mobile == null) {
            throw new IllegalArgumentException("Paramer 'mobile' is required");
        }
        if (templateId == null) {
            throw new IllegalArgumentException("Paramer 'templateId' is required");
        }
        if (region == null) {
            throw new IllegalArgumentException("Paramer 'region' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&mobile=").append(URLEncoder.encode(mobile.toString(), UTF8));
        sb.append("&templateId=").append(URLEncoder.encode(templateId.toString(), UTF8));
        sb.append("&region=").append(URLEncoder.encode(region.toString(), UTF8));
        if (verifyId != null) {
            sb.append("&verifyId=").append(URLEncoder.encode(verifyId.toString(), UTF8));
        }
        if (verifyCode != null) {
            sb.append("&verifyCode=").append(URLEncoder.encode(verifyCode.toString(), UTF8));
        }
        if ((body = sb.toString()).indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.SMS, this.appKey, this.appSecret, "/sendCode.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (SMSSendCodeResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), SMSSendCodeResult.class);
    }

    public SMSVerifyCodeResult verifyCode(String sessionId, String code) throws Exception {
        if (sessionId == null) {
            throw new IllegalArgumentException("Paramer 'sessionId' is required");
        }
        if (code == null) {
            throw new IllegalArgumentException("Paramer 'code' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&sessionId=").append(URLEncoder.encode(sessionId.toString(), UTF8));
        sb.append("&code=").append(URLEncoder.encode(code.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.SMS, this.appKey, this.appSecret, "/verifyCode.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (SMSVerifyCodeResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), SMSVerifyCodeResult.class);
    }
}

