/*
 * Decompiled with CFR 0.152.
 */
package cc.openkit.kitChat.rongcloud.rong.methods;

import cc.openkit.kitChat.rongcloud.rong.models.CheckOnlineResult;
import cc.openkit.kitChat.rongcloud.rong.models.CodeSuccessResult;
import cc.openkit.kitChat.rongcloud.rong.models.QueryBlacklistUserResult;
import cc.openkit.kitChat.rongcloud.rong.models.QueryBlockUserResult;
import cc.openkit.kitChat.rongcloud.rong.models.TokenResult;
import cc.openkit.kitChat.rongcloud.rong.util.GsonUtil;
import cc.openkit.kitChat.rongcloud.rong.util.HostType;
import cc.openkit.kitChat.rongcloud.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URLEncoder;

public class User {
    private static final String UTF8 = "UTF-8";
    private String appKey;
    private String appSecret;

    public User(String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public TokenResult getToken(String userId, String name, String portraitUri) throws Exception {
        if (userId == null) {
            throw new IllegalArgumentException("Paramer 'userId' is required");
        }
        if (name == null) {
            throw new IllegalArgumentException("Paramer 'name' is required");
        }
        if (portraitUri == null) {
            throw new IllegalArgumentException("Paramer 'portraitUri' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&userId=").append(URLEncoder.encode(userId.toString(), UTF8));
        sb.append("&name=").append(URLEncoder.encode(name.toString(), UTF8));
        sb.append("&portraitUri=").append(URLEncoder.encode(portraitUri.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/user/getToken.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (TokenResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), TokenResult.class);
    }

    public CodeSuccessResult refresh(String userId, String name, String portraitUri) throws Exception {
        String body;
        if (userId == null) {
            throw new IllegalArgumentException("Paramer 'userId' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&userId=").append(URLEncoder.encode(userId.toString(), UTF8));
        if (name != null) {
            sb.append("&name=").append(URLEncoder.encode(name.toString(), UTF8));
        }
        if (portraitUri != null) {
            sb.append("&portraitUri=").append(URLEncoder.encode(portraitUri.toString(), UTF8));
        }
        if ((body = sb.toString()).indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/user/refresh.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (CodeSuccessResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), CodeSuccessResult.class);
    }

    public CheckOnlineResult checkOnline(String userId) throws Exception {
        if (userId == null) {
            throw new IllegalArgumentException("Paramer 'userId' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&userId=").append(URLEncoder.encode(userId.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/user/checkOnline.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (CheckOnlineResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), CheckOnlineResult.class);
    }

    public CodeSuccessResult block(String userId, Integer minute) throws Exception {
        if (userId == null) {
            throw new IllegalArgumentException("Paramer 'userId' is required");
        }
        if (minute == null) {
            throw new IllegalArgumentException("Paramer 'minute' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&userId=").append(URLEncoder.encode(userId.toString(), UTF8));
        sb.append("&minute=").append(URLEncoder.encode(minute.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/user/block.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (CodeSuccessResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), CodeSuccessResult.class);
    }

    public CodeSuccessResult unBlock(String userId) throws Exception {
        if (userId == null) {
            throw new IllegalArgumentException("Paramer 'userId' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&userId=").append(URLEncoder.encode(userId.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/user/unblock.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (CodeSuccessResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), CodeSuccessResult.class);
    }

    public QueryBlockUserResult queryBlock() throws Exception {
        StringBuilder sb = new StringBuilder();
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/user/block/query.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (QueryBlockUserResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), QueryBlockUserResult.class);
    }

    public CodeSuccessResult addBlacklist(String userId, String blackUserId) throws Exception {
        if (userId == null) {
            throw new IllegalArgumentException("Paramer 'userId' is required");
        }
        if (blackUserId == null) {
            throw new IllegalArgumentException("Paramer 'blackUserId' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&userId=").append(URLEncoder.encode(userId.toString(), UTF8));
        sb.append("&blackUserId=").append(URLEncoder.encode(blackUserId.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/user/blacklist/add.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (CodeSuccessResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), CodeSuccessResult.class);
    }

    public QueryBlacklistUserResult queryBlacklist(String userId) throws Exception {
        if (userId == null) {
            throw new IllegalArgumentException("Paramer 'userId' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&userId=").append(URLEncoder.encode(userId.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/user/blacklist/query.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (QueryBlacklistUserResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), QueryBlacklistUserResult.class);
    }

    public CodeSuccessResult removeBlacklist(String userId, String blackUserId) throws Exception {
        if (userId == null) {
            throw new IllegalArgumentException("Paramer 'userId' is required");
        }
        if (blackUserId == null) {
            throw new IllegalArgumentException("Paramer 'blackUserId' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&userId=").append(URLEncoder.encode(userId.toString(), UTF8));
        sb.append("&blackUserId=").append(URLEncoder.encode(blackUserId.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/user/blacklist/remove.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (CodeSuccessResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), CodeSuccessResult.class);
    }
}

