/*
 * Decompiled with CFR 0.152.
 */
package cc.openkit.kitIsNull;

import cc.openkit.common.KitUtil;
import cc.openkit.kitIsNull.KitIsCode;
import cc.openkit.kitIsNull.KitIsEmail;
import cc.openkit.kitIsNull.KitIsLong;
import cc.openkit.kitIsNull.KitIsNull;
import cc.openkit.kitIsNull.KitIsOther;
import cc.openkit.kitIsNull.KitIsPhone;
import cc.openkit.kitIsNull.KitIsPlus;
import cc.openkit.kitIsNull.KitIsUrl;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class KitVerification {
    public static final String REGEX_USERNAME = "^[a-zA-Z]\\w{5,20}$";
    public static final String REGEX_PASSWORD = "^[a-zA-Z0-9]{6,20}$";
    public static final String REGEX_MOBILE = "^((17[0-9])|(14[0-9])|(13[0-9])|(15[^4,\\D])|(18[0,5-9]))\\d{8}$";
    public static final String REGEX_EMAIL = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
    public static final String REGEX_CHINESE = "^[\u4e00-\u9fa5],{0,}$";
    public static final String REGEX_ID_CARD = "(^\\d{18}$)|(^\\d{15}$)";
    public static final String REGEX_URL = "http(s)?://([\\w-]+\\.)+[\\w-]+(/[\\w- ./?%&=]*)?";
    public static final String REGEX_IP_ADDR = "^(1\\\\d{2}|2[0-4]\\\\d|25[0-5]|[1-9]\\\\d|[1-9])\\\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.";

    public static Map<String, Object> verification(Object model) {
        Field[] fArray;
        HashMap<String, Object> map = new HashMap();
        Class<?> c = model.getClass();
        for (Field field : fArray = c.getDeclaredFields()) {
            String filedName = field.getName();
            String getMethodName = "get" + filedName.substring(0, 1).toUpperCase() + filedName.substring(1);
            Object filedValue = null;
            try {
                Method getMethod = c.getMethod(getMethodName, new Class[0]);
                filedValue = getMethod.invoke(model, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            boolean kitIsPlusExists = field.isAnnotationPresent(KitIsPlus.class);
            if (kitIsPlusExists) {
                KitIsPlus kitIsPlus = field.getAnnotation(KitIsPlus.class);
                String condition = kitIsPlus.condition();
                String rule = kitIsPlus.rule();
                String value = kitIsPlus.value();
                Boolean f = false;
                String[] conditionArray = condition.split(",");
                String[] valueArray = value.split(",");
                for (int i = 0; i < conditionArray.length; ++i) {
                    String[] caa = conditionArray[i].split(":");
                    if (caa.length > 1) {
                        if ("min".equals(caa[0]) && !(f = Boolean.valueOf(String.valueOf(filedValue).length() > Integer.parseInt(caa[1]))).booleanValue()) {
                            return KitUtil.returnMap("101", valueArray[i]);
                        }
                        if (!"max".equals(caa[0]) || (f = Boolean.valueOf(String.valueOf(filedValue).length() < Integer.parseInt(caa[1]))).booleanValue()) continue;
                        return KitUtil.returnMap("101", valueArray[i]);
                    }
                    if ("phone".equals(conditionArray[i])) {
                        if (KitVerification.isMobile(String.valueOf(filedValue))) continue;
                        map = KitUtil.returnMap("101", valueArray[i]);
                        return map;
                    }
                    if ("code".equals(conditionArray[i])) {
                        if (KitVerification.isIDCard(String.valueOf(filedValue))) continue;
                        map = KitUtil.returnMap("101", valueArray[i]);
                        return map;
                    }
                    if ("email".equals(conditionArray[i])) {
                        if (KitVerification.isEmail(String.valueOf(filedValue))) continue;
                        map = KitUtil.returnMap("101", valueArray[i]);
                        return map;
                    }
                    if ("null".equals(conditionArray[i])) {
                        if (filedValue != null && !"".equals(filedValue)) continue;
                        map = KitUtil.returnMap("101", valueArray[i]);
                        return map;
                    }
                    if (!"url".equals(conditionArray[i]) || KitVerification.isUrl(String.valueOf(filedValue))) continue;
                    map = KitUtil.returnMap("101", valueArray[i]);
                    return map;
                }
                if (!KitUtil.feikong(rule).booleanValue() || KitVerification.isOther(rule, String.valueOf(filedValue))) continue;
                map = KitUtil.returnMap("101", valueArray[valueArray.length - 1]);
                return map;
            }
            boolean fExists = field.isAnnotationPresent(KitIsNull.class);
            if (fExists) {
                if (filedValue != null && !"".equals(filedValue)) continue;
                KitIsNull isNull = field.getAnnotation(KitIsNull.class);
                String msg = isNull.value();
                map = KitUtil.returnMap("101", msg);
                return map;
            }
            if (filedValue == null || "".equals(filedValue)) continue;
            boolean kitIsPhoneExists = field.isAnnotationPresent(KitIsPhone.class);
            if (kitIsPhoneExists) {
                if (KitVerification.isMobile(String.valueOf(filedValue))) continue;
                KitIsPhone isNull = field.getAnnotation(KitIsPhone.class);
                String msg = isNull.value();
                map = KitUtil.returnMap("101", msg);
                return map;
            }
            boolean kitIsEmailExists = field.isAnnotationPresent(KitIsEmail.class);
            if (kitIsEmailExists) {
                if (KitVerification.isEmail(String.valueOf(filedValue))) continue;
                KitIsEmail isNull = field.getAnnotation(KitIsEmail.class);
                String msg = isNull.value();
                map = KitUtil.returnMap("101", msg);
                return map;
            }
            boolean kitIsCodeExists = field.isAnnotationPresent(KitIsCode.class);
            if (kitIsCodeExists) {
                if (KitVerification.isIDCard(String.valueOf(filedValue))) continue;
                KitIsCode isNull = field.getAnnotation(KitIsCode.class);
                String msg = isNull.value();
                map = KitUtil.returnMap("101", msg);
                return map;
            }
            boolean kitIsLongExists = field.isAnnotationPresent(KitIsLong.class);
            if (kitIsLongExists) {
                KitIsLong isNull = field.getAnnotation(KitIsLong.class);
                int min = isNull.min();
                int max = isNull.max();
                Boolean f = false;
                if (min == -1 && max != -1) {
                    f = String.valueOf(filedValue).length() < max;
                }
                if (min != -1 && max == -1) {
                    f = String.valueOf(filedValue).length() > min;
                }
                if (min == -1 && max == -1) {
                    f = true;
                }
                if (min != -1 && max != -1) {
                    f = String.valueOf(filedValue).length() > min && String.valueOf(filedValue).length() < max;
                }
                if (f.booleanValue()) continue;
                String msg = isNull.value();
                map = KitUtil.returnMap("101", msg);
                return map;
            }
            boolean kitIsUrlExists = field.isAnnotationPresent(KitIsUrl.class);
            if (kitIsUrlExists) {
                if (KitVerification.isUrl(String.valueOf(filedValue))) continue;
                KitIsUrl isNull = field.getAnnotation(KitIsUrl.class);
                String msg = isNull.value();
                map = KitUtil.returnMap("101", msg);
                return map;
            }
            boolean kitIsOtherExists = field.isAnnotationPresent(KitIsOther.class);
            KitIsOther isNull = field.getAnnotation(KitIsOther.class);
            if (!kitIsOtherExists) continue;
            boolean a = KitVerification.isOther(isNull.rule(), String.valueOf(filedValue));
            System.out.println("a = " + a);
            if (KitVerification.isOther(isNull.rule(), String.valueOf(filedValue))) continue;
            String msg = isNull.value();
            map = KitUtil.returnMap("101", msg);
            return map;
        }
        map = KitUtil.returnMap("200", "");
        return map;
    }

    public static boolean isUsername(String username) {
        return Pattern.matches(REGEX_USERNAME, username);
    }

    public static boolean isPassword(String password) {
        return Pattern.matches(REGEX_PASSWORD, password);
    }

    public static boolean isMobile(String mobile) {
        return Pattern.matches(REGEX_MOBILE, mobile);
    }

    public static boolean isEmail(String email) {
        return Pattern.matches(REGEX_EMAIL, email);
    }

    public static boolean isChinese(String chinese) {
        return Pattern.matches(REGEX_CHINESE, chinese);
    }

    public static boolean isIDCard(String idCard) {
        return Pattern.matches(REGEX_ID_CARD, idCard);
    }

    public static boolean isUrl(String url) {
        return Pattern.matches(REGEX_URL, url);
    }

    public static boolean isIPAddr(String ipAddr) {
        return Pattern.matches(REGEX_IP_ADDR, ipAddr);
    }

    public static boolean isOther(String rule, String ipAddr) {
        return Pattern.matches(rule, ipAddr);
    }
}

