/*
 * Decompiled with CFR 0.152.
 */
package cc.openkit.kitPay.weichart.handler;

import cc.openkit.kitPay.weichart.util.HttpClientUtil;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public class TenpayHttpClient {
    private String reqContent = "";
    private String resContent = "";
    private String method = "POST";
    private String errInfo = "";
    private int timeOut = 30;
    private int responseCode = 0;
    private String charset = "utf8";
    private InputStream inputStream = null;

    public void setReqContent(String reqContent) {
        this.reqContent = reqContent;
    }

    public String getResContent() {
        try {
            this.doResponse();
        }
        catch (IOException e) {
            this.errInfo = e.getMessage();
        }
        return this.resContent;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getErrInfo() {
        return this.errInfo;
    }

    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    protected void callHttp() throws IOException {
        if ("POST".equals(this.method.toUpperCase())) {
            String url = HttpClientUtil.getURL(this.reqContent);
            String queryString = HttpClientUtil.getQueryString(this.reqContent);
            byte[] postData = queryString.getBytes(this.charset);
            this.httpPostMethod(url, postData);
            return;
        }
        this.httpGetMethod(this.reqContent);
    }

    public boolean callHttpPost(String url, String postdata) {
        boolean flag = false;
        try {
            byte[] postData = postdata.getBytes(this.charset);
            this.httpPostMethod(url, postData);
            flag = true;
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return flag;
    }

    protected void httpPostMethod(String url, byte[] postData) throws IOException {
        HttpURLConnection conn = HttpClientUtil.getHttpURLConnection(url);
        this.doPost(conn, postData);
    }

    protected void httpGetMethod(String url) throws IOException {
        HttpURLConnection httpConnection = HttpClientUtil.getHttpURLConnection(url);
        this.setHttpRequest(httpConnection);
        httpConnection.setRequestMethod("GET");
        this.responseCode = httpConnection.getResponseCode();
        this.inputStream = httpConnection.getInputStream();
    }

    protected void httpsGetMethod(String url, SSLContext sslContext) throws IOException {
        SSLSocketFactory sf = sslContext.getSocketFactory();
        HttpsURLConnection conn = HttpClientUtil.getHttpsURLConnection(url);
        conn.setSSLSocketFactory(sf);
        this.doGet(conn);
    }

    protected void httpsPostMethod(String url, byte[] postData, SSLContext sslContext) throws IOException {
        SSLSocketFactory sf = sslContext.getSocketFactory();
        HttpsURLConnection conn = HttpClientUtil.getHttpsURLConnection(url);
        conn.setSSLSocketFactory(sf);
        this.doPost(conn, postData);
    }

    protected void setHttpRequest(HttpURLConnection httpConnection) {
        httpConnection.setConnectTimeout(this.timeOut * 1000);
        httpConnection.setUseCaches(false);
        httpConnection.setDoInput(true);
        httpConnection.setDoOutput(true);
    }

    protected void doResponse() throws IOException {
        if (null == this.inputStream) {
            return;
        }
        this.resContent = HttpClientUtil.InputStreamTOString(this.inputStream, this.charset);
        this.inputStream.close();
    }

    protected void doPost(HttpURLConnection conn, byte[] postData) throws IOException {
        conn.setRequestMethod("POST");
        this.setHttpRequest(conn);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        BufferedOutputStream out = new BufferedOutputStream(conn.getOutputStream());
        int len = 1024;
        HttpClientUtil.doOutput(out, postData, 1024);
        out.close();
        this.responseCode = conn.getResponseCode();
        this.inputStream = conn.getInputStream();
    }

    protected void doGet(HttpURLConnection conn) throws IOException {
        conn.setRequestMethod("GET");
        this.setHttpRequest(conn);
        this.responseCode = conn.getResponseCode();
        this.inputStream = conn.getInputStream();
    }
}

