/*
 * Decompiled with CFR 0.152.
 */
package cc.openkit.kitPush.jiguang.service;

import cc.openkit.kitPush.jiguang.model.JPushModel;
import cn.jiguang.common.ClientConfig;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jpush.api.JPushClient;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.Message;
import cn.jpush.api.push.model.Options;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import cn.jpush.api.push.model.notification.AndroidNotification;
import cn.jpush.api.push.model.notification.IosNotification;
import cn.jpush.api.push.model.notification.Notification;
import cn.jpush.api.push.model.notification.PlatformNotification;
import org.apache.log4j.Logger;

public class JPushService {
    private static Logger LOG = Logger.getLogger(JPushService.class);

    public static PushResult touAll(JPushModel jPushModel) {
        JPushClient jpushClient = JPushService.getjPushConfig(jPushModel);
        PushPayload payload = JPushService.buildPushObject_tou_all(jPushModel);
        PushResult result = null;
        return JPushService.getPushResult(jpushClient, payload, result);
    }

    public static PushPayload buildPushObject_tou_all(JPushModel jPushModel) {
        return PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.all()).setMessage(Message.newBuilder().addExtras(jPushModel.getExtras()).setMsgContent(jPushModel.getCon()).build()).build();
    }

    public static PushResult touGroup(JPushModel jPushModel) {
        JPushClient jpushClient = JPushService.getjPushConfig(jPushModel);
        PushPayload payload = JPushService.buildPushObject_tou_group(jPushModel);
        PushResult result = null;
        return JPushService.getPushResult(jpushClient, payload, result);
    }

    public static PushPayload buildPushObject_tou_group(JPushModel jPushModel) {
        return PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.alias((String[])jPushModel.getUserid())).setMessage(Message.newBuilder().addExtras(jPushModel.getExtras()).setMsgContent(jPushModel.getCon()).build()).build();
    }

    public static PushResult tuiAll(JPushModel jPushModel) {
        JPushClient jpushClient = JPushService.getjPushConfig(jPushModel);
        PushPayload payload = JPushService.buildPushObject_tui_all(jPushModel);
        PushResult result = null;
        return JPushService.getPushResult(jpushClient, payload, result);
    }

    public static PushPayload buildPushObject_tui_all(JPushModel jPushModel) {
        return PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.all()).setNotification(Notification.newBuilder().addPlatformNotification((PlatformNotification)((IosNotification.Builder)IosNotification.newBuilder().setAlert((Object)jPushModel.getCon()).setSound(jPushModel.getSound()).addExtras(jPushModel.getExtras())).build()).addPlatformNotification((PlatformNotification)((AndroidNotification.Builder)AndroidNotification.newBuilder().setAlert((Object)jPushModel.getCon()).addExtras(jPushModel.getExtras())).build()).build()).setOptions(Options.newBuilder().setApnsProduction(true).build()).build();
    }

    public static PushResult tuiGroup(JPushModel jPushModel) {
        JPushClient jpushClient = JPushService.getjPushConfig(jPushModel);
        PushPayload payload = JPushService.buildPushObject_tui_group(jPushModel);
        PushResult result = null;
        return JPushService.getPushResult(jpushClient, payload, result);
    }

    public static PushPayload buildPushObject_tui_group(JPushModel jPushModel) {
        return PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.alias((String[])jPushModel.getUserid())).setNotification(Notification.newBuilder().addPlatformNotification((PlatformNotification)((IosNotification.Builder)IosNotification.newBuilder().setAlert((Object)jPushModel.getCon()).setSound(jPushModel.getSound()).addExtras(jPushModel.getExtras())).build()).addPlatformNotification((PlatformNotification)((AndroidNotification.Builder)AndroidNotification.newBuilder().setAlert((Object)jPushModel.getCon()).addExtras(jPushModel.getExtras())).build()).build()).setOptions(Options.newBuilder().setApnsProduction(true).build()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PushResult getPushResult(JPushClient jpushClient, PushPayload payload, PushResult result) {
        try {
            result = jpushClient.sendPush(payload);
            LOG.info((Object)("Got result - " + result));
            jpushClient.close();
        }
        catch (APIConnectionException e) {
            LOG.error((Object)"Connection error, should retry later", (Throwable)e);
        }
        catch (APIRequestException e) {
            LOG.error((Object)"Should review the error, and fix the request", (Throwable)e);
            LOG.info((Object)("HTTP Status: " + e.getStatus()));
            LOG.info((Object)("Error Code: " + e.getErrorCode()));
            LOG.info((Object)("Error Message: " + e.getErrorMessage()));
        }
        finally {
            return result;
        }
    }

    private static JPushClient getjPushConfig(JPushModel jPushModel) {
        String MASTERSECRET = jPushModel.getMastersecret();
        String APPKEY = jPushModel.getAppkey();
        return new JPushClient(MASTERSECRET, APPKEY, null, ClientConfig.getInstance());
    }
}

