/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.img;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.util.ImageUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class Img {
    private BufferedImage srcImage;
    private BufferedImage destImage;
    private String destImageType = "jpg";

    public static Img from(File imageFile) {
        return new Img(ImageUtil.read(imageFile));
    }

    public static Img from(InputStream in) {
        return new Img(ImageUtil.read(in));
    }

    public static Img from(ImageInputStream imageStream) {
        return new Img(ImageUtil.read(imageStream));
    }

    public static Img from(URL imageUrl) {
        return new Img(ImageUtil.read(imageUrl));
    }

    public static Img from(Image image) {
        return new Img(ImageUtil.toBufferedImage(image));
    }

    public Img(BufferedImage srcImage) {
        this.srcImage = srcImage;
    }

    public Img setDestImageType(String imgType) {
        this.destImageType = imgType;
        return this;
    }

    public Img scale(float scale) {
        if (scale < 0.0f) {
            scale = -scale;
        }
        BufferedImage srcImg = this.srcImage;
        int width = NumberUtil.mul(Integer.toString(srcImg.getWidth()), Float.toString(scale)).intValue();
        int height = NumberUtil.mul(Integer.toString(srcImg.getHeight()), Float.toString(scale)).intValue();
        return this.scale(width, height);
    }

    public Img scale(int width, int height) {
        BufferedImage srcImg = this.srcImage;
        int srcHeight = srcImg.getHeight();
        int srcWidth = srcImg.getWidth();
        if (srcHeight == height && srcWidth == width) {
            this.destImage = srcImg;
            return this;
        }
        int scaleType = srcHeight < height || srcWidth < width ? 4 : 1;
        Image image = srcImg.getScaledInstance(width, height, scaleType);
        this.destImage = ImageUtil.toBufferedImage(image);
        return this;
    }

    public Img scale(int width, int height, Color fixedColor) {
        double widthRatio;
        BufferedImage srcImage = this.srcImage;
        int srcHeight = srcImage.getHeight(null);
        int srcWidth = srcImage.getWidth(null);
        double heightRatio = NumberUtil.div((float)height, (float)srcHeight);
        if (heightRatio == (widthRatio = NumberUtil.div((float)width, (float)srcWidth))) {
            return this.scale(width, height);
        }
        if (widthRatio < heightRatio) {
            this.scale(width, (int)((double)srcHeight * widthRatio));
        } else {
            this.scale((int)((double)srcWidth * heightRatio), height);
        }
        if (null == fixedColor) {
            fixedColor = Color.WHITE;
        }
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g = image.createGraphics();
        g.setBackground(fixedColor);
        g.clearRect(0, 0, width, height);
        BufferedImage itemp = this.destImage;
        int itempHeight = itemp.getHeight();
        int itempWidth = itemp.getWidth();
        g.drawImage(itemp, (width - itempWidth) / 2, (height - itempHeight) / 2, itempWidth, itempHeight, fixedColor, null);
        g.dispose();
        this.destImage = image;
        return this;
    }

    public Img cut(Rectangle rectangle) {
        CropImageFilter cropFilter = new CropImageFilter(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Image image = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(this.srcImage.getSource(), cropFilter));
        this.destImage = ImageUtil.toBufferedImage(image);
        return this;
    }

    public Img gray() {
        ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        this.destImage = op.filter(this.srcImage, null);
        return this;
    }

    public Img binary() {
        this.destImage = ImageUtil.copyImage(this.srcImage, 12);
        return this;
    }

    public Img pressText(String pressText, Color color, Font font, int x, int y, float alpha) {
        BufferedImage destImage = this.srcImage;
        Graphics2D g = destImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(color);
        g.setFont(font);
        g.setComposite(AlphaComposite.getInstance(10, alpha));
        FontMetrics metrics = g.getFontMetrics(font);
        int textLength = metrics.stringWidth(pressText);
        int textHeight = metrics.getAscent() - metrics.getLeading() - metrics.getDescent();
        g.drawString(pressText, Math.abs(destImage.getWidth() - textLength) / 2 + x, Math.abs(destImage.getHeight() + textHeight) / 2 + y);
        g.dispose();
        this.destImage = destImage;
        return this;
    }

    public Img pressImage(Image pressImg, int x, int y, float alpha) {
        int pressImgWidth = pressImg.getWidth(null);
        int pressImgHeight = pressImg.getHeight(null);
        return this.pressImage(pressImg, new Rectangle(x, y, pressImgWidth, pressImgHeight), alpha);
    }

    public Img pressImage(Image pressImg, Rectangle rectangle, float alpha) {
        BufferedImage destImg = this.srcImage;
        Img.draw(destImg, pressImg, rectangle, alpha);
        this.destImage = destImg;
        return this;
    }

    public Img rotate(int degree) {
        BufferedImage image = this.srcImage;
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage destImg = new BufferedImage(width, height, this.getTypeInt());
        Graphics2D graphics2d = destImg.createGraphics();
        graphics2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2d.rotate(Math.toRadians(degree), width / 2, height / 2);
        graphics2d.drawImage((Image)image, 0, 0, null);
        graphics2d.dispose();
        this.destImage = destImg;
        return this;
    }

    public Img flip() {
        BufferedImage image = this.srcImage;
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage destImg = new BufferedImage(width, height, this.getTypeInt());
        Graphics2D graphics2d = destImg.createGraphics();
        graphics2d.drawImage(image, 0, 0, width, height, width, 0, 0, height, null);
        graphics2d.dispose();
        this.destImage = destImg;
        return this;
    }

    public BufferedImage getImg() {
        return this.destImage;
    }

    public void write(OutputStream out) throws IORuntimeException {
        this.write(ImageUtil.getImageOutputStream(out));
    }

    public void write(ImageOutputStream destImageStream) throws IORuntimeException {
        try {
            ImageIO.write((RenderedImage)this.destImage, this.destImageType, destImageStream);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public void write(File targetFile) throws IORuntimeException {
        String formatName = FileUtil.extName(targetFile);
        if (StrUtil.isBlank(formatName)) {
            formatName = "jpg";
        }
        try {
            ImageIO.write((RenderedImage)this.destImage, formatName, targetFile);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private static BufferedImage draw(BufferedImage backgroundImg, Image img, Rectangle rectangle, float alpha) {
        Graphics2D g = backgroundImg.createGraphics();
        g.setComposite(AlphaComposite.getInstance(10, alpha));
        int width = backgroundImg.getWidth();
        int height = backgroundImg.getHeight();
        rectangle.setLocation(rectangle.x + Math.abs(width - rectangle.width) / 2, rectangle.y + Math.abs(height - rectangle.height) / 2);
        g.drawImage(img, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
        g.dispose();
        return backgroundImg;
    }

    private int getTypeInt() {
        switch (this.destImageType) {
            case "png": {
                return 2;
            }
        }
        return 1;
    }
}

