/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.bean.BeanPath;
import cn.hutool.core.collection.ArrayIter;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.impl.CollectionConverter;
import cn.hutool.json.InternalJSONUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONGetter;
import cn.hutool.json.JSONNull;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONObjectIter;
import cn.hutool.json.JSONTokener;
import cn.hutool.json.JSONUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class JSONArray
extends JSONGetter<Integer>
implements JSON,
List<Object> {
    private static final long serialVersionUID = 2664900568717612292L;
    private static final int DEFAULT_CAPACITY = 10;
    private final List<Object> rawList;
    private boolean ignoreNullValue;

    public JSONArray() {
        this(10);
    }

    public JSONArray(int initialCapacity) {
        this.rawList = new ArrayList<Object>(initialCapacity);
        this.ignoreNullValue = true;
    }

    public JSONArray(Iterable<Object> list) {
        this();
        for (Object o : list) {
            this.add(o);
        }
    }

    public JSONArray(Collection<Object> list) {
        this(list.size());
        for (Object o : list) {
            this.add(o);
        }
    }

    public JSONArray(JSONTokener x) throws JSONException {
        this();
        this.init(x);
    }

    public JSONArray(CharSequence source) throws JSONException {
        this();
        this.init(source);
    }

    public JSONArray(Object object) throws JSONException {
        this(object, true);
    }

    public JSONArray(Object object, boolean ignoreNullValue) throws JSONException {
        this();
        this.ignoreNullValue = ignoreNullValue;
        if (object instanceof CharSequence) {
            this.init((CharSequence)object);
        } else {
            Iterator<Object> iter;
            if (object.getClass().isArray()) {
                iter = new ArrayIter(object);
            } else if (object instanceof Iterator) {
                iter = (Iterator)object;
            } else if (object instanceof Iterable) {
                iter = ((Iterable)object).iterator();
            } else {
                throw new JSONException("JSONArray initial value should be a string or collection or array.");
            }
            while (iter.hasNext()) {
                this.add(iter.next());
            }
        }
    }

    public boolean isNull(int index) {
        return JSONNull.NULL.equals(this.getObj(index));
    }

    public String join(String separator) throws JSONException {
        int len = this.rawList.size();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(InternalJSONUtil.valueToString(this.rawList.get(i)));
        }
        return sb.toString();
    }

    @Override
    public Object get(int index) {
        return this.rawList.get(index);
    }

    @Override
    public Object getObj(Integer index, Object defaultValue) {
        return index < 0 || index >= this.size() ? defaultValue : this.rawList.get(index);
    }

    @Override
    public Object getByExp(String expression) {
        return this.getByPath(expression);
    }

    @Override
    @Deprecated
    public <T> T getByExp(String expression, Class<T> resultType) {
        return this.getByPath(expression, resultType);
    }

    @Override
    public Object getByPath(String expression) {
        return BeanPath.create(expression).get(this);
    }

    @Override
    public <T> T getByPath(String expression, Class<T> resultType) {
        return (T)InternalJSONUtil.jsonConvert(resultType, this.getByPath(expression), true);
    }

    @Override
    public void putByPath(String expression, Object value) {
        BeanPath.create(expression).set(this, value);
    }

    public JSONArray put(Object value) {
        this.add(value);
        return this;
    }

    public JSONArray put(int index, Object value) throws JSONException {
        this.add(index, value);
        return this;
    }

    public JSONObject toJSONObject(JSONArray names) throws JSONException {
        if (names == null || names.size() == 0 || this.size() == 0) {
            return null;
        }
        JSONObject jo = new JSONObject();
        for (int i = 0; i < names.size(); ++i) {
            jo.put(names.getStr(i), this.getObj(i));
        }
        return jo;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rawList == null ? 0 : this.rawList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JSONArray other = (JSONArray)obj;
        return !(this.rawList == null ? other.rawList != null : !this.rawList.equals(other.rawList));
    }

    public String toString() {
        try {
            return this.toJSONString(0);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String toStringPretty() throws JSONException {
        return this.toJSONString(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toJSONString(int indentFactor) throws JSONException {
        StringWriter sw = new StringWriter();
        StringBuffer stringBuffer = sw.getBuffer();
        synchronized (stringBuffer) {
            return this.write(sw, indentFactor, 0).toString();
        }
    }

    @Override
    public Writer write(Writer writer) throws JSONException {
        return this.write(writer, 0, 0);
    }

    @Override
    public Writer write(Writer writer, int indentFactor, int indent) throws JSONException {
        try {
            boolean commanate = false;
            int length = this.size();
            writer.write(91);
            if (length == 1) {
                InternalJSONUtil.writeValue(writer, this.rawList.get(0), indentFactor, indent);
            } else if (length != 0) {
                int newindent = indent + indentFactor;
                for (int i = 0; i < length; ++i) {
                    if (commanate) {
                        writer.write(44);
                    }
                    if (indentFactor > 0) {
                        writer.write(10);
                    }
                    InternalJSONUtil.indent(writer, newindent);
                    InternalJSONUtil.writeValue(writer, this.rawList.get(i), indentFactor, newindent);
                    commanate = true;
                }
                if (indentFactor > 0) {
                    writer.write(10);
                }
                InternalJSONUtil.indent(writer, indent);
            }
            writer.write(93);
            return writer;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    @Override
    public Iterator<Object> iterator() {
        return this.rawList.iterator();
    }

    public Iterable<JSONObject> jsonIter() {
        return new JSONObjectIter(this.iterator());
    }

    @Override
    public int size() {
        return this.rawList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rawList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.rawList.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.rawList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.rawList.toArray(a);
    }

    @Override
    public boolean add(Object e) {
        return this.rawList.add(JSONUtil.wrap(e, this.ignoreNullValue));
    }

    @Override
    public Object remove(int index) {
        return index >= 0 && index < this.size() ? this.rawList.remove(index) : null;
    }

    @Override
    public boolean remove(Object o) {
        return this.rawList.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.rawList.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Object> c) {
        if (CollUtil.isEmpty(c)) {
            return false;
        }
        for (Object object : c) {
            this.add(object);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Object> c) {
        if (CollUtil.isEmpty(c)) {
            return false;
        }
        ArrayList<Object> list = new ArrayList<Object>(c.size());
        for (Object object : c) {
            list.add(JSONUtil.wrap(object, this.ignoreNullValue));
        }
        return this.rawList.addAll(index, list);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.rawList.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.rawList.retainAll(c);
    }

    @Override
    public void clear() {
        this.rawList.clear();
    }

    @Override
    public Object set(int index, Object element) {
        return this.rawList.set(index, JSONUtil.wrap(element, this.ignoreNullValue));
    }

    @Override
    public void add(int index, Object element) {
        if (index < 0) {
            throw new JSONException("JSONArray[" + index + "] not found.");
        }
        if (index < this.size()) {
            InternalJSONUtil.testValidity(element);
            this.rawList.set(index, JSONUtil.wrap(element, this.ignoreNullValue));
        } else {
            while (index != this.size()) {
                this.add(JSONNull.NULL);
            }
            this.put(element);
        }
    }

    @Override
    public int indexOf(Object o) {
        return this.rawList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.rawList.lastIndexOf(o);
    }

    @Override
    public ListIterator<Object> listIterator() {
        return this.rawList.listIterator();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return this.rawList.listIterator(index);
    }

    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        return this.rawList.subList(fromIndex, toIndex);
    }

    public Object toArray(Class<?> clazz) {
        return this.toArray(clazz, false);
    }

    public Object toArray(Class<?> arrayClass, boolean ignoreError) {
        return InternalJSONUtil.toArray(this, arrayClass, ignoreError);
    }

    public <T> ArrayList<T> toList(Class<T> elementType) {
        CollectionConverter converter = new CollectionConverter((Type)((Object)ArrayList.class), elementType);
        return (ArrayList)converter.convert((Object)this, null);
    }

    private void init(CharSequence source) {
        if (null != source) {
            this.init(new JSONTokener(source.toString()));
        }
    }

    private void init(JSONTokener x) {
        if (x.nextClean() != '[') {
            throw x.syntaxError("A JSONArray text must start with '['");
        }
        if (x.nextClean() != ']') {
            x.back();
            block4: while (true) {
                if (x.nextClean() == ',') {
                    x.back();
                    this.rawList.add(JSONNull.NULL);
                } else {
                    x.back();
                    this.rawList.add(x.nextValue());
                }
                switch (x.nextClean()) {
                    case ',': {
                        if (x.nextClean() == ']') {
                            return;
                        }
                        x.back();
                        continue block4;
                    }
                    case ']': {
                        return;
                    }
                }
                break;
            }
            throw x.syntaxError("Expected a ',' or ']'");
        }
    }
}

