/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto;

import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.KeyUtil;
import cn.hutool.crypto.SecureUtil;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.ECPointUtil;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.math.ec.ECCurve;

public class BCUtil {
    public static byte[] encodeECPublicKey(PublicKey publicKey) {
        return ((BCECPublicKey)publicKey).getQ().getEncoded(true);
    }

    public static PublicKey decodeECPoint(String encode, String curveName) {
        return BCUtil.decodeECPoint(SecureUtil.decodeKey(encode), curveName);
    }

    public static PublicKey decodeECPoint(byte[] encodeByte, String curveName) {
        ECNamedCurveParameterSpec namedSpec = ECNamedCurveTable.getParameterSpec((String)curveName);
        ECCurve curve = namedSpec.getCurve();
        EllipticCurve ecCurve = new EllipticCurve(new ECFieldFp(curve.getField().getCharacteristic()), curve.getA().toBigInteger(), curve.getB().toBigInteger());
        ECPoint point = ECPointUtil.decodePoint((EllipticCurve)ecCurve, (byte[])encodeByte);
        ECNamedCurveSpec ecSpec = new ECNamedCurveSpec(curveName, curve, namedSpec.getG(), namedSpec.getN());
        KeyFactory PubKeyGen = KeyUtil.getKeyFactory("EC");
        try {
            return PubKeyGen.generatePublic(new ECPublicKeySpec(point, (ECParameterSpec)ecSpec));
        }
        catch (GeneralSecurityException e) {
            throw new CryptoException(e);
        }
    }
}

