/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.bpm.engine;

import com.aizuda.bpm.engine.assist.ObjectUtils;
import com.aizuda.bpm.engine.model.NodeExpression;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public interface Expression {
    public boolean eval(List<List<NodeExpression>> var1, Map<String, Object> var2);

    default public boolean eval(List<List<NodeExpression>> conditionList, Supplier<Map<String, Object>> argsSupplier, Function<String, Boolean> evalFunc) {
        if (ObjectUtils.isEmpty(conditionList)) {
            return false;
        }
        Map<String, Object> args = argsSupplier.get();
        for (List<NodeExpression> nodeExpressions : conditionList) {
            if (!nodeExpressions.stream().anyMatch(t -> !args.containsKey(t.getField()))) continue;
            return false;
        }
        String expr = conditionList.stream().map(cl -> cl.stream().map(t -> this.exprOfArgs((NodeExpression)t, args)).collect(Collectors.joining(" && "))).collect(Collectors.joining(" || "));
        return evalFunc.apply(expr);
    }

    default public String exprOfArgs(NodeExpression nodeExpression, Map<String, Object> args) {
        String value = nodeExpression.getValue();
        Object fieldValue = args.get(nodeExpression.getField());
        if (fieldValue instanceof String) {
            value = "'" + nodeExpression.getValue() + "'";
        }
        return "#" + nodeExpression.getField() + nodeExpression.getOperator() + value;
    }
}

