/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.bpm.engine;

import com.aizuda.bpm.engine.ProcessService;
import com.aizuda.bpm.engine.QueryService;
import com.aizuda.bpm.engine.RuntimeService;
import com.aizuda.bpm.engine.TaskService;
import com.aizuda.bpm.engine.core.Execution;
import com.aizuda.bpm.engine.core.FlowCreator;
import com.aizuda.bpm.engine.core.FlowLongContext;
import com.aizuda.bpm.engine.core.enums.PerformType;
import com.aizuda.bpm.engine.core.enums.TaskType;
import com.aizuda.bpm.engine.entity.FlwInstance;
import com.aizuda.bpm.engine.entity.FlwProcess;
import com.aizuda.bpm.engine.entity.FlwTask;
import com.aizuda.bpm.engine.entity.FlwTaskActor;
import com.aizuda.bpm.engine.model.NodeModel;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public interface FlowLongEngine {
    public FlowLongEngine configure(FlowLongContext var1);

    public FlowLongContext getContext();

    default public ProcessService processService() {
        return this.getContext().getProcessService();
    }

    default public QueryService queryService() {
        return this.getContext().getQueryService();
    }

    default public RuntimeService runtimeService() {
        return this.getContext().getRuntimeService();
    }

    default public TaskService taskService() {
        return this.getContext().getTaskService();
    }

    public Optional<FlwInstance> startInstanceById(Long var1, FlowCreator var2, Map<String, Object> var3, Supplier<FlwInstance> var4);

    default public Optional<FlwInstance> startInstanceById(Long id, FlowCreator flowCreator, Map<String, Object> args) {
        return this.startInstanceById(id, flowCreator, args, null);
    }

    default public Optional<FlwInstance> startInstanceById(Long id, FlowCreator flowCreator, String businessKey) {
        return this.startInstanceById(id, flowCreator, null, () -> FlwInstance.of(businessKey));
    }

    default public Optional<FlwInstance> startInstanceById(Long id, FlowCreator flowCreator) {
        return this.startInstanceById(id, flowCreator, null, null);
    }

    public Optional<FlwInstance> startInstanceByProcessKey(String var1, Integer var2, FlowCreator var3, Map<String, Object> var4, Supplier<FlwInstance> var5);

    default public Optional<FlwInstance> startInstanceByProcessKey(String processKey, Integer version, FlowCreator flowCreator, Map<String, Object> args) {
        return this.startInstanceByProcessKey(processKey, version, flowCreator, args, null);
    }

    default public Optional<FlwInstance> startInstanceByProcessKey(String processKey, Integer version, FlowCreator flowCreator, String businessKey) {
        return this.startInstanceByProcessKey(processKey, version, flowCreator, null, () -> FlwInstance.of(businessKey));
    }

    default public Optional<FlwInstance> startInstanceByProcessKey(String processKey, Integer version, FlowCreator flowCreator) {
        return this.startInstanceByProcessKey(processKey, version, flowCreator, null, null);
    }

    default public Optional<FlwInstance> startInstanceByProcessKey(String processKey, FlowCreator flowCreator) {
        return this.startInstanceByProcessKey(processKey, null, flowCreator);
    }

    public Optional<FlwInstance> startProcessInstance(FlwProcess var1, FlowCreator var2, Map<String, Object> var3, Supplier<FlwInstance> var4);

    public void restartProcessInstance(Long var1, String var2, Execution var3);

    public boolean executeTask(Long var1, FlowCreator var2, Map<String, Object> var3);

    default public boolean executeTask(Long taskId, FlowCreator flowCreator) {
        return this.executeTask(taskId, flowCreator, null);
    }

    public boolean autoJumpTask(Long var1, Map<String, Object> var2, FlowCreator var3);

    default public boolean autoJumpTask(Long taskId, FlowCreator flowCreator) {
        return this.autoJumpTask(taskId, null, flowCreator);
    }

    public boolean autoCompleteTask(Long var1, Map<String, Object> var2, FlowCreator var3);

    default public boolean autoCompleteTask(Long taskId, FlowCreator flowCreator) {
        return this.autoCompleteTask(taskId, null, flowCreator);
    }

    default public boolean autoCompleteTask(Long taskId) {
        return this.autoCompleteTask(taskId, FlowCreator.ADMIN);
    }

    public boolean autoRejectTask(FlwTask var1, Map<String, Object> var2, FlowCreator var3);

    default public boolean autoRejectTask(FlwTask flwTask, FlowCreator flowCreator) {
        return this.autoRejectTask(flwTask, null, flowCreator);
    }

    default public boolean autoRejectTask(FlwTask flwTask) {
        return this.autoRejectTask(flwTask, FlowCreator.ADMIN);
    }

    default public boolean executeJumpTask(Long taskId, String nodeKey, FlowCreator flowCreator, Map<String, Object> args) {
        return this.executeJumpTask(taskId, nodeKey, flowCreator, args, TaskType.jump).isPresent();
    }

    default public boolean executeJumpTask(Long taskId, String nodeKey, FlowCreator flowCreator) {
        return this.executeJumpTask(taskId, nodeKey, flowCreator, null);
    }

    public Optional<FlwTask> executeJumpTask(Long var1, String var2, FlowCreator var3, Map<String, Object> var4, TaskType var5);

    public Optional<FlwTask> executeRejectTask(FlwTask var1, String var2, FlowCreator var3, Map<String, Object> var4);

    default public Optional<FlwTask> executeRejectTask(FlwTask currentFlwTask, FlowCreator flowCreator, Map<String, Object> args) {
        return this.executeRejectTask(currentFlwTask, null, flowCreator, args);
    }

    public List<FlwTask> createNewTask(Long var1, TaskType var2, PerformType var3, List<FlwTaskActor> var4, FlowCreator var5, Map<String, Object> var6);

    public boolean executeAppendNodeModel(Long var1, NodeModel var2, FlowCreator var3, Map<String, Object> var4, boolean var5);

    default public boolean executeAppendNodeModel(Long taskId, NodeModel nodeModel, FlowCreator flowCreator, boolean beforeAfter) {
        return this.executeAppendNodeModel(taskId, nodeModel, flowCreator, null, beforeAfter);
    }
}

