/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.bpm.engine;

import com.aizuda.bpm.engine.FlowLongEngine;
import com.aizuda.bpm.engine.TaskReminder;
import com.aizuda.bpm.engine.TaskService;
import com.aizuda.bpm.engine.assist.Assert;
import com.aizuda.bpm.engine.assist.DateUtils;
import com.aizuda.bpm.engine.assist.ObjectUtils;
import com.aizuda.bpm.engine.core.FlowCreator;
import com.aizuda.bpm.engine.core.FlowLongContext;
import com.aizuda.bpm.engine.core.enums.TaskType;
import com.aizuda.bpm.engine.entity.FlwTask;
import com.aizuda.bpm.engine.model.NodeModel;
import com.aizuda.bpm.engine.model.ProcessModel;
import com.aizuda.bpm.engine.scheduling.JobLock;
import com.aizuda.bpm.engine.scheduling.RemindParam;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FlowLongScheduler {
    private static final Logger log = LoggerFactory.getLogger(FlowLongScheduler.class);
    private FlowLongEngine flowLongEngine;
    private JobLock jobLock;
    private RemindParam remindParam;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remind() {
        try {
            if (!this.jobLock.tryLock()) {
                log.info("[FlowLong] Scheduling is already running, just return.");
                return;
            }
            FlowLongContext context = this.flowLongEngine.getContext();
            TaskService taskService = context.getTaskService();
            List<FlwTask> flwTaskList = taskService.getTimeoutOrRemindTasks();
            if (ObjectUtils.isNotEmpty(flwTaskList)) {
                Date currentDate = DateUtils.getCurrentDate();
                for (FlwTask flwTask : flwTaskList) {
                    if (null != flwTask.getRemindTime()) {
                        if (!DateUtils.after(flwTask.getRemindTime(), currentDate) || flwTask.getRemindRepeat() <= 0) continue;
                        FlwTask temp = new FlwTask();
                        temp.setId(flwTask.getId());
                        temp.setRemindRepeat(flwTask.getRemindRepeat() + 1);
                        TaskReminder taskReminder = context.getTaskReminder();
                        Assert.isNull(taskReminder, "Please make sure to implement the interface TaskReminder");
                        Date nextRemindTime = taskReminder.remind(context, flwTask.getInstanceId(), flwTask);
                        if (null != nextRemindTime) {
                            temp.setRemindTime(nextRemindTime);
                        }
                        taskService.updateTaskById(temp, null);
                        continue;
                    }
                    if (null == flwTask.getExpireTime()) continue;
                    if (TaskType.timer.eq(flwTask.getTaskType()) || TaskType.trigger.eq(flwTask.getTaskType())) {
                        if (this.flowLongEngine.autoCompleteTask(flwTask.getId(), this.getAutoFlowCreator())) continue;
                        log.info("Scheduling [taskName={}] failed to execute autoCompleteTask", (Object)flwTask.getTaskName());
                        continue;
                    }
                    ProcessModel processModel = this.flowLongEngine.runtimeService().getProcessModelByInstanceId(flwTask.getInstanceId());
                    NodeModel nodeModel = processModel.getNode(flwTask.getTaskKey());
                    Boolean termAuto = nodeModel.getTermAuto();
                    if (termAuto == null || !termAuto.booleanValue()) continue;
                    Integer termMode = nodeModel.getTermMode();
                    if (null == termMode) {
                        context.getRuntimeService().timeout(flwTask.getInstanceId());
                        continue;
                    }
                    if (Objects.equals(termMode, 0)) {
                        if (this.flowLongEngine.autoCompleteTask(flwTask.getId(), this.getAutoFlowCreator())) continue;
                        log.info("Scheduling failed to execute autoCompleteTask");
                        continue;
                    }
                    if (!Objects.equals(termMode, 1) || this.flowLongEngine.autoRejectTask(flwTask, this.getAutoFlowCreator())) continue;
                    log.info("Scheduling failed to execute autoRejectTask");
                }
            }
        }
        finally {
            this.jobLock.unlock();
        }
    }

    public void setRemindParam(RemindParam remindParam) {
        if (null == remindParam) {
            remindParam = new RemindParam();
            remindParam.setCron("*/5 * * * * ?");
        }
        this.remindParam = remindParam;
    }

    public FlowCreator getAutoFlowCreator() {
        return FlowCreator.ADMIN;
    }

    public FlowLongEngine getFlowLongEngine() {
        return this.flowLongEngine;
    }

    public JobLock getJobLock() {
        return this.jobLock;
    }

    public RemindParam getRemindParam() {
        return this.remindParam;
    }

    public void setFlowLongEngine(FlowLongEngine flowLongEngine) {
        this.flowLongEngine = flowLongEngine;
    }

    public void setJobLock(JobLock jobLock) {
        this.jobLock = jobLock;
    }
}

