/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.bpm.engine;

import com.aizuda.bpm.engine.assist.Assert;
import com.aizuda.bpm.engine.assist.ObjectUtils;
import com.aizuda.bpm.engine.core.Execution;
import com.aizuda.bpm.engine.core.FlowCreator;
import com.aizuda.bpm.engine.core.enums.InstanceState;
import com.aizuda.bpm.engine.core.enums.PerformType;
import com.aizuda.bpm.engine.core.enums.TaskEventType;
import com.aizuda.bpm.engine.core.enums.TaskState;
import com.aizuda.bpm.engine.core.enums.TaskType;
import com.aizuda.bpm.engine.entity.FlwTask;
import com.aizuda.bpm.engine.entity.FlwTaskActor;
import com.aizuda.bpm.engine.model.NodeModel;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public interface TaskService {
    default public FlwTask complete(Long taskId, FlowCreator flowCreator, Map<String, Object> args) {
        return this.executeTask(taskId, flowCreator, args, TaskState.complete, TaskEventType.complete);
    }

    default public FlwTask complete(Long taskId, FlowCreator flowCreator) {
        return this.complete(taskId, flowCreator, null);
    }

    public FlwTask executeTask(Long var1, FlowCreator var2, Map<String, Object> var3, TaskState var4, TaskEventType var5);

    public boolean forceCompleteAllTask(Long var1, FlowCreator var2, InstanceState var3, TaskEventType var4);

    public Optional<FlwTask> executeJumpTask(Long var1, String var2, FlowCreator var3, Map<String, Object> var4, Function<FlwTask, Execution> var5, TaskType var6);

    default public boolean executeJumpTask(Long taskId, String nodeKey, FlowCreator flowCreator, Map<String, Object> args, Function<FlwTask, Execution> executionFunction) {
        return this.executeJumpTask(taskId, nodeKey, flowCreator, args, executionFunction, TaskType.jump).isPresent();
    }

    default public boolean executeJumpTask(Long taskId, String nodeKey, FlowCreator flowCreator, Function<FlwTask, Execution> executionFunction) {
        return this.executeJumpTask(taskId, nodeKey, flowCreator, null, executionFunction);
    }

    public boolean executeTaskTrigger(Execution var1, FlwTask var2);

    public boolean completeActiveTasksByInstanceId(Long var1, FlowCreator var2);

    public void updateTaskById(FlwTask var1, FlowCreator var2);

    public boolean viewTask(Long var1, FlwTaskActor var2);

    public FlwTask claimRole(Long var1, FlowCreator var2);

    public FlwTask claimDepartment(Long var1, FlowCreator var2);

    default public boolean agentTask(Long taskId, FlowCreator flowCreator, List<FlowCreator> agentFlowCreators) {
        return this.assigneeTask(taskId, TaskType.agent, flowCreator, agentFlowCreators, null);
    }

    default public boolean transferTask(Long taskId, FlowCreator flowCreator, FlowCreator assigneeFlowCreator) {
        return this.assigneeTask(taskId, TaskType.transfer, flowCreator, Collections.singletonList(assigneeFlowCreator), null);
    }

    public boolean transferTask(FlowCreator var1, FlowCreator var2);

    default public boolean delegateTask(Long taskId, FlowCreator flowCreator, FlowCreator assigneeFlowCreator) {
        return this.assigneeTask(taskId, TaskType.delegate, flowCreator, Collections.singletonList(assigneeFlowCreator), null);
    }

    public boolean assigneeTask(Long var1, TaskType var2, FlowCreator var3, List<FlowCreator> var4, Function<FlwTask, Boolean> var5);

    default public boolean assigneeTask(Long taskId, TaskType taskType, FlowCreator flowCreator, List<FlowCreator> assigneeFlowCreators) {
        return this.assigneeTask(taskId, taskType, flowCreator, assigneeFlowCreators, t -> {
            if (ObjectUtils.isNotEmpty(t.getAssignorId())) {
                Assert.illegal("Do not allow duplicate assign , taskId = " + taskId);
            }
            return true;
        });
    }

    public boolean resolveTask(Long var1, FlowCreator var2);

    public Optional<FlwTask> reclaimTask(Long var1, FlowCreator var2);

    public FlwTask resume(Long var1, FlowCreator var2);

    public Optional<FlwTask> withdrawTask(Long var1, FlowCreator var2);

    public Optional<FlwTask> rejectTask(FlwTask var1, FlowCreator var2, Map<String, Object> var3);

    default public Optional<FlwTask> rejectTask(FlwTask currentFlwTask, FlowCreator flowCreator) {
        return this.rejectTask(currentFlwTask, flowCreator, null);
    }

    public FlwTaskActor isAllowed(FlwTask var1, String var2);

    public List<FlwTask> createTask(NodeModel var1, Execution var2, Function<FlwTask, FlwTask> var3);

    default public List<FlwTask> createTask(NodeModel taskModel, Execution execution) {
        return this.createTask(taskModel, execution, null);
    }

    public List<FlwTask> createNewTask(Long var1, TaskType var2, PerformType var3, List<FlwTaskActor> var4, FlowCreator var5, Function<FlwTask, Execution> var6);

    public List<FlwTask> getTimeoutOrRemindTasks();

    public NodeModel getTaskModel(Long var1);

    public boolean addTaskActor(Long var1, PerformType var2, List<FlwTaskActor> var3, FlowCreator var4);

    default public boolean addTaskActor(Long taskId, PerformType performType, FlwTaskActor flwTaskActor, FlowCreator flowCreator) {
        return this.addTaskActor(taskId, performType, Collections.singletonList(flwTaskActor), flowCreator);
    }

    public boolean removeTaskActor(Long var1, List<String> var2, FlowCreator var3);

    default public boolean removeTaskActor(Long taskId, String actorId, FlowCreator flowCreator) {
        return this.removeTaskActor(taskId, Collections.singletonList(actorId), flowCreator);
    }

    public void endCallProcessTask(Long var1, Long var2);

    public boolean cascadeRemoveByInstanceIds(List<Long> var1);
}

