/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.bpm.engine.assist;

import com.aizuda.bpm.engine.assist.ObjectUtils;
import com.aizuda.bpm.engine.exception.FlowLongException;
import java.util.Objects;
import java.util.function.Supplier;

public abstract class Assert {
    public static void isTrue(boolean expression, String message) {
        Assert.illegal(expression, message);
    }

    public static void isFalse(boolean expression, Supplier<String> supplier) {
        Assert.illegal(!expression, supplier);
    }

    public static void isFalse(boolean expression, String message) {
        Assert.illegal(!expression, message);
    }

    public static void isZero(int result, String message) {
        Assert.illegal(Objects.equals(0, result), message);
    }

    public static void isTrue(boolean expression) {
        Assert.isTrue(expression, "[Assertion failed] - this expression must be false");
    }

    public static void isNull(Object object, String message) {
        Assert.illegal(null == object, message);
    }

    public static void isNull(Object object) {
        Assert.isNull(object, "[Assertion failed] - the object argument must not be null");
    }

    public static void notNull(Object object, String message) {
        Assert.illegal(null != object, message);
    }

    public static void notNull(Object object) {
        Assert.notNull(object, "[Assertion failed] - the object argument must be null");
    }

    public static void isEmpty(Object object) {
        Assert.isEmpty(object, "[Assertion failed] - this argument must not be null or empty");
    }

    public static void isEmpty(Object object, String message) {
        Assert.illegal(ObjectUtils.isEmpty(object), message);
    }

    public static void isNotEmpty(Object object, String message) {
        Assert.illegal(ObjectUtils.isNotEmpty(object), message);
    }

    public static void illegal(boolean illegal, String message) {
        if (illegal) {
            throw Assert.throwable(message);
        }
    }

    public static void illegal(boolean illegal, Supplier<String> supplier) {
        if (illegal) {
            throw Assert.throwable(supplier.get());
        }
    }

    public static void illegal(String message) {
        throw Assert.throwable(message);
    }

    public static FlowLongException throwable(String message) {
        return new FlowLongException(message);
    }

    public static FlowLongException throwable(String message, Throwable cause) {
        return new FlowLongException(message, cause);
    }

    public static FlowLongException throwable(Throwable cause) {
        return new FlowLongException(cause);
    }
}

