/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.bpm.engine.assist;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

public class DateUtils {
    public static Date getCurrentDate() {
        return new Date();
    }

    public static LocalDateTime now() {
        return LocalDateTime.now();
    }

    public static boolean after(Date arg0, Date arg1) {
        return null != arg0 && null != arg1 && arg0.after(arg1);
    }

    public static Date toDate(LocalDateTime localDateTime) {
        if (null == localDateTime) {
            return null;
        }
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Long calculateDateDifference(Date startDate, Date endDate) {
        if (null == startDate || null == endDate) {
            return 0L;
        }
        return Math.max(endDate.getTime() - startDate.getTime(), 0L);
    }

    public static Date parseTimerTaskTime(String time) {
        LocalDateTime expireTime = null;
        String[] timeArr = time.split(":");
        int l = timeArr.length;
        if (l == 2) {
            long vary = Long.parseLong(timeArr[0]);
            String unit = timeArr[1];
            if ("d".equals(unit)) {
                expireTime = DateUtils.now().plusDays(vary);
            } else if ("h".equals(unit)) {
                expireTime = DateUtils.now().plusHours(vary);
            } else if ("m".equals(unit)) {
                expireTime = DateUtils.now().plusMinutes(vary);
            }
        } else if (l == 3) {
            long hours = Long.parseLong(timeArr[0]);
            long minutes = Long.parseLong(timeArr[1]);
            long seconds = Long.parseLong(timeArr[2]);
            expireTime = DateUtils.now().plusHours(hours).plusMinutes(minutes).plusSeconds(seconds);
        }
        return DateUtils.toDate(expireTime);
    }
}

