/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.bpm.engine.assist;

import com.aizuda.bpm.engine.assist.Assert;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;

public class StreamUtils {
    public static InputStream getResourceAsStream(String name) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream stream = classLoader.getResourceAsStream(name);
        if (null == stream) {
            stream = StreamUtils.class.getClassLoader().getResourceAsStream(name);
        }
        if (stream == null) {
            throw Assert.throwable("resource " + name + " does not exist");
        }
        return stream;
    }

    public static <T> T readBytes(InputStream in, Function<String, T> function) {
        Assert.isNull(in);
        try {
            return function.apply(StreamUtils.readBytes(in));
        }
        catch (Exception e) {
            throw Assert.throwable(e.getMessage(), e);
        }
    }

    public static String readBytes(InputStream in) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            int count;
            byte[] buffer = new byte[4096];
            while ((count = in.read(buffer)) != -1) {
                out.write(buffer, 0, count);
            }
            String string = out.toString(StandardCharsets.UTF_8.toString());
            return string;
        }
    }
}

