/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.bpm.engine.core;

import com.aizuda.bpm.engine.FlowLongEngine;
import com.aizuda.bpm.engine.TaskActorProvider;
import com.aizuda.bpm.engine.assist.Assert;
import com.aizuda.bpm.engine.core.FlowCreator;
import com.aizuda.bpm.engine.core.FlowLongContext;
import com.aizuda.bpm.engine.entity.FlwInstance;
import com.aizuda.bpm.engine.entity.FlwTask;
import com.aizuda.bpm.engine.entity.FlwTaskActor;
import com.aizuda.bpm.engine.model.ModelHelper;
import com.aizuda.bpm.engine.model.NodeModel;
import com.aizuda.bpm.engine.model.ProcessModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class Execution
implements Serializable {
    private FlowLongEngine engine;
    private ProcessModel processModel;
    private FlwInstance flwInstance;
    private FlwInstance parentFlwInstance;
    private FlwTaskActor nextFlwTaskActor;
    private String parentNodeName;
    private Long childInstanceId;
    private Map<String, Object> args;
    private FlowCreator flowCreator;
    private FlwTask flwTask;
    private List<FlwTask> flwTasks = new ArrayList<FlwTask>();
    private boolean isMerged = false;

    Execution(Execution execution, ProcessModel processModel, String parentNodeName) {
        if (execution == null || processModel == null || parentNodeName == null) {
            throw Assert.throwable("Failed to construct Execution object. Please check if Execution, Process, and parentNodeName are empty");
        }
        this.engine = execution.getEngine();
        this.processModel = processModel;
        this.args = execution.getArgs();
        this.parentFlwInstance = execution.getFlwInstance();
        this.parentNodeName = parentNodeName;
        this.flowCreator = execution.getFlowCreator();
    }

    public Execution(FlowLongEngine engine, ProcessModel processModel, FlowCreator flowCreator, FlwInstance flwInstance, Map<String, Object> args) {
        if (processModel == null || flwInstance == null) {
            throw Assert.throwable("Failed to construct Execution object, please check if process and order are empty");
        }
        this.engine = engine;
        this.processModel = processModel;
        this.flowCreator = flowCreator;
        this.flwInstance = flwInstance;
        this.args = args;
    }

    public Execution(FlowCreator flowCreator, Map<String, Object> args) {
        this.flowCreator = flowCreator;
        this.args = args;
    }

    public Execution createSubExecution(Execution execution, ProcessModel processModel, String parentNodeName) {
        return new Execution(execution, processModel, parentNodeName);
    }

    public boolean executeNodeModel(FlowLongContext flowLongContext, String nodeKey) {
        ProcessModel processModel = this.getProcessModel();
        Assert.isNull(processModel, "Process model content cannot be empty");
        ModelHelper.reloadProcessModel(processModel, t -> {
            boolean ok = flowLongContext.getRuntimeService().updateInstanceModelById(this.flwInstance.getId(), (ProcessModel)t);
            Assert.isFalse(ok, "Failed to update process model content");
            t.buildParentNode(processModel.getNodeConfig());
        });
        NodeModel nodeModel = processModel.getNode(nodeKey);
        Assert.isNull(nodeModel, "Not found in the process model, process nodeKey=" + nodeKey);
        LinkedList<String> nodeKeys = new LinkedList<String>();
        flowLongContext.getQueryService().getActiveTasksByInstanceId(this.flwTask.getInstanceId()).ifPresent(flwTasks -> {
            for (FlwTask ft : flwTasks) {
                nodeKeys.add(ft.getTaskKey());
            }
        });
        LinkedList otherProcessKeys = new LinkedList();
        Optional<List<FlwInstance>> subProcessList = flowLongContext.getQueryService().getSubProcessByInstanceId(this.flwTask.getInstanceId());
        subProcessList.ifPresent(subProcesses -> subProcesses.forEach(process -> {
            ProcessModel otherModel = flowLongContext.getRuntimeService().getProcessModelByInstanceId(process.getId());
            otherProcessKeys.addAll(new ArrayList(ModelHelper.getRootNodeAllChildNodes(otherModel.getNodeConfig()).stream().map(NodeModel::getNodeKey).collect(Collectors.toList())));
            flowLongContext.getQueryService().getActiveTasksByInstanceId(process.getId()).ifPresent(flwTasks -> {
                for (FlwTask ft : flwTasks) {
                    nodeKeys.add(ft.getTaskKey());
                }
            });
        }));
        Optional<Object> executeNodeOptional = Optional.empty();
        if (otherProcessKeys.isEmpty() || nodeKeys.isEmpty() || Collections.disjoint(nodeKeys, otherProcessKeys)) {
            executeNodeOptional = nodeModel.nextNode(nodeKeys);
        }
        if (executeNodeOptional.isPresent()) {
            NodeModel executeNode = (NodeModel)executeNodeOptional.get();
            return executeNode.execute(flowLongContext, this);
        }
        if (nodeKeys.isEmpty()) {
            return this.endInstance(nodeModel);
        }
        return true;
    }

    public boolean endInstance(NodeModel endNode) {
        if (this.engine.queryService().existActiveSubProcess(this.flwInstance.getId())) {
            return true;
        }
        List<FlwTask> flwTasks = this.engine.queryService().getTasksByInstanceId(this.flwInstance.getId());
        for (FlwTask flwTask : flwTasks) {
            Assert.illegal(flwTask.major(), "There are unfinished major tasks");
            this.engine.taskService().complete(flwTask.getId(), this.flowCreator);
        }
        FlowLongContext.invalidateProcessModel("flwProcessInstanceModel#" + this.flwInstance.getId());
        return this.engine.runtimeService().endInstance(this, this.flwInstance.getId(), endNode);
    }

    public void restartProcessInstance(Long id, String currentNodeKey) {
        this.engine.restartProcessInstance(id, currentNodeKey, this);
    }

    public void addTasks(List<FlwTask> flwTasks) {
        this.flwTasks.addAll(flwTasks);
    }

    public void addTask(FlwTask flwTask) {
        this.flwTasks.add(flwTask);
    }

    public TaskActorProvider getTaskActorProvider() {
        return this.engine.getContext().getTaskActorProvider();
    }

    public FlowLongEngine getEngine() {
        return this.engine;
    }

    public ProcessModel getProcessModel() {
        return this.processModel;
    }

    public FlwInstance getFlwInstance() {
        return this.flwInstance;
    }

    public FlwInstance getParentFlwInstance() {
        return this.parentFlwInstance;
    }

    public FlwTaskActor getNextFlwTaskActor() {
        return this.nextFlwTaskActor;
    }

    public String getParentNodeName() {
        return this.parentNodeName;
    }

    public Long getChildInstanceId() {
        return this.childInstanceId;
    }

    public Map<String, Object> getArgs() {
        return this.args;
    }

    public FlowCreator getFlowCreator() {
        return this.flowCreator;
    }

    public FlwTask getFlwTask() {
        return this.flwTask;
    }

    public List<FlwTask> getFlwTasks() {
        return this.flwTasks;
    }

    public boolean isMerged() {
        return this.isMerged;
    }

    public void setEngine(FlowLongEngine engine) {
        this.engine = engine;
    }

    public void setProcessModel(ProcessModel processModel) {
        this.processModel = processModel;
    }

    public void setFlwInstance(FlwInstance flwInstance) {
        this.flwInstance = flwInstance;
    }

    public void setParentFlwInstance(FlwInstance parentFlwInstance) {
        this.parentFlwInstance = parentFlwInstance;
    }

    public void setNextFlwTaskActor(FlwTaskActor nextFlwTaskActor) {
        this.nextFlwTaskActor = nextFlwTaskActor;
    }

    public void setParentNodeName(String parentNodeName) {
        this.parentNodeName = parentNodeName;
    }

    public void setChildInstanceId(Long childInstanceId) {
        this.childInstanceId = childInstanceId;
    }

    public void setArgs(Map<String, Object> args) {
        this.args = args;
    }

    public void setFlowCreator(FlowCreator flowCreator) {
        this.flowCreator = flowCreator;
    }

    public void setFlwTask(FlwTask flwTask) {
        this.flwTask = flwTask;
    }

    public void setFlwTasks(List<FlwTask> flwTasks) {
        this.flwTasks = flwTasks;
    }

    public void setMerged(boolean isMerged) {
        this.isMerged = isMerged;
    }
}

