/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.bpm.engine.core;

import com.aizuda.bpm.engine.Expression;
import com.aizuda.bpm.engine.FlowLongEngine;
import com.aizuda.bpm.engine.ProcessModelParser;
import com.aizuda.bpm.engine.ProcessService;
import com.aizuda.bpm.engine.QueryService;
import com.aizuda.bpm.engine.RuntimeService;
import com.aizuda.bpm.engine.TaskAccessStrategy;
import com.aizuda.bpm.engine.TaskActorProvider;
import com.aizuda.bpm.engine.TaskCreateInterceptor;
import com.aizuda.bpm.engine.TaskReminder;
import com.aizuda.bpm.engine.TaskService;
import com.aizuda.bpm.engine.TaskTrigger;
import com.aizuda.bpm.engine.assist.Assert;
import com.aizuda.bpm.engine.cache.FlowCache;
import com.aizuda.bpm.engine.core.Execution;
import com.aizuda.bpm.engine.handler.ConditionNodeHandler;
import com.aizuda.bpm.engine.handler.CreateTaskHandler;
import com.aizuda.bpm.engine.handler.FlowJsonHandler;
import com.aizuda.bpm.engine.handler.impl.SimpleConditionNodeHandler;
import com.aizuda.bpm.engine.handler.impl.SimpleCreateTaskHandler;
import com.aizuda.bpm.engine.impl.DefaultProcessModelParser;
import com.aizuda.bpm.engine.model.NodeModel;
import com.aizuda.bpm.engine.model.ProcessModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowLongContext {
    private static final Logger log = LoggerFactory.getLogger(FlowLongContext.class);
    private ProcessService processService;
    private QueryService queryService;
    private RuntimeService runtimeService;
    private TaskService taskService;
    private Expression expression;
    private CreateTaskHandler createTaskHandler;
    private ConditionNodeHandler conditionNodeHandler;
    private TaskCreateInterceptor taskCreateInterceptor;
    private TaskAccessStrategy taskAccessStrategy;
    private TaskActorProvider taskActorProvider;
    private TaskReminder taskReminder;
    private TaskTrigger taskTrigger;
    private static ProcessModelParser PROCESS_MODEL_PARSER;
    private static FlowJsonHandler flowJsonHandler;

    public static ProcessModel parseProcessModel(String content, String cacheKey, boolean redeploy) {
        return PROCESS_MODEL_PARSER.parse(content, cacheKey, redeploy);
    }

    public static void invalidateProcessModel(String cacheKey) {
        PROCESS_MODEL_PARSER.invalidate(cacheKey);
    }

    public FlowLongContext(FlowCache flowCache, ProcessModelParser processModelParser) {
        PROCESS_MODEL_PARSER = null == processModelParser ? new DefaultProcessModelParser(flowCache) : processModelParser;
    }

    public Expression checkExpression() {
        Assert.isNull(this.expression, "Interface Expression not implemented");
        return this.expression;
    }

    public static <T> T fromJson(String jsonString, Class<T> clazz) {
        return FlowLongContext.getFlowJsonHandler().fromJson(jsonString, clazz);
    }

    public static String toJson(Object object) {
        return FlowLongContext.getFlowJsonHandler().toJson(object);
    }

    private static FlowJsonHandler getFlowJsonHandler() {
        Assert.isNull(flowJsonHandler, "Please implement the FlowJsonHandler interface class");
        return flowJsonHandler;
    }

    public CreateTaskHandler getCreateTaskHandler() {
        return null != this.createTaskHandler ? this.createTaskHandler : SimpleCreateTaskHandler.getInstance();
    }

    public ConditionNodeHandler getFlowConditionHandler() {
        return null != this.conditionNodeHandler ? this.conditionNodeHandler : SimpleConditionNodeHandler.getInstance();
    }

    public boolean createTask(Execution execution, NodeModel nodeModel) {
        if (null != this.taskCreateInterceptor) {
            this.taskCreateInterceptor.before(this, execution);
        }
        boolean result = this.getCreateTaskHandler().handle(this, execution, nodeModel);
        if (null != this.taskCreateInterceptor) {
            this.taskCreateInterceptor.after(this, execution);
        }
        return result;
    }

    public FlowLongContext build(FlowLongEngine configEngine) {
        if (log.isInfoEnabled()) {
            log.info("FlowLongEngine start......");
        }
        Assert.isNull(configEngine, "Unable to discover implementation class for LongEngine");
        if (log.isInfoEnabled()) {
            log.info("FlowLongEngine be found {}", configEngine.getClass());
        }
        configEngine.configure(this);
        return this;
    }

    public ProcessService getProcessService() {
        return this.processService;
    }

    public QueryService getQueryService() {
        return this.queryService;
    }

    public RuntimeService getRuntimeService() {
        return this.runtimeService;
    }

    public TaskService getTaskService() {
        return this.taskService;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public ConditionNodeHandler getConditionNodeHandler() {
        return this.conditionNodeHandler;
    }

    public TaskCreateInterceptor getTaskCreateInterceptor() {
        return this.taskCreateInterceptor;
    }

    public TaskAccessStrategy getTaskAccessStrategy() {
        return this.taskAccessStrategy;
    }

    public TaskActorProvider getTaskActorProvider() {
        return this.taskActorProvider;
    }

    public TaskReminder getTaskReminder() {
        return this.taskReminder;
    }

    public TaskTrigger getTaskTrigger() {
        return this.taskTrigger;
    }

    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }

    public void setQueryService(QueryService queryService) {
        this.queryService = queryService;
    }

    public void setRuntimeService(RuntimeService runtimeService) {
        this.runtimeService = runtimeService;
    }

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public void setCreateTaskHandler(CreateTaskHandler createTaskHandler) {
        this.createTaskHandler = createTaskHandler;
    }

    public void setConditionNodeHandler(ConditionNodeHandler conditionNodeHandler) {
        this.conditionNodeHandler = conditionNodeHandler;
    }

    public void setTaskCreateInterceptor(TaskCreateInterceptor taskCreateInterceptor) {
        this.taskCreateInterceptor = taskCreateInterceptor;
    }

    public void setTaskAccessStrategy(TaskAccessStrategy taskAccessStrategy) {
        this.taskAccessStrategy = taskAccessStrategy;
    }

    public void setTaskActorProvider(TaskActorProvider taskActorProvider) {
        this.taskActorProvider = taskActorProvider;
    }

    public void setTaskReminder(TaskReminder taskReminder) {
        this.taskReminder = taskReminder;
    }

    public void setTaskTrigger(TaskTrigger taskTrigger) {
        this.taskTrigger = taskTrigger;
    }

    public static void setPROCESS_MODEL_PARSER(ProcessModelParser PROCESS_MODEL_PARSER) {
        FlowLongContext.PROCESS_MODEL_PARSER = PROCESS_MODEL_PARSER;
    }

    public static void setFlowJsonHandler(FlowJsonHandler flowJsonHandler) {
        FlowLongContext.flowJsonHandler = flowJsonHandler;
    }
}

