/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.bpm.engine.core;

import com.aizuda.bpm.engine.FlowLongEngine;
import com.aizuda.bpm.engine.assist.Assert;
import com.aizuda.bpm.engine.assist.DateUtils;
import com.aizuda.bpm.engine.assist.ObjectUtils;
import com.aizuda.bpm.engine.core.Execution;
import com.aizuda.bpm.engine.core.FlowCreator;
import com.aizuda.bpm.engine.core.FlowLongContext;
import com.aizuda.bpm.engine.core.enums.NodeSetType;
import com.aizuda.bpm.engine.core.enums.PerformType;
import com.aizuda.bpm.engine.core.enums.TaskEventType;
import com.aizuda.bpm.engine.core.enums.TaskState;
import com.aizuda.bpm.engine.core.enums.TaskType;
import com.aizuda.bpm.engine.entity.FlwExtInstance;
import com.aizuda.bpm.engine.entity.FlwHisTask;
import com.aizuda.bpm.engine.entity.FlwHisTaskActor;
import com.aizuda.bpm.engine.entity.FlwInstance;
import com.aizuda.bpm.engine.entity.FlwProcess;
import com.aizuda.bpm.engine.entity.FlwTask;
import com.aizuda.bpm.engine.entity.FlwTaskActor;
import com.aizuda.bpm.engine.model.NodeAssignee;
import com.aizuda.bpm.engine.model.NodeModel;
import com.aizuda.bpm.engine.model.ProcessModel;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowLongEngineImpl
implements FlowLongEngine {
    private static final Logger log = LoggerFactory.getLogger(FlowLongEngineImpl.class);
    protected FlowLongContext flowLongContext;

    @Override
    public FlowLongEngine configure(FlowLongContext flowLongContext) {
        this.flowLongContext = flowLongContext;
        return this;
    }

    @Override
    public FlowLongContext getContext() {
        return this.flowLongContext;
    }

    @Override
    public Optional<FlwInstance> startInstanceById(Long id, FlowCreator flowCreator, Map<String, Object> args, Supplier<FlwInstance> supplier) {
        FlwProcess process = this.processService().getProcessById(id);
        return this.startProcessInstance(process.checkState(), flowCreator, args, supplier);
    }

    @Override
    public Optional<FlwInstance> startInstanceByProcessKey(String processKey, Integer version, FlowCreator flowCreator, Map<String, Object> args, Supplier<FlwInstance> supplier) {
        FlwProcess process = this.processService().getProcessByVersion(flowCreator.getTenantId(), processKey, version);
        return this.startProcessInstance(process, flowCreator, args, supplier);
    }

    @Override
    public Optional<FlwInstance> startProcessInstance(FlwProcess process, FlowCreator flowCreator, Map<String, Object> args, Supplier<FlwInstance> supplier) {
        return process.executeStartModel(this.flowLongContext, flowCreator, nodeModel -> {
            FlwInstance flwInstance = this.runtimeService().createInstance(process, flowCreator, args, (NodeModel)nodeModel, supplier);
            if (log.isDebugEnabled()) {
                log.debug("start process instanceId={}", (Object)flwInstance.getId());
            }
            return new Execution(this, process.model(true), flowCreator, flwInstance, args);
        });
    }

    @Override
    public void restartProcessInstance(Long id, String currentNodeKey, Execution execution) {
        FlwProcess process = this.processService().getProcessById(id);
        NodeModel nodeModel = process.model().getNode(currentNodeKey);
        if (null != nodeModel) {
            Optional<NodeModel> nodeModelOptional = nodeModel.nextNode();
            if (nodeModelOptional.isPresent()) {
                nodeModelOptional.get().execute(this.flowLongContext, execution);
            } else {
                execution.endInstance(nodeModel);
            }
        }
    }

    @Override
    public boolean executeTask(Long taskId, FlowCreator flowCreator, Map<String, Object> args) {
        FlwTask flwTask = this.taskService().complete(taskId, flowCreator, ObjectUtils.getArgs(args));
        if (log.isDebugEnabled()) {
            log.debug("Execute complete taskId={}", (Object)taskId);
        }
        return this.afterDoneTask(flowCreator, flwTask, args, execution -> execution.executeNodeModel(this.flowLongContext, execution.getFlwTask().getTaskKey()));
    }

    @Override
    public boolean autoJumpTask(Long taskId, Map<String, Object> args, FlowCreator flowCreator) {
        return this.executeTask(taskId, flowCreator, args, TaskState.autoJump, TaskEventType.autoJump);
    }

    protected boolean executeTask(Long taskId, FlowCreator flowCreator, Map<String, Object> args, TaskState taskState, TaskEventType eventType) {
        FlwTask flwTask = this.taskService().executeTask(taskId, flowCreator, ObjectUtils.getArgs(args), taskState, eventType);
        if (log.isDebugEnabled()) {
            log.debug("Auto execute taskId={}", (Object)taskId);
        }
        return this.afterDoneTask(flowCreator, flwTask, args, execution -> execution.executeNodeModel(this.flowLongContext, execution.getFlwTask().getTaskKey()));
    }

    @Override
    public boolean autoCompleteTask(Long taskId, Map<String, Object> args, FlowCreator flowCreator) {
        return this.executeTask(taskId, flowCreator, null, TaskState.autoComplete, TaskEventType.autoComplete);
    }

    @Override
    public boolean autoRejectTask(FlwTask flwTask, Map<String, Object> args, FlowCreator flowCreator) {
        Optional<FlwTask> flwTaskOptional = this.taskService().rejectTask(flwTask, flowCreator, args);
        if (log.isDebugEnabled()) {
            log.debug("Auto reject taskId={}", (Object)flwTask.getId());
        }
        return flwTaskOptional.isPresent();
    }

    @Override
    public Optional<FlwTask> executeJumpTask(Long taskId, String nodeKey, FlowCreator flowCreator, Map<String, Object> args, TaskType taskTye) {
        return this.taskService().executeJumpTask(taskId, nodeKey, flowCreator, args, flwTask -> {
            FlwInstance flwInstance = this.getFlwInstance(flwTask.getInstanceId(), flowCreator.getCreateBy());
            ProcessModel processModel = this.runtimeService().getProcessModelByInstanceId(flwInstance.getId());
            Execution execution = new Execution(this, processModel, flowCreator, flwInstance, flwInstance.variableToMap());
            execution.setFlwTask((FlwTask)flwTask);
            return execution;
        }, taskTye);
    }

    @Override
    public Optional<FlwTask> executeRejectTask(FlwTask currentFlwTask, String nodeKey, FlowCreator flowCreator, Map<String, Object> args) {
        if (null != nodeKey) {
            return this.executeJumpTask(currentFlwTask.getId(), nodeKey, flowCreator, args, TaskType.rejectJump);
        }
        FlwExtInstance extInstance = this.queryService().getExtInstance(currentFlwTask.getInstanceId());
        ProcessModel processModel = extInstance.model();
        NodeModel nodeModel = processModel.getNode(currentFlwTask.getTaskKey());
        if (Objects.equals(1, nodeModel.getRejectStrategy())) {
            return this.executeJumpTask(currentFlwTask.getId(), processModel.getNodeConfig().getNodeKey(), flowCreator, args, TaskType.rejectJump);
        }
        return this.taskService().rejectTask(currentFlwTask, flowCreator, args);
    }

    @Override
    public List<FlwTask> createNewTask(Long taskId, TaskType taskType, PerformType performType, List<FlwTaskActor> taskActors, FlowCreator flowCreator, Map<String, Object> args) {
        return this.taskService().createNewTask(taskId, taskType, performType, taskActors, flowCreator, (FlwTask flwTask) -> {
            ProcessModel processModel = this.runtimeService().getProcessModelByInstanceId(flwTask.getInstanceId());
            FlwInstance flwInstance = this.getFlwInstance(flwTask.getInstanceId(), flowCreator.getCreateBy());
            return this.createExecution(processModel, flwInstance, (FlwTask)flwTask, flowCreator, args);
        });
    }

    @Override
    public boolean executeAppendNodeModel(Long taskId, NodeModel nodeModel, FlowCreator flowCreator, Map<String, Object> args, boolean beforeAfter) {
        this.runtimeService().appendNodeModel(taskId, nodeModel, beforeAfter);
        if (beforeAfter) {
            return this.executeJumpTask(taskId, nodeModel.getNodeKey(), flowCreator, args);
        }
        return true;
    }

    protected FlwInstance getFlwInstance(Long instanceId, String updateBy) {
        FlwInstance flwInstance = this.queryService().getInstance(instanceId);
        Assert.isNull(flwInstance, "process instance [ id=" + instanceId + " ] completed or not present");
        flwInstance.setLastUpdateBy(updateBy);
        flwInstance.setLastUpdateTime(DateUtils.getCurrentDate());
        this.runtimeService().updateInstance(flwInstance);
        return flwInstance;
    }

    private boolean afterDoneTask(FlowCreator flowCreator, FlwTask flwTask, Map<String, Object> args, Function<Execution, Boolean> executeNextStep) {
        Optional<List<FlwTaskActor>> flwTaskActorsOptional;
        List<FlwTask> flwTaskList;
        if (TaskType.agent.eq(flwTask.getTaskType())) {
            return true;
        }
        Long instanceId = flwTask.getInstanceId();
        PerformType performType = PerformType.get(flwTask.getPerformType());
        if (performType == PerformType.countersign && ObjectUtils.isNotEmpty(flwTaskList = this.queryService().getTasksByInstanceIdAndTaskKey(instanceId, flwTask.getTaskKey()))) {
            return true;
        }
        ProcessModel processModel = this.runtimeService().getProcessModelByInstanceId(instanceId);
        NodeModel nodeModel = processModel.getNode(flwTask.getTaskKey());
        if (Objects.equals(2, nodeModel.getRejectStart())) {
            FlwHisTask hisTask = this.queryService().getHistTask(flwTask.getParentTaskId());
            return this.executeJumpTask(flwTask.getId(), hisTask.getTaskKey(), flowCreator, args, TaskType.reApproveJump).isPresent();
        }
        if (performType == PerformType.voteSign && (flwTaskActorsOptional = this.queryService().getActiveTaskActorsByInstanceId(instanceId)).isPresent()) {
            int passWeight = nodeModel.getPassWeight() == null ? 50 : nodeModel.getPassWeight();
            int votedWeight = 100 - flwTaskActorsOptional.get().stream().mapToInt(t -> t.getWeight() == null ? 0 : t.getWeight()).sum();
            if (votedWeight < passWeight) {
                return true;
            }
            Assert.isFalse(this.taskService().completeActiveTasksByInstanceId(instanceId, flowCreator), "Failed to close voting status");
        }
        FlwInstance flwInstance = this.getFlwInstance(flwTask.getInstanceId(), flowCreator.getCreateBy());
        Execution execution = this.createExecution(processModel, flwInstance, flwTask, flowCreator, ObjectUtils.getArgs(args));
        if (performType == PerformType.sort) {
            boolean findTaskActor = false;
            NodeAssignee nextNodeAssignee = null;
            List<NodeAssignee> nodeAssigneeList = nodeModel.getNodeAssigneeList();
            String assigneeId = flowCreator.getCreateId();
            if (NodeSetType.role.eq(nodeModel.getSetType()) || NodeSetType.department.eq(nodeModel.getSetType())) {
                List<FlwHisTaskActor> htaList = this.flowLongContext.getQueryService().getHisTaskActorsByTaskIdAndActorId(flwTask.getId(), flowCreator.getCreateId());
                if (ObjectUtils.isNotEmpty(htaList)) {
                    assigneeId = htaList.get(0).getAgentId();
                }
            } else if (TaskType.transfer.getValue() == flwTask.getTaskType().intValue()) {
                assigneeId = flwTask.getAssignorId();
            }
            if (ObjectUtils.isEmpty(nodeAssigneeList)) {
                List<FlwTaskActor> taskActors = execution.getTaskActorProvider().getTaskActors(nodeModel, execution);
                if (ObjectUtils.isNotEmpty(taskActors)) {
                    for (FlwTaskActor taskActor : taskActors) {
                        if (findTaskActor) {
                            nextNodeAssignee = NodeAssignee.of(taskActor);
                            break;
                        }
                        if (!Objects.equals(taskActor.getActorId(), assigneeId)) continue;
                        findTaskActor = true;
                    }
                }
            } else {
                for (NodeAssignee nodeAssignee : nodeAssigneeList) {
                    if (findTaskActor) {
                        nextNodeAssignee = nodeAssignee;
                        break;
                    }
                    if (!Objects.equals(nodeAssignee.getId(), assigneeId)) continue;
                    findTaskActor = true;
                }
            }
            if (null != nextNodeAssignee) {
                execution.setNextFlwTaskActor(FlwTaskActor.of(nextNodeAssignee, nodeModel.actorType()));
                return this.flowLongContext.createTask(execution, nodeModel);
            }
        }
        if (performType == PerformType.trigger) {
            this.taskService().executeTaskTrigger(execution, flwTask);
            return true;
        }
        return executeNextStep.apply(execution);
    }

    protected Execution createExecution(ProcessModel processModel, FlwInstance flwInstance, FlwTask flwTask, FlowCreator flowCreator, Map<String, Object> args) {
        Map<String, Object> instanceMaps = flwInstance.variableToMap();
        if (instanceMaps != null) {
            for (Map.Entry<String, Object> entry : instanceMaps.entrySet()) {
                if (args.containsKey(entry.getKey())) continue;
                args.put(entry.getKey(), entry.getValue());
            }
        }
        Execution execution = new Execution(this, processModel, flowCreator, flwInstance, args);
        execution.setFlwTask(flwTask);
        return execution;
    }
}

