/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.bpm.engine.core.enums;

import com.aizuda.bpm.engine.core.enums.InstanceState;
import java.util.Arrays;
import java.util.Objects;

public enum TaskState {
    active(0),
    jump(1),
    complete(2),
    reject(3),
    revoke(4),
    timeout(5),
    terminate(6),
    rejectEnd(7),
    autoComplete(8),
    autoReject(9),
    autoJump(10);

    private final int value;

    private TaskState(int value) {
        this.value = value;
    }

    public boolean ne(Integer value) {
        return !this.eq(value);
    }

    public boolean eq(Integer value) {
        return Objects.equals(this.value, value);
    }

    public static TaskState get(int value) {
        return Arrays.stream(TaskState.values()).filter(s -> s.getValue() == value).findFirst().orElse(null);
    }

    public static TaskState of(InstanceState instanceState) {
        if (instanceState == InstanceState.reject) {
            return rejectEnd;
        }
        if (instanceState == InstanceState.revoke) {
            return revoke;
        }
        if (instanceState == InstanceState.timeout) {
            return timeout;
        }
        if (instanceState == InstanceState.terminate) {
            return terminate;
        }
        return complete;
    }

    public static boolean allowedCheck(TaskState taskState) {
        return active == taskState || jump == taskState || complete == taskState;
    }

    public int getValue() {
        return this.value;
    }
}

