/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.bpm.engine.core.enums;

import java.util.Arrays;
import java.util.Objects;

public enum TaskType {
    end(-1),
    major(0),
    approval(1),
    cc(2),
    conditionNode(3),
    conditionBranch(4),
    callProcess(5),
    timer(6),
    trigger(7),
    parallelBranch(8),
    inclusiveBranch(9),
    transfer(10),
    delegate(11),
    delegateReturn(12),
    agent(13),
    agentReturn(14),
    agentAssist(15),
    agentOwn(16),
    reclaim(17),
    withdraw(18),
    reject(19),
    jump(20),
    rejectJump(21),
    routeJump(22),
    routeBranch(23),
    reApproveJump(24);

    private final int value;

    private TaskType(int value) {
        this.value = value;
    }

    public boolean ne(Integer value) {
        return !this.eq(value);
    }

    public boolean eq(Integer value) {
        return Objects.equals(this.value, value);
    }

    public static TaskType get(int value) {
        return Arrays.stream(TaskType.values()).filter(s -> s.getValue() == value).findFirst().orElse(null);
    }

    public int getValue() {
        return this.value;
    }
}

