/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.bpm.engine.entity;

import com.aizuda.bpm.engine.ProcessModelCache;
import com.aizuda.bpm.engine.core.FlowLongContext;
import com.aizuda.bpm.engine.entity.FlwInstance;
import com.aizuda.bpm.engine.entity.FlwProcess;
import com.aizuda.bpm.engine.model.ProcessModel;
import java.io.Serializable;
import java.util.function.Supplier;

public class FlwExtInstance
implements ProcessModelCache,
Serializable {
    private Long id;
    private String tenantId;
    private Long processId;
    protected String processName;
    protected String processType;
    private String modelContent;

    public static FlwExtInstance of(FlwInstance flwInstance, FlwProcess flwProcess) {
        FlwExtInstance ext = new FlwExtInstance();
        ext.id = flwInstance.getId();
        ext.tenantId = flwInstance.getTenantId();
        ext.processId = flwInstance.getProcessId();
        ext.processName = flwProcess.getProcessName();
        ext.processType = flwProcess.getProcessType();
        ext.modelContent = flwProcess.getModelContent();
        return ext;
    }

    @Override
    public String modelCacheKey() {
        return "flwProcessInstanceModel#" + this.id;
    }

    public static ProcessModel cacheProcessModelById(Long id, Supplier<ProcessModel> supplier) {
        ProcessModel processModel = FlowLongContext.parseProcessModel(null, "flwProcessInstanceModel#" + id, false);
        if (null == processModel && null != supplier) {
            processModel = supplier.get();
        }
        return processModel;
    }

    public Long getId() {
        return this.id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Long getProcessId() {
        return this.processId;
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getProcessType() {
        return this.processType;
    }

    @Override
    public String getModelContent() {
        return this.modelContent;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setProcessId(Long processId) {
        this.processId = processId;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public void setProcessType(String processType) {
        this.processType = processType;
    }

    public void setModelContent(String modelContent) {
        this.modelContent = modelContent;
    }

    public String toString() {
        return "FlwExtInstance(id=" + this.getId() + ", tenantId=" + this.getTenantId() + ", processId=" + this.getProcessId() + ", processName=" + this.getProcessName() + ", processType=" + this.getProcessType() + ", modelContent=" + this.getModelContent() + ")";
    }
}

