/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.bpm.engine.entity;

import com.aizuda.bpm.engine.assist.Assert;
import com.aizuda.bpm.engine.assist.DateUtils;
import com.aizuda.bpm.engine.core.enums.InstanceState;
import com.aizuda.bpm.engine.entity.FlwInstance;
import java.util.Date;

public class FlwHisInstance
extends FlwInstance {
    protected Integer instanceState;
    protected Date endTime;
    protected Long duration;

    public void setVariable(Integer instanceState) {
        this.instanceState = instanceState;
    }

    public void setInstanceState(InstanceState instanceState) {
        this.instanceState = instanceState.getValue();
    }

    public void setInstanceState(Integer instanceState) {
        Assert.isNull((Object)InstanceState.get(instanceState), "\u63d2\u5165\u7684\u5b9e\u4f8b\u72b6\u6001\u5f02\u5e38 [instanceState=" + instanceState + "]");
        this.instanceState = instanceState;
    }

    public static FlwHisInstance of(FlwInstance fi, InstanceState instanceState) {
        FlwHisInstance his = new FlwHisInstance();
        his.id = fi.getId();
        his.tenantId = fi.getTenantId();
        his.createId = fi.getCreateId();
        his.createBy = fi.getCreateBy();
        his.createTime = fi.getCreateTime();
        his.processId = fi.getProcessId();
        his.parentInstanceId = fi.getParentInstanceId();
        his.priority = fi.getPriority();
        his.instanceNo = fi.getInstanceNo();
        his.businessKey = fi.getBusinessKey();
        his.variable = fi.getVariable();
        his.currentNodeName = fi.getCurrentNodeName();
        his.currentNodeKey = fi.getCurrentNodeKey();
        his.expireTime = fi.getExpireTime();
        his.lastUpdateBy = fi.getLastUpdateBy();
        his.lastUpdateTime = fi.getLastUpdateTime();
        his.instanceState = instanceState.getValue();
        if (InstanceState.active != instanceState) {
            his.calculateDuration();
        }
        return his;
    }

    public FlwInstance toFlwInstance() {
        FlwInstance fi = new FlwInstance();
        fi.setId(this.id);
        fi.setTenantId(this.tenantId);
        fi.setCreateId(this.createId);
        fi.setCreateBy(this.createBy);
        fi.setCreateTime(this.createTime);
        fi.setProcessId(this.processId);
        fi.setParentInstanceId(this.parentInstanceId);
        fi.setPriority(this.priority);
        fi.setInstanceNo(this.instanceNo);
        fi.setBusinessKey(this.businessKey);
        fi.setVariable(this.variable);
        fi.setCurrentNodeName(this.currentNodeName);
        fi.setCurrentNodeKey(this.currentNodeKey);
        fi.setExpireTime(this.expireTime);
        fi.setLastUpdateBy(this.lastUpdateBy);
        fi.setLastUpdateTime(this.lastUpdateTime);
        return fi;
    }

    public void calculateDuration() {
        this.endTime = DateUtils.getCurrentDate();
        this.duration = DateUtils.calculateDateDifference(this.createTime, this.endTime);
    }

    public Integer getInstanceState() {
        return this.instanceState;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Long getDuration() {
        return this.duration;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    @Override
    public String toString() {
        return "FlwHisInstance(instanceState=" + this.getInstanceState() + ", endTime=" + this.getEndTime() + ", duration=" + this.getDuration() + ")";
    }
}

