/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.bpm.engine.entity;

import com.aizuda.bpm.engine.assist.Assert;
import com.aizuda.bpm.engine.assist.DateUtils;
import com.aizuda.bpm.engine.core.enums.TaskState;
import com.aizuda.bpm.engine.core.enums.TaskType;
import com.aizuda.bpm.engine.entity.FlwInstance;
import com.aizuda.bpm.engine.entity.FlwTask;
import com.aizuda.bpm.engine.model.NodeModel;
import java.util.Date;

public class FlwHisTask
extends FlwTask {
    protected Long callProcessId;
    protected Long callInstanceId;
    protected Date finishTime;
    protected Integer taskState;
    protected Long duration;

    public FlwHisTask setTaskState(TaskState taskState) {
        this.taskState = taskState.getValue();
        return this;
    }

    public FlwHisTask setTaskState(Integer taskState) {
        Assert.isNull((Object)TaskState.get(taskState), "\u63d2\u5165\u7684\u5b9e\u4f8b\u72b6\u6001\u5f02\u5e38 [taskState=" + taskState + "]");
        this.taskState = taskState;
        return this;
    }

    public static FlwHisTask of(FlwTask flwTask, TaskState taskState) {
        return FlwHisTask.of(flwTask).setTaskState(taskState);
    }

    public static FlwHisTask of(FlwTask flwTask) {
        FlwHisTask hisTask = new FlwHisTask();
        hisTask.id = flwTask.getId();
        hisTask.tenantId = flwTask.getTenantId();
        hisTask.createId = flwTask.getCreateId();
        hisTask.createBy = flwTask.getCreateBy();
        hisTask.createTime = flwTask.getCreateTime();
        hisTask.instanceId = flwTask.getInstanceId();
        hisTask.parentTaskId = flwTask.getParentTaskId();
        hisTask.taskName = flwTask.getTaskName();
        hisTask.taskKey = flwTask.getTaskKey();
        hisTask.taskType = flwTask.getTaskType();
        hisTask.performType = flwTask.getPerformType();
        hisTask.actionUrl = flwTask.getActionUrl();
        hisTask.variable = flwTask.getVariable();
        hisTask.assignorId = flwTask.getAssignorId();
        hisTask.assignor = flwTask.getAssignor();
        hisTask.expireTime = flwTask.getExpireTime();
        hisTask.remindTime = flwTask.getRemindTime();
        hisTask.remindRepeat = flwTask.getRemindRepeat();
        hisTask.viewed = flwTask.getViewed();
        return hisTask;
    }

    public static FlwHisTask ofCallInstance(NodeModel nodeModel, FlwInstance instance) {
        FlwHisTask flwHisTask = new FlwHisTask();
        flwHisTask.setTenantId(instance.getTenantId());
        flwHisTask.setCreateId(instance.getCreateId());
        flwHisTask.setCreateBy(instance.getCreateBy());
        flwHisTask.setCreateTime(instance.getCreateTime());
        flwHisTask.setInstanceId(instance.getParentInstanceId());
        flwHisTask.setTaskName(nodeModel.getNodeName());
        flwHisTask.setTaskKey(nodeModel.getNodeKey());
        flwHisTask.setCallProcessId(instance.getProcessId());
        flwHisTask.setCallInstanceId(instance.getId());
        flwHisTask.setTaskType(nodeModel.getType());
        return flwHisTask;
    }

    public FlwTask undoTask(TaskType taskType) {
        FlwTask flwTask = this.cloneTask(this.createId, this.createBy);
        flwTask.taskType(taskType);
        return flwTask;
    }

    public void calculateDuration() {
        this.finishTime = DateUtils.getCurrentDate();
        this.duration = DateUtils.calculateDateDifference(this.createTime, this.finishTime);
    }

    public Long getCallProcessId() {
        return this.callProcessId;
    }

    public Long getCallInstanceId() {
        return this.callInstanceId;
    }

    public Date getFinishTime() {
        return this.finishTime;
    }

    public Integer getTaskState() {
        return this.taskState;
    }

    public Long getDuration() {
        return this.duration;
    }

    public void setCallProcessId(Long callProcessId) {
        this.callProcessId = callProcessId;
    }

    public void setCallInstanceId(Long callInstanceId) {
        this.callInstanceId = callInstanceId;
    }

    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    @Override
    public String toString() {
        return "FlwHisTask(callProcessId=" + this.getCallProcessId() + ", callInstanceId=" + this.getCallInstanceId() + ", finishTime=" + this.getFinishTime() + ", taskState=" + this.getTaskState() + ", duration=" + this.getDuration() + ")";
    }
}

