/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.bpm.engine.entity;

import com.aizuda.bpm.engine.ProcessModelCache;
import com.aizuda.bpm.engine.assist.Assert;
import com.aizuda.bpm.engine.assist.DateUtils;
import com.aizuda.bpm.engine.core.Execution;
import com.aizuda.bpm.engine.core.FlowCreator;
import com.aizuda.bpm.engine.core.FlowLongContext;
import com.aizuda.bpm.engine.core.enums.FlowState;
import com.aizuda.bpm.engine.entity.FlowEntity;
import com.aizuda.bpm.engine.entity.FlwInstance;
import com.aizuda.bpm.engine.model.ModelHelper;
import com.aizuda.bpm.engine.model.NodeModel;
import com.aizuda.bpm.engine.model.ProcessModel;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class FlwProcess
extends FlowEntity
implements ProcessModelCache {
    protected String processKey;
    protected String processName;
    protected String processIcon;
    protected String processType;
    protected Integer processVersion;
    protected String instanceUrl;
    protected String remark;
    protected Integer useScope;
    protected Integer processState;
    protected String modelContent;
    protected Integer sort;

    public void setFlowState(FlowState flowState) {
        this.processState = flowState.getValue();
    }

    @Override
    public String modelCacheKey() {
        return "flwProcessModel#" + this.id;
    }

    public static FlwProcess of(FlowCreator flowCreator, ProcessModel processModel, int processVersion, String jsonString) {
        FlwProcess process = new FlwProcess();
        process.setProcessVersion(processVersion);
        process.setFlowState(FlowState.active);
        process.setProcessKey(processModel.getKey());
        process.setProcessName(processModel.getName());
        process.setInstanceUrl(processModel.getInstanceUrl());
        process.setUseScope(0);
        process.setSort(0);
        process.setFlowCreator(flowCreator);
        process.setCreateTime(DateUtils.getCurrentDate());
        return process.formatModelContent(jsonString);
    }

    public Optional<FlwInstance> executeStartModel(FlowLongContext flowLongContext, FlowCreator flowCreator, Function<NodeModel, Execution> function) {
        FlwInstance flwInstance = null;
        if (null != this.modelContent) {
            NodeModel nodeModel = this.model().getNodeConfig();
            Assert.isNull(nodeModel, "\u6d41\u7a0b\u5b9a\u4e49[processName=" + this.processName + ", processVersion=" + this.processVersion + "]\u6ca1\u6709\u5f00\u59cb\u8282\u70b9");
            Assert.isFalse(flowLongContext.getTaskActorProvider().isAllowed(nodeModel, flowCreator), "No permission to execute");
            Assert.isTrue(ModelHelper.checkDuplicateNodeKeys(nodeModel), "There are duplicate node keys present");
            Execution execution = function.apply(nodeModel);
            nodeModel = execution.getProcessModel().getNodeConfig();
            flowLongContext.createTask(execution, nodeModel);
            flwInstance = execution.getFlwInstance();
        }
        return Optional.ofNullable(flwInstance);
    }

    public FlwProcess checkState() {
        if (Objects.equals(0, this.processState)) {
            Assert.illegal("\u6307\u5b9a\u7684\u6d41\u7a0b\u5b9a\u4e49[id=" + this.id + ",processVersion=" + this.processVersion + "]\u4e3a\u975e\u6d3b\u52a8\u72b6\u6001");
        }
        return this;
    }

    public FlwProcess formatModelContent(String modelContent) {
        return this.setModelContent2Json(FlowLongContext.fromJson(modelContent, ProcessModel.class));
    }

    public FlwProcess setModelContent2Json(ProcessModel processModel) {
        this.modelContent = FlowLongContext.toJson(processModel);
        return this;
    }

    public int nextProcessVersion() {
        return this.processVersion + 1;
    }

    public String getProcessKey() {
        return this.processKey;
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getProcessIcon() {
        return this.processIcon;
    }

    public String getProcessType() {
        return this.processType;
    }

    public Integer getProcessVersion() {
        return this.processVersion;
    }

    public String getInstanceUrl() {
        return this.instanceUrl;
    }

    public String getRemark() {
        return this.remark;
    }

    public Integer getUseScope() {
        return this.useScope;
    }

    public Integer getProcessState() {
        return this.processState;
    }

    @Override
    public String getModelContent() {
        return this.modelContent;
    }

    public Integer getSort() {
        return this.sort;
    }

    public void setProcessKey(String processKey) {
        this.processKey = processKey;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public void setProcessIcon(String processIcon) {
        this.processIcon = processIcon;
    }

    public void setProcessType(String processType) {
        this.processType = processType;
    }

    public void setProcessVersion(Integer processVersion) {
        this.processVersion = processVersion;
    }

    public void setInstanceUrl(String instanceUrl) {
        this.instanceUrl = instanceUrl;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setUseScope(Integer useScope) {
        this.useScope = useScope;
    }

    public void setProcessState(Integer processState) {
        this.processState = processState;
    }

    public void setModelContent(String modelContent) {
        this.modelContent = modelContent;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public String toString() {
        return "FlwProcess(processKey=" + this.getProcessKey() + ", processName=" + this.getProcessName() + ", processIcon=" + this.getProcessIcon() + ", processType=" + this.getProcessType() + ", processVersion=" + this.getProcessVersion() + ", instanceUrl=" + this.getInstanceUrl() + ", remark=" + this.getRemark() + ", useScope=" + this.getUseScope() + ", processState=" + this.getProcessState() + ", modelContent=" + this.getModelContent() + ", sort=" + this.getSort() + ")";
    }
}

