/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.bpm.engine.entity;

import com.aizuda.bpm.engine.assist.Assert;
import com.aizuda.bpm.engine.assist.DateUtils;
import com.aizuda.bpm.engine.core.FlowLongContext;
import com.aizuda.bpm.engine.core.enums.PerformType;
import com.aizuda.bpm.engine.core.enums.TaskType;
import com.aizuda.bpm.engine.entity.FlowEntity;
import com.aizuda.bpm.engine.entity.FlwHisTaskActor;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

public class FlwTask
extends FlowEntity {
    protected Long instanceId;
    protected Long parentTaskId;
    protected String taskName;
    protected String taskKey;
    protected Integer taskType;
    protected Integer performType;
    protected String actionUrl;
    protected String variable;
    protected String assignorId;
    protected String assignor;
    protected Date expireTime;
    protected Date remindTime;
    protected Integer remindRepeat;
    protected Integer viewed;

    public boolean major() {
        return Objects.equals(this.taskType, TaskType.major.getValue());
    }

    public Map<String, Object> variableMap() {
        Map map = FlowLongContext.fromJson(this.variable, Map.class);
        return null == map ? Collections.emptyMap() : map;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public void taskType(TaskType taskType) {
        this.taskType = taskType.getValue();
    }

    public void setTaskType(Integer taskType) {
        Assert.isNull((Object)TaskType.get(taskType), "illegal type [taskType=" + taskType + "]");
        this.taskType = taskType;
    }

    public void setPerformType(PerformType performType) {
        this.performType = performType.getValue();
    }

    public void setPerformType(Integer performType) {
        Assert.isNull((Object)PerformType.get(performType), "illegal type [performType=" + performType + "]");
        this.performType = performType;
    }

    public void setVariable(Map<String, Object> args) {
        if (null != args && !args.isEmpty()) {
            this.variable = FlowLongContext.toJson(args);
        }
    }

    public void loadExpireTime(Map<String, Object> extendConfig, boolean checkEmpty) {
        String time;
        Date expireTime = null;
        if (null != extendConfig && null != (time = (String)extendConfig.get("time"))) {
            expireTime = DateUtils.parseTimerTaskTime(time);
        }
        if (checkEmpty) {
            Assert.isEmpty(expireTime, "Timer task config error");
        }
        this.expireTime = expireTime;
    }

    public boolean startNode() {
        return Objects.equals(0L, this.parentTaskId);
    }

    public FlwTask cloneTask(FlwHisTaskActor flwHisTaskActor) {
        if (null != flwHisTaskActor) {
            this.createId = flwHisTaskActor.getActorId();
            this.createBy = flwHisTaskActor.getActorName();
        }
        return this.cloneTask(this.createId, this.createBy);
    }

    public FlwTask cloneTask(String createId, String createBy) {
        FlwTask newFlwTask = new FlwTask();
        newFlwTask.setTenantId(this.tenantId);
        newFlwTask.setInstanceId(this.instanceId);
        newFlwTask.setParentTaskId(this.parentTaskId);
        newFlwTask.setTaskName(this.taskName);
        newFlwTask.setTaskKey(this.taskKey);
        newFlwTask.setTaskType(this.taskType);
        newFlwTask.setPerformType(this.performType);
        newFlwTask.setActionUrl(this.actionUrl);
        newFlwTask.setVariable(this.variable);
        newFlwTask.setAssignorId(this.assignorId);
        newFlwTask.setAssignor(this.assignor);
        newFlwTask.setExpireTime(this.expireTime);
        newFlwTask.setRemindTime(this.remindTime);
        newFlwTask.setRemindRepeat(this.remindRepeat);
        newFlwTask.setViewed(this.viewed);
        newFlwTask.setCreateId(createId);
        newFlwTask.setCreateBy(createBy);
        newFlwTask.setCreateTime(DateUtils.getCurrentDate());
        return newFlwTask;
    }

    public Long getInstanceId() {
        return this.instanceId;
    }

    public Long getParentTaskId() {
        return this.parentTaskId;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getTaskKey() {
        return this.taskKey;
    }

    public Integer getTaskType() {
        return this.taskType;
    }

    public Integer getPerformType() {
        return this.performType;
    }

    public String getActionUrl() {
        return this.actionUrl;
    }

    public String getVariable() {
        return this.variable;
    }

    public String getAssignorId() {
        return this.assignorId;
    }

    public String getAssignor() {
        return this.assignor;
    }

    public Date getExpireTime() {
        return this.expireTime;
    }

    public Date getRemindTime() {
        return this.remindTime;
    }

    public Integer getRemindRepeat() {
        return this.remindRepeat;
    }

    public Integer getViewed() {
        return this.viewed;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public void setParentTaskId(Long parentTaskId) {
        this.parentTaskId = parentTaskId;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public void setTaskKey(String taskKey) {
        this.taskKey = taskKey;
    }

    public void setActionUrl(String actionUrl) {
        this.actionUrl = actionUrl;
    }

    public void setAssignorId(String assignorId) {
        this.assignorId = assignorId;
    }

    public void setAssignor(String assignor) {
        this.assignor = assignor;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public void setRemindTime(Date remindTime) {
        this.remindTime = remindTime;
    }

    public void setRemindRepeat(Integer remindRepeat) {
        this.remindRepeat = remindRepeat;
    }

    public void setViewed(Integer viewed) {
        this.viewed = viewed;
    }

    public String toString() {
        return "FlwTask(instanceId=" + this.getInstanceId() + ", parentTaskId=" + this.getParentTaskId() + ", taskName=" + this.getTaskName() + ", taskKey=" + this.getTaskKey() + ", taskType=" + this.getTaskType() + ", performType=" + this.getPerformType() + ", actionUrl=" + this.getActionUrl() + ", variable=" + this.getVariable() + ", assignorId=" + this.getAssignorId() + ", assignor=" + this.getAssignor() + ", expireTime=" + this.getExpireTime() + ", remindTime=" + this.getRemindTime() + ", remindRepeat=" + this.getRemindRepeat() + ", viewed=" + this.getViewed() + ")";
    }
}

