/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.bpm.engine.entity;

import com.aizuda.bpm.engine.core.FlowCreator;
import com.aizuda.bpm.engine.core.FlowLongContext;
import com.aizuda.bpm.engine.core.enums.AgentType;
import com.aizuda.bpm.engine.entity.FlwHisTaskActor;
import com.aizuda.bpm.engine.entity.FlwInstance;
import com.aizuda.bpm.engine.entity.FlwTask;
import com.aizuda.bpm.engine.model.NodeAssignee;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Objects;

public class FlwTaskActor
implements Serializable {
    protected Long id;
    protected String tenantId;
    protected Long instanceId;
    protected Long taskId;
    protected String actorId;
    protected String actorName;
    protected Integer actorType;
    protected Integer weight;
    protected String agentId;
    protected Integer agentType;
    protected String extend;

    public boolean agentActor() {
        return Objects.equals(0, this.actorType);
    }

    public boolean eqActorId(String actorId) {
        return Objects.equals(this.actorId, actorId);
    }

    public static FlwTaskActor of(FlowCreator flowCreator, FlwTask flwTask) {
        FlwTaskActor flwTaskActor = FlwTaskActor.ofUser(flowCreator.getTenantId(), flowCreator.getCreateId(), flowCreator.getCreateBy());
        flwTaskActor.setInstanceId(flwTask.getInstanceId());
        flwTaskActor.setTaskId(flwTask.getId());
        return flwTaskActor;
    }

    public static FlwTaskActor ofAgentIt(FlowCreator flowCreator) {
        FlwTaskActor flwTaskActor = new FlwTaskActor();
        flwTaskActor.setAgentId(flowCreator.getCreateId());
        flwTaskActor.setAgentType(1);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("createBy", flowCreator.getCreateBy());
        flwTaskActor.setExtendOf(map);
        return flwTaskActor;
    }

    public static FlwTaskActor ofAgent(AgentType agentType, FlowCreator flowCreator, FlwTask flwTask, FlwTaskActor agentTaskActor) {
        FlwTaskActor flwTaskActor = FlwTaskActor.of(flowCreator, flwTask);
        flwTaskActor.setAgentId(agentTaskActor.getActorId());
        flwTaskActor.setAgentType(agentType.getValue());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("actorType", agentTaskActor.getActorType());
        map.put("actorName", agentTaskActor.getActorName());
        flwTaskActor.setExtendOf(map);
        return flwTaskActor;
    }

    public static FlwTaskActor ofFlwTask(FlwTask flwTask) {
        FlwTaskActor flwTaskActor = FlwTaskActor.ofUser(flwTask.getTenantId(), flwTask.getCreateId(), flwTask.getCreateBy());
        flwTaskActor.setInstanceId(flwTask.getInstanceId());
        flwTaskActor.setTaskId(flwTask.getId());
        return flwTaskActor;
    }

    public static FlwTaskActor ofFlowCreator(FlowCreator flowCreator) {
        return FlwTaskActor.ofUser(flowCreator.getTenantId(), flowCreator.getCreateId(), flowCreator.getCreateBy());
    }

    public static FlwTaskActor ofFlwInstance(FlwInstance flwInstance, Long taskId) {
        FlwTaskActor flwTaskActor = FlwTaskActor.ofUser(flwInstance.getTenantId(), flwInstance.getCreateId(), flwInstance.getCreateBy());
        flwTaskActor.setInstanceId(flwInstance.getId());
        flwTaskActor.setTaskId(taskId);
        return flwTaskActor;
    }

    public static FlwTaskActor ofNodeAssignee(NodeAssignee nodeAssignee) {
        return FlwTaskActor.ofUser(nodeAssignee.getTenantId(), nodeAssignee.getId(), nodeAssignee.getName());
    }

    public static FlwTaskActor ofUser(String tenantId, String actorId, String actorName) {
        return FlwTaskActor.of(tenantId, actorId, actorName, 0, null);
    }

    public static FlwTaskActor ofRole(String tenantId, String actorId, String actorName) {
        return FlwTaskActor.of(tenantId, actorId, actorName, 1, null);
    }

    public static FlwTaskActor ofDepartment(String tenantId, String actorId, String actorName) {
        return FlwTaskActor.of(tenantId, actorId, actorName, 2, null);
    }

    public static FlwTaskActor of(NodeAssignee nodeAssignee, Integer actorType) {
        return FlwTaskActor.of(nodeAssignee.getTenantId(), nodeAssignee.getId(), nodeAssignee.getName(), actorType, nodeAssignee.getWeight());
    }

    public static FlwTaskActor of(Long taskId, FlwHisTaskActor t) {
        FlwTaskActor flwTaskActor = FlwTaskActor.of(t.getTenantId(), t.getActorId(), t.getActorName(), t.getActorType(), t.getWeight());
        flwTaskActor.setTaskId(taskId);
        flwTaskActor.setInstanceId(t.getInstanceId());
        return flwTaskActor;
    }

    protected static FlwTaskActor of(String tenantId, String actorId, String actorName, Integer actorType, Integer weight) {
        FlwTaskActor taskActor = new FlwTaskActor();
        taskActor.setTenantId(tenantId);
        taskActor.setActorId(actorId);
        taskActor.setActorName(actorName);
        taskActor.setActorType(actorType);
        taskActor.setWeight(weight);
        return taskActor;
    }

    public static FlwTaskActor ofFlwHisTaskActor(Long taskId, FlwHisTaskActor hta) {
        FlwTaskActor taskActor = new FlwTaskActor();
        taskActor.setTenantId(hta.getTenantId());
        taskActor.setInstanceId(hta.getInstanceId());
        taskActor.setTaskId(taskId);
        taskActor.setActorId(hta.getActorId());
        taskActor.setActorName(hta.getActorName());
        taskActor.setActorType(hta.getActorType());
        taskActor.setWeight(hta.getWeight());
        taskActor.setAgentId(hta.getAgentId());
        taskActor.setAgentType(hta.getAgentType());
        taskActor.setExtend(hta.getExtend());
        return taskActor;
    }

    public void setExtendOf(Object object) {
        this.extend = FlowLongContext.toJson(object);
    }

    public Long getId() {
        return this.id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Long getInstanceId() {
        return this.instanceId;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public String getActorId() {
        return this.actorId;
    }

    public String getActorName() {
        return this.actorName;
    }

    public Integer getActorType() {
        return this.actorType;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public Integer getAgentType() {
        return this.agentType;
    }

    public String getExtend() {
        return this.extend;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public void setActorId(String actorId) {
        this.actorId = actorId;
    }

    public void setActorName(String actorName) {
        this.actorName = actorName;
    }

    public void setActorType(Integer actorType) {
        this.actorType = actorType;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public void setAgentType(Integer agentType) {
        this.agentType = agentType;
    }

    public void setExtend(String extend) {
        this.extend = extend;
    }

    public String toString() {
        return "FlwTaskActor(id=" + this.getId() + ", tenantId=" + this.getTenantId() + ", instanceId=" + this.getInstanceId() + ", taskId=" + this.getTaskId() + ", actorId=" + this.getActorId() + ", actorName=" + this.getActorName() + ", actorType=" + this.getActorType() + ", weight=" + this.getWeight() + ", agentId=" + this.getAgentId() + ", agentType=" + this.getAgentType() + ", extend=" + this.getExtend() + ")";
    }
}

