/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.bpm.engine.handler.impl;

import com.aizuda.bpm.engine.Expression;
import com.aizuda.bpm.engine.FlowDataTransfer;
import com.aizuda.bpm.engine.assist.Assert;
import com.aizuda.bpm.engine.assist.ObjectUtils;
import com.aizuda.bpm.engine.core.Execution;
import com.aizuda.bpm.engine.core.FlowLongContext;
import com.aizuda.bpm.engine.handler.ConditionNodeHandler;
import com.aizuda.bpm.engine.model.ConditionNode;
import com.aizuda.bpm.engine.model.NodeModel;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class SimpleConditionNodeHandler
implements ConditionNodeHandler {
    private static SimpleConditionNodeHandler conditionNodeHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SimpleConditionNodeHandler getInstance() {
        if (null != conditionNodeHandler) return conditionNodeHandler;
        Class<SimpleConditionNodeHandler> clazz = SimpleConditionNodeHandler.class;
        synchronized (SimpleConditionNodeHandler.class) {
            conditionNodeHandler = new SimpleConditionNodeHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return conditionNodeHandler;
        }
    }

    @Override
    public Optional<ConditionNode> getConditionNode(FlowLongContext flowLongContext, Execution execution, NodeModel nodeModel) {
        Optional<ConditionNode> conditionNodeOptional = this.matchConditionNode(flowLongContext, execution, nodeModel.getConditionNodes());
        if (conditionNodeOptional.isPresent()) {
            return conditionNodeOptional;
        }
        return this.defaultConditionNode(nodeModel.getConditionNodes());
    }

    public Optional<ConditionNode> matchConditionNode(FlowLongContext flowLongContext, Execution execution, List<ConditionNode> conditionNodes) {
        String conditionNodeKey = (String)FlowDataTransfer.get("flwProcessSpecifyConditionNodeKey");
        if (null != conditionNodeKey) {
            FlowDataTransfer.removeByKey("flwProcessSpecifyConditionNodeKey");
            Optional<ConditionNode> conditionNodeKeyOptional = conditionNodes.stream().filter(t -> Objects.equals(t.getNodeKey(), conditionNodeKey)).findFirst();
            if (conditionNodeKeyOptional.isPresent()) {
                return conditionNodeKeyOptional;
            }
        }
        Map<String, Object> args = this.getArgs(flowLongContext, execution);
        Expression expression = flowLongContext.checkExpression();
        return conditionNodes.stream().sorted(Comparator.comparing(ConditionNode::getPriorityLevel)).filter(t -> expression.eval(t.getConditionList(), args)).findFirst();
    }

    @Override
    public Optional<ConditionNode> getRouteNode(FlowLongContext flowLongContext, Execution execution, NodeModel nodeModel) {
        return this.matchConditionNode(flowLongContext, execution, nodeModel.getRouteNodes());
    }

    public Map<String, Object> getArgs(FlowLongContext flowLongContext, Execution execution) {
        Map<String, Object> args = execution.getArgs();
        return ObjectUtils.isEmpty(args) ? Collections.emptyMap() : args;
    }

    public Optional<ConditionNode> defaultConditionNode(List<ConditionNode> conditionNodes) {
        Optional<ConditionNode> cnOpt = conditionNodes.stream().filter(t -> ObjectUtils.isEmpty(t.getConditionList())).findFirst();
        Assert.isFalse(cnOpt.isPresent(), "Not found executable ConditionNode");
        return cnOpt;
    }

    @Override
    public Optional<List<ConditionNode>> getInclusiveNodes(FlowLongContext flowLongContext, Execution execution, NodeModel nodeModel) {
        List<ConditionNode> inclusiveNodes = nodeModel.getInclusiveNodes();
        Expression expression = flowLongContext.checkExpression();
        Map<String, Object> args = this.getArgs(flowLongContext, execution);
        List<Object> cnsOpt = inclusiveNodes.stream().filter(t -> expression.eval(t.getConditionList(), args)).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(cnsOpt)) {
            cnsOpt = Collections.singletonList(this.defaultConditionNode(inclusiveNodes).get());
        }
        return Optional.of(cnsOpt);
    }
}

