/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.bpm.engine.impl;

import com.aizuda.bpm.engine.ProcessModelParser;
import com.aizuda.bpm.engine.assist.Assert;
import com.aizuda.bpm.engine.cache.FlowCache;
import com.aizuda.bpm.engine.cache.FlowSimpleCache;
import com.aizuda.bpm.engine.core.FlowLongContext;
import com.aizuda.bpm.engine.model.ProcessModel;

public class DefaultProcessModelParser
implements ProcessModelParser {
    private FlowCache flowCache;

    public DefaultProcessModelParser(FlowCache flowCache) {
        this.flowCache = null == flowCache ? new FlowSimpleCache() : flowCache;
    }

    @Override
    public ProcessModel parse(String content, String cacheKey, boolean redeploy) {
        if (null != cacheKey) {
            FlowCache flowCache = this.getFlowCache();
            ProcessModel processModel = (ProcessModel)flowCache.get(cacheKey);
            if (null != content && (null == processModel || redeploy)) {
                processModel = this.parseProcessModel(content);
                flowCache.put(cacheKey, processModel);
            }
            return processModel;
        }
        return this.parseProcessModel(content);
    }

    private ProcessModel parseProcessModel(String content) {
        ProcessModel processModel = FlowLongContext.fromJson(content, ProcessModel.class);
        Assert.isNull(processModel, "process model json parser error");
        processModel.buildParentNode(processModel.getNodeConfig());
        return processModel;
    }

    @Override
    public void invalidate(String cacheKey) {
        this.getFlowCache().remove(cacheKey);
    }

    @Override
    public FlowCache getFlowCache() {
        return this.flowCache;
    }

    public void setFlowCache(FlowCache flowCache) {
        this.flowCache = flowCache;
    }
}

