/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.bpm.engine.impl;

import com.aizuda.bpm.engine.ProcessService;
import com.aizuda.bpm.engine.RuntimeService;
import com.aizuda.bpm.engine.assist.Assert;
import com.aizuda.bpm.engine.assist.ObjectUtils;
import com.aizuda.bpm.engine.core.FlowCreator;
import com.aizuda.bpm.engine.core.FlowLongContext;
import com.aizuda.bpm.engine.core.enums.FlowState;
import com.aizuda.bpm.engine.dao.FlwProcessDao;
import com.aizuda.bpm.engine.entity.FlwProcess;
import com.aizuda.bpm.engine.model.ProcessModel;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessServiceImpl
implements ProcessService {
    private static final Logger log = LoggerFactory.getLogger(ProcessServiceImpl.class);
    private final FlwProcessDao processDao;
    private final RuntimeService runtimeService;

    public ProcessServiceImpl(RuntimeService runtimeService, FlwProcessDao processDao) {
        this.processDao = processDao;
        this.runtimeService = runtimeService;
    }

    @Override
    public void updateType(Long id, String processType) {
        FlwProcess process = new FlwProcess();
        process.setId(id);
        process.setProcessType(processType);
        this.processDao.updateById(process);
    }

    @Override
    public FlwProcess getProcessById(Long id) {
        FlwProcess process = this.processDao.selectById(id);
        Assert.isTrue(ObjectUtils.isEmpty(process), "process id [" + id + "] does not exist");
        return process;
    }

    @Override
    public FlwProcess getProcessByVersion(String tenantId, String processKey, Integer version) {
        Assert.isEmpty(processKey);
        List<FlwProcess> processList = this.processDao.selectListByProcessKeyAndVersion(tenantId, processKey, version);
        Assert.isTrue(ObjectUtils.isEmpty(processList), "process key [" + processKey + "] does not exist");
        return processList.get(0);
    }

    @Override
    public Long deploy(Long processId, String jsonString, FlowCreator flowCreator, boolean repeat, Consumer<FlwProcess> processSave) {
        Assert.isNull(jsonString);
        try {
            ProcessModel processModel = FlowLongContext.parseProcessModel(jsonString, null, false);
            FlwProcess dbProcess = null;
            if (null == processId) {
                List<FlwProcess> processList = this.processDao.selectListByProcessKeyAndVersion(flowCreator.getTenantId(), processModel.getKey(), null);
                if (ObjectUtils.isNotEmpty(processList)) {
                    dbProcess = processList.get(0);
                }
            } else {
                dbProcess = this.processDao.selectById(processId);
            }
            int processVersion = 1;
            if (null != dbProcess) {
                boolean rows;
                if (!repeat) {
                    return dbProcess.getId();
                }
                Assert.isTrue(FlowState.history.eq(dbProcess.getProcessState()), "Not allowed status");
                FlwProcess his = new FlwProcess();
                his.setFlowState(FlowState.history);
                if (Objects.equals(processModel.getKey(), dbProcess.getProcessKey())) {
                    his.setId(dbProcess.getId());
                    rows = this.processDao.updateById(his);
                } else {
                    his.setProcessKey(processModel.getKey());
                    rows = this.processDao.updateByProcessKey(his, dbProcess.getTenantId(), dbProcess.getProcessKey());
                }
                Assert.isFalse(rows, "Set as historical process failed");
                processVersion = dbProcess.nextProcessVersion();
            }
            FlwProcess process = FlwProcess.of(flowCreator, processModel, processVersion, jsonString);
            if (null != processSave) {
                processSave.accept(process);
            }
            Assert.isFalse(this.processDao.insert(process), "Failed to save the deployment process");
            return process.getId();
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw Assert.throwable(e);
        }
    }

    @Override
    public boolean undeploy(Long id) {
        FlwProcess process = new FlwProcess();
        process.setId(id);
        process.setFlowState(FlowState.inactive);
        return this.processDao.updateById(process);
    }

    @Override
    public void cascadeRemove(Long id) {
        this.runtimeService.cascadeRemoveByProcessId(id);
        this.processDao.deleteById(id);
    }
}

