/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.bpm.engine.impl;

import com.aizuda.bpm.engine.QueryService;
import com.aizuda.bpm.engine.dao.FlwExtInstanceDao;
import com.aizuda.bpm.engine.dao.FlwHisInstanceDao;
import com.aizuda.bpm.engine.dao.FlwHisTaskActorDao;
import com.aizuda.bpm.engine.dao.FlwHisTaskDao;
import com.aizuda.bpm.engine.dao.FlwInstanceDao;
import com.aizuda.bpm.engine.dao.FlwTaskActorDao;
import com.aizuda.bpm.engine.dao.FlwTaskDao;
import com.aizuda.bpm.engine.entity.FlwExtInstance;
import com.aizuda.bpm.engine.entity.FlwHisInstance;
import com.aizuda.bpm.engine.entity.FlwHisTask;
import com.aizuda.bpm.engine.entity.FlwHisTaskActor;
import com.aizuda.bpm.engine.entity.FlwInstance;
import com.aizuda.bpm.engine.entity.FlwTask;
import com.aizuda.bpm.engine.entity.FlwTaskActor;
import java.util.List;
import java.util.Optional;

public class QueryServiceImpl
implements QueryService {
    private final FlwInstanceDao instanceDao;
    private final FlwHisInstanceDao hisInstanceDao;
    private final FlwExtInstanceDao extInstanceDao;
    private final FlwTaskDao taskDao;
    private final FlwTaskActorDao taskActorDao;
    private final FlwHisTaskDao hisTaskDao;
    private final FlwHisTaskActorDao hisTaskActorDao;

    public QueryServiceImpl(FlwInstanceDao instanceDao, FlwHisInstanceDao hisInstanceDao, FlwExtInstanceDao extInstanceDao, FlwTaskDao taskDao, FlwTaskActorDao taskActorDao, FlwHisTaskDao hisTaskDao, FlwHisTaskActorDao hisTaskActorDao) {
        this.instanceDao = instanceDao;
        this.hisInstanceDao = hisInstanceDao;
        this.extInstanceDao = extInstanceDao;
        this.taskDao = taskDao;
        this.taskActorDao = taskActorDao;
        this.hisTaskDao = hisTaskDao;
        this.hisTaskActorDao = hisTaskActorDao;
    }

    @Override
    public FlwInstance getInstance(Long instanceId) {
        return this.instanceDao.selectById(instanceId);
    }

    @Override
    public FlwTask getTask(Long taskId) {
        return this.taskDao.selectById(taskId);
    }

    @Override
    public FlwHisInstance getHistInstance(Long instanceId) {
        return this.hisInstanceDao.selectById(instanceId);
    }

    @Override
    public FlwExtInstance getExtInstance(Long instanceId) {
        return this.extInstanceDao.selectById(instanceId);
    }

    @Override
    public boolean existActiveSubProcess(Long instanceId) {
        return this.instanceDao.selectCountByParentInstanceId(instanceId) > 0L;
    }

    @Override
    public boolean existActiveTask(Long instanceId) {
        return this.taskDao.selectCountByInstanceId(instanceId) > 0L;
    }

    @Override
    public FlwHisTask getHistTask(Long taskId) {
        return this.hisTaskDao.selectById(taskId);
    }

    @Override
    public Optional<List<FlwHisTask>> getHisTasksByName(Long instanceId, String taskName) {
        return Optional.ofNullable(this.hisTaskDao.selectListByInstanceIdAndTaskName(instanceId, taskName));
    }

    @Override
    public List<FlwTask> getTasksByInstanceId(Long instanceId) {
        return this.taskDao.selectListByInstanceId(instanceId);
    }

    @Override
    public List<FlwTask> getTasksByInstanceIdAndTaskName(Long instanceId, String taskName) {
        return this.taskDao.selectListByInstanceIdAndTaskName(instanceId, taskName);
    }

    @Override
    public List<FlwTask> getTasksByInstanceIdAndTaskKey(Long instanceId, String taskKey) {
        return this.taskDao.selectListByInstanceIdAndTaskKey(instanceId, taskKey);
    }

    @Override
    public Optional<List<FlwTaskActor>> getActiveTaskActorsByInstanceId(Long instanceId) {
        return Optional.ofNullable(this.taskActorDao.selectListByInstanceId(instanceId));
    }

    @Override
    public List<FlwTaskActor> getTaskActorsByTaskId(Long taskId) {
        return this.taskActorDao.selectListByTaskId(taskId);
    }

    @Override
    public List<FlwTaskActor> getTaskActorsByTaskIdAndActorId(Long taskId, String actorId) {
        return this.taskActorDao.selectListByTaskIdAndActorId(taskId, actorId);
    }

    @Override
    public List<FlwHisTaskActor> getHisTaskActorsByTaskId(Long taskId) {
        return this.hisTaskActorDao.selectListByTaskId(taskId);
    }

    @Override
    public List<FlwHisTaskActor> getHisTaskActorsByTaskIdAndActorId(Long taskId, String actorId) {
        return this.hisTaskActorDao.selectListByTaskIdAndActorId(taskId, actorId);
    }

    @Override
    public List<FlwTask> getActiveTasks(Long instanceId, List<String> taskNames) {
        return this.taskDao.selectListByInstanceIdAndTaskNames(instanceId, taskNames);
    }

    @Override
    public Optional<List<FlwHisTask>> getHisTasksByInstanceId(Long instanceId) {
        return this.hisTaskDao.selectListByInstanceId(instanceId);
    }

    @Override
    public Optional<List<FlwInstance>> getSubProcessByInstanceId(Long instanceId) {
        return this.instanceDao.selectListByParentInstanceId(instanceId);
    }

    @Override
    public Optional<List<FlwInstance>> getInstancesByBusinessKey(String businessKey) {
        return this.instanceDao.selectListByBusinessKey(businessKey);
    }

    @Override
    public Optional<List<FlwHisInstance>> getHisInstancesByBusinessKey(String businessKey) {
        return this.hisInstanceDao.selectListByBusinessKey(businessKey);
    }
}

