/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.bpm.engine.impl;

import com.aizuda.bpm.engine.QueryService;
import com.aizuda.bpm.engine.RuntimeService;
import com.aizuda.bpm.engine.TaskService;
import com.aizuda.bpm.engine.assist.Assert;
import com.aizuda.bpm.engine.assist.DateUtils;
import com.aizuda.bpm.engine.core.Execution;
import com.aizuda.bpm.engine.core.FlowCreator;
import com.aizuda.bpm.engine.core.FlowLongContext;
import com.aizuda.bpm.engine.core.enums.InstanceEventType;
import com.aizuda.bpm.engine.core.enums.InstanceState;
import com.aizuda.bpm.engine.core.enums.TaskEventType;
import com.aizuda.bpm.engine.core.enums.TaskType;
import com.aizuda.bpm.engine.dao.FlwExtInstanceDao;
import com.aizuda.bpm.engine.dao.FlwHisInstanceDao;
import com.aizuda.bpm.engine.dao.FlwInstanceDao;
import com.aizuda.bpm.engine.entity.FlowEntity;
import com.aizuda.bpm.engine.entity.FlwExtInstance;
import com.aizuda.bpm.engine.entity.FlwHisInstance;
import com.aizuda.bpm.engine.entity.FlwInstance;
import com.aizuda.bpm.engine.entity.FlwProcess;
import com.aizuda.bpm.engine.entity.FlwTask;
import com.aizuda.bpm.engine.listener.InstanceListener;
import com.aizuda.bpm.engine.model.ConditionNode;
import com.aizuda.bpm.engine.model.ModelHelper;
import com.aizuda.bpm.engine.model.NodeModel;
import com.aizuda.bpm.engine.model.ProcessModel;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class RuntimeServiceImpl
implements RuntimeService {
    private final InstanceListener instanceListener;
    private final QueryService queryService;
    private final TaskService taskService;
    private final FlwInstanceDao instanceDao;
    private final FlwHisInstanceDao hisInstanceDao;
    private final FlwExtInstanceDao extInstanceDao;

    public RuntimeServiceImpl(InstanceListener instanceListener, QueryService queryService, TaskService taskService, FlwInstanceDao instanceDao, FlwHisInstanceDao hisInstanceDao, FlwExtInstanceDao extInstanceDao) {
        this.instanceListener = instanceListener;
        this.queryService = queryService;
        this.taskService = taskService;
        this.instanceDao = instanceDao;
        this.hisInstanceDao = hisInstanceDao;
        this.extInstanceDao = extInstanceDao;
    }

    @Override
    public FlwInstance createInstance(FlwProcess flwProcess, FlowCreator flowCreator, Map<String, Object> args, NodeModel nodeModel, Supplier<FlwInstance> supplier) {
        FlwInstance flwInstance = null;
        if (null != supplier) {
            flwInstance = supplier.get();
        }
        if (null == flwInstance) {
            flwInstance = new FlwInstance();
        }
        flwInstance.setCreateTime(DateUtils.getCurrentDate());
        flwInstance.setFlowCreator(flowCreator);
        flwInstance.setCurrentNodeName(nodeModel.getNodeName());
        flwInstance.setCurrentNodeKey(nodeModel.getNodeKey());
        flwInstance.setLastUpdateBy(flwInstance.getCreateBy());
        flwInstance.setLastUpdateTime(flwInstance.getCreateTime());
        flwInstance.setProcessId(flwProcess.getId());
        flwInstance.setMapVariable(args);
        ModelHelper.reloadProcessModel(flwProcess.model(), t -> flwProcess.setModelContent2Json(t.cleanParentNode()));
        this.saveInstance(flwInstance, flwProcess, flowCreator);
        return flwInstance;
    }

    @Override
    public ProcessModel getProcessModelByInstanceId(Long instanceId) {
        return FlwExtInstance.cacheProcessModelById(instanceId, () -> {
            FlwExtInstance fri = this.extInstanceDao.selectById(instanceId);
            Assert.isNull(fri, "The process instance model does not exist.");
            return fri.model(true);
        });
    }

    @Override
    public boolean addVariable(Long instanceId, Map<String, Object> args, Function<FlwInstance, FlwInstance> function) {
        FlwInstance flwInstance = this.instanceDao.selectById(instanceId);
        Assert.isNull(flwInstance, "not found instance");
        FlwInstance fi = function.apply(flwInstance);
        fi.setId(instanceId);
        Map<String, Object> data = flwInstance.variableToMap();
        data.putAll(args);
        fi.setMapVariable(data);
        return this.instanceDao.updateById(fi);
    }

    @Override
    public boolean endInstance(Execution execution, Long instanceId, NodeModel endNode) {
        FlwInstance flwInstance = this.instanceDao.selectById(instanceId);
        if (null != flwInstance) {
            this.instanceDao.deleteById(instanceId);
            this.hisInstanceDao.updateById(this.getFlwHisInstance(instanceId, endNode, flwInstance));
            this.instanceNotify(InstanceEventType.end, () -> this.hisInstanceDao.selectById(instanceId), execution.getFlowCreator());
            if (null != flwInstance.getParentInstanceId()) {
                this.taskService.endCallProcessTask(flwInstance.getProcessId(), flwInstance.getId());
                FlwInstance parentFlwInstance = this.instanceDao.selectById(flwInstance.getParentInstanceId());
                execution.setFlwInstance(parentFlwInstance);
                String currentNodeKey = flwInstance.getBusinessKey();
                if (null == currentNodeKey) {
                    currentNodeKey = parentFlwInstance.getCurrentNodeKey();
                }
                execution.restartProcessInstance(parentFlwInstance.getProcessId(), currentNodeKey);
            }
        }
        return true;
    }

    protected FlwHisInstance getFlwHisInstance(Long instanceId, NodeModel endNode, FlwInstance flwInstance) {
        FlwHisInstance his = new FlwHisInstance();
        his.setId(instanceId);
        InstanceState instanceState = InstanceState.complete;
        his.setInstanceState(instanceState);
        String currentNodeName = instanceState.name();
        String currentNodeKey = instanceState.name();
        if (null != endNode) {
            NodeModel childNode = endNode.getChildNode();
            if (null == childNode || TaskType.end.ne(childNode.getType())) {
                childNode = endNode;
            }
            currentNodeName = childNode.getNodeName();
            currentNodeKey = childNode.getNodeKey();
        }
        his.setCurrentNodeName(currentNodeName);
        his.setCurrentNodeKey(currentNodeKey);
        his.setCreateTime(flwInstance.getCreateTime());
        his.setLastUpdateBy(flwInstance.getLastUpdateBy());
        his.setLastUpdateTime(flwInstance.getLastUpdateTime());
        his.calculateDuration();
        return his;
    }

    protected void instanceNotify(InstanceEventType eventType, Supplier<FlwHisInstance> supplier, FlowCreator flowCreator) {
        if (null != this.instanceListener) {
            this.instanceListener.notify(eventType, supplier, null, flowCreator);
        }
    }

    @Override
    public void saveInstance(FlwInstance flwInstance, FlwProcess flwProcess, FlowCreator flowCreator) {
        this.instanceDao.insert(flwInstance);
        FlwHisInstance flwHisInstance = FlwHisInstance.of(flwInstance, InstanceState.active);
        this.hisInstanceDao.insert(flwHisInstance);
        this.extInstanceDao.insert(FlwExtInstance.of(flwInstance, flwProcess));
        this.instanceNotify(InstanceEventType.start, () -> flwHisInstance, flowCreator);
    }

    @Override
    public boolean reject(Long instanceId, FlowCreator flowCreator) {
        return this.forceComplete(instanceId, flowCreator, InstanceState.reject, TaskEventType.reject);
    }

    @Override
    public boolean revoke(Long instanceId, FlowCreator flowCreator) {
        return this.forceComplete(instanceId, flowCreator, InstanceState.revoke, TaskEventType.revoke);
    }

    @Override
    public boolean timeout(Long instanceId, FlowCreator flowCreator) {
        return this.forceComplete(instanceId, flowCreator, InstanceState.timeout, TaskEventType.timeout);
    }

    @Override
    public boolean terminate(Long instanceId, FlowCreator flowCreator) {
        return this.forceComplete(instanceId, flowCreator, InstanceState.terminate, TaskEventType.terminate);
    }

    protected boolean forceComplete(Long instanceId, FlowCreator flowCreator, InstanceState instanceState, TaskEventType eventType) {
        FlwInstance flwInstance = this.instanceDao.selectById(instanceId);
        if (null == flwInstance) {
            return false;
        }
        Long parentInstanceId = flwInstance.getParentInstanceId();
        if (null != parentInstanceId) {
            this.forceComplete(parentInstanceId, flowCreator, instanceState, eventType);
        } else {
            this.instanceDao.selectListByParentInstanceId(flwInstance.getId()).ifPresent(f -> f.forEach(t -> this.forceCompleteAll((FlwInstance)t, flowCreator, instanceState, eventType)));
        }
        this.forceCompleteAll(flwInstance, flowCreator, instanceState, eventType);
        return true;
    }

    protected void forceCompleteAll(FlwInstance flwInstance, FlowCreator flowCreator, InstanceState instanceState, TaskEventType eventType) {
        this.taskService.forceCompleteAllTask(flwInstance.getId(), flowCreator, instanceState, eventType);
        FlwHisInstance flwHisInstance = FlwHisInstance.of(flwInstance, instanceState);
        this.hisInstanceDao.updateById(flwHisInstance);
        this.instanceDao.deleteById(flwInstance.getId());
        this.instanceNotify(InstanceEventType.forceComplete, () -> flwHisInstance, flowCreator);
    }

    @Override
    public void updateInstance(FlwInstance flwInstance) {
        Assert.illegal(null == flwInstance || null == flwInstance.getId(), "instance id cannot be empty");
        this.instanceDao.updateById(flwInstance);
    }

    @Override
    public boolean updateInstanceModelById(Long instanceId, ProcessModel processModel) {
        FlowLongContext.invalidateProcessModel("flwProcessInstanceModel#" + instanceId);
        FlwExtInstance extInstance = new FlwExtInstance();
        extInstance.setId(instanceId);
        extInstance.setModelContent(FlowLongContext.toJson(processModel.cleanParentNode()));
        return this.extInstanceDao.updateById(extInstance);
    }

    @Override
    public void cascadeRemoveByProcessId(Long processId) {
        this.hisInstanceDao.selectListByProcessId(processId).ifPresent(hisInstances -> {
            this.taskService.cascadeRemoveByInstanceIds(hisInstances.stream().map(FlowEntity::getId).collect(Collectors.toList()));
            this.extInstanceDao.deleteByProcessId(processId);
            this.hisInstanceDao.deleteByProcessId(processId);
            this.instanceDao.deleteByProcessId(processId);
        });
    }

    @Override
    public void cascadeRemoveByInstanceId(Long instanceId) {
        if (this.taskService.cascadeRemoveByInstanceIds(Collections.singletonList(instanceId))) {
            this.extInstanceDao.deleteById(instanceId);
            this.hisInstanceDao.deleteById(instanceId);
            this.instanceDao.deleteById(instanceId);
        }
    }

    @Override
    public void appendNodeModel(Long taskId, NodeModel nodeModel, boolean beforeAfter) {
        FlwTask flwTask = this.queryService.getTask(taskId);
        FlwExtInstance flwExtInstance = this.extInstanceDao.selectById(flwTask.getInstanceId());
        String appendTaskKey = flwTask.getTaskKey();
        ProcessModel processModel = flwExtInstance.model();
        NodeModel selectNode = processModel.getNode(appendTaskKey);
        if (beforeAfter) {
            selectNode = selectNode.getParentNode();
        }
        if (null != selectNode.getConditionNodes()) {
            for (ConditionNode conditionNode : selectNode.getConditionNodes()) {
                NodeModel conditionChildNode = conditionNode.getChildNode();
                if (!Objects.equals(conditionChildNode.getNodeKey(), appendTaskKey)) continue;
                nodeModel.setChildNode(conditionChildNode);
                conditionNode.setChildNode(nodeModel);
                break;
            }
        } else {
            nodeModel.setChildNode(selectNode.getChildNode());
            selectNode.setChildNode(nodeModel);
        }
        FlwExtInstance temp = new FlwExtInstance();
        temp.setId(flwExtInstance.getId());
        temp.setModelContent(FlowLongContext.toJson(processModel.cleanParentNode()));
        Assert.isFalse(this.extInstanceDao.updateById(temp), "Update FlwExtInstance Failed");
        FlowLongContext.invalidateProcessModel(flwExtInstance.modelCacheKey());
    }
}

