/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.bpm.engine.impl;

import com.aizuda.bpm.engine.ProcessService;
import com.aizuda.bpm.engine.TaskAccessStrategy;
import com.aizuda.bpm.engine.TaskService;
import com.aizuda.bpm.engine.TaskTrigger;
import com.aizuda.bpm.engine.assist.Assert;
import com.aizuda.bpm.engine.assist.DateUtils;
import com.aizuda.bpm.engine.assist.ObjectUtils;
import com.aizuda.bpm.engine.core.Execution;
import com.aizuda.bpm.engine.core.FlowCreator;
import com.aizuda.bpm.engine.core.enums.AgentType;
import com.aizuda.bpm.engine.core.enums.InstanceState;
import com.aizuda.bpm.engine.core.enums.PerformType;
import com.aizuda.bpm.engine.core.enums.TaskEventType;
import com.aizuda.bpm.engine.core.enums.TaskState;
import com.aizuda.bpm.engine.core.enums.TaskType;
import com.aizuda.bpm.engine.dao.FlwExtInstanceDao;
import com.aizuda.bpm.engine.dao.FlwHisInstanceDao;
import com.aizuda.bpm.engine.dao.FlwHisTaskActorDao;
import com.aizuda.bpm.engine.dao.FlwHisTaskDao;
import com.aizuda.bpm.engine.dao.FlwInstanceDao;
import com.aizuda.bpm.engine.dao.FlwTaskActorDao;
import com.aizuda.bpm.engine.dao.FlwTaskDao;
import com.aizuda.bpm.engine.entity.FlowEntity;
import com.aizuda.bpm.engine.entity.FlwExtInstance;
import com.aizuda.bpm.engine.entity.FlwHisInstance;
import com.aizuda.bpm.engine.entity.FlwHisTask;
import com.aizuda.bpm.engine.entity.FlwHisTaskActor;
import com.aizuda.bpm.engine.entity.FlwInstance;
import com.aizuda.bpm.engine.entity.FlwProcess;
import com.aizuda.bpm.engine.entity.FlwTask;
import com.aizuda.bpm.engine.entity.FlwTaskActor;
import com.aizuda.bpm.engine.listener.TaskListener;
import com.aizuda.bpm.engine.model.ModelHelper;
import com.aizuda.bpm.engine.model.NodeAssignee;
import com.aizuda.bpm.engine.model.NodeModel;
import com.aizuda.bpm.engine.model.ProcessModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class TaskServiceImpl
implements TaskService {
    private final TaskAccessStrategy taskAccessStrategy;
    private final TaskTrigger taskTrigger;
    private final TaskListener taskListener;
    private final FlwInstanceDao instanceDao;
    private final FlwExtInstanceDao extInstanceDao;
    private final FlwHisInstanceDao hisInstanceDao;
    private final FlwTaskDao taskDao;
    private final FlwTaskActorDao taskActorDao;
    private final FlwHisTaskDao hisTaskDao;
    private final FlwHisTaskActorDao hisTaskActorDao;

    public TaskServiceImpl(TaskAccessStrategy taskAccessStrategy, TaskListener taskListener, TaskTrigger taskTrigger, FlwInstanceDao instanceDao, FlwExtInstanceDao extInstanceDao, FlwHisInstanceDao hisInstanceDao, FlwTaskDao taskDao, FlwTaskActorDao taskActorDao, FlwHisTaskDao hisTaskDao, FlwHisTaskActorDao hisTaskActorDao) {
        this.taskAccessStrategy = taskAccessStrategy;
        this.taskTrigger = taskTrigger;
        this.taskListener = taskListener;
        this.instanceDao = instanceDao;
        this.extInstanceDao = extInstanceDao;
        this.hisInstanceDao = hisInstanceDao;
        this.taskDao = taskDao;
        this.taskActorDao = taskActorDao;
        this.hisTaskDao = hisTaskDao;
        this.hisTaskActorDao = hisTaskActorDao;
    }

    protected void updateCurrentNode(FlwTask flwTask) {
        FlwInstance flwInstance = new FlwInstance();
        flwInstance.setId(flwTask.getInstanceId());
        flwInstance.setCurrentNodeName(flwTask.getTaskName());
        flwInstance.setCurrentNodeKey(flwTask.getTaskKey());
        flwInstance.setLastUpdateBy(flwTask.getCreateBy());
        flwInstance.setLastUpdateTime(DateUtils.getCurrentDate());
        this.instanceDao.updateById(flwInstance);
        FlwHisInstance flwHisInstance = new FlwHisInstance();
        flwHisInstance.setId(flwInstance.getId());
        flwHisInstance.setCurrentNodeName(flwInstance.getCurrentNodeName());
        flwHisInstance.setCurrentNodeKey(flwInstance.getCurrentNodeKey());
        flwHisInstance.setLastUpdateBy(flwInstance.getLastUpdateBy());
        flwHisInstance.setLastUpdateTime(flwInstance.getLastUpdateTime());
        this.hisInstanceDao.updateById(flwHisInstance);
    }

    @Override
    public FlwTask executeTask(Long taskId, FlowCreator flowCreator, Map<String, Object> args, TaskState taskState, TaskEventType eventType) {
        FlwTask flwTask = this.getAllowedFlwTask(taskId, flowCreator, args, taskState);
        if (PerformType.trigger.eq(flwTask.getPerformType())) {
            this.taskDao.deleteById(flwTask.getId());
            return flwTask;
        }
        this.moveToHisTask(flwTask, taskState, flowCreator);
        this.taskNotify(eventType, () -> flwTask, null, flowCreator);
        return flwTask;
    }

    @Override
    public boolean forceCompleteAllTask(Long instanceId, FlowCreator flowCreator, InstanceState instanceState, TaskEventType eventType) {
        List<FlwTask> flwTasks = this.taskDao.selectListByInstanceId(instanceId);
        if (null != flwTasks) {
            TaskState taskState = TaskState.of(instanceState);
            flwTasks.forEach(t -> {
                this.moveToHisTask((FlwTask)t, taskState, flowCreator);
                this.taskNotify(eventType, () -> t, null, flowCreator);
            });
        }
        return true;
    }

    @Override
    public Optional<FlwTask> executeJumpTask(Long taskId, String nodeKey, FlowCreator flowCreator, Map<String, Object> args, Function<FlwTask, Execution> executionFunction, TaskType taskTye) {
        FlwTask flwTask = null;
        TaskEventType taskEventType = null;
        if (taskTye == TaskType.jump) {
            taskEventType = TaskEventType.jump;
        } else if (taskTye == TaskType.rejectJump) {
            taskEventType = TaskEventType.rejectJump;
        } else if (taskTye == TaskType.reApproveJump) {
            taskEventType = TaskEventType.reApproveJump;
        } else if (taskTye == TaskType.routeJump) {
            taskEventType = TaskEventType.routeJump;
            flwTask = this.hisTaskDao.selectCheckById(taskId);
        }
        Assert.illegal(null == taskEventType, "taskTye only allow jump and rejectJump");
        if (null == flwTask) {
            flwTask = this.getAllowedFlwTask(taskId, flowCreator, null, null);
        }
        Execution execution = executionFunction.apply(flwTask);
        ProcessModel processModel = execution.getProcessModel();
        Assert.isNull(processModel, "\u5f53\u524d\u4efb\u52a1\u672a\u627e\u5230\u6d41\u7a0b\u5b9a\u4e49\u6a21\u578b");
        execution.setArgs(args);
        NodeModel nodeModel = null == nodeKey ? processModel.getNode(flwTask.getTaskKey()).parentApprovalNode() : processModel.getNode(nodeKey);
        Assert.isNull(nodeModel, "\u6839\u636e\u8282\u70b9key[" + nodeKey + "]\u65e0\u6cd5\u627e\u5230\u8282\u70b9\u6a21\u578b");
        TaskType taskType = TaskType.get(nodeModel.getType());
        Assert.illegal(TaskType.major != taskType && TaskType.approval != taskType, "not allow jumping nodes");
        List<NodeModel> allChildNodes = ModelHelper.getRootNodeAllChildNodes(nodeModel);
        this.taskDao.selectListByInstanceId(flwTask.getInstanceId()).forEach(t -> {
            if (allChildNodes.stream().anyMatch(n -> Objects.equals(n.getNodeKey(), t.getTaskKey()))) {
                this.moveToHisTask((FlwTask)t, TaskState.jump, flowCreator);
            }
        });
        FlwTask createTask = this.createTaskBase(nodeModel, execution);
        createTask.taskType(taskTye);
        if (TaskType.major == taskType) {
            createTask.setPerformType(PerformType.start);
            Assert.isFalse(this.taskDao.insert(createTask), "failed to create initiation task");
            this.taskActorDao.insert(FlwTaskActor.ofFlwInstance(execution.getFlwInstance(), createTask.getId()));
        } else {
            List<FlwTaskActor> taskActors = execution.getTaskActorProvider().getTaskActors(nodeModel, execution);
            PerformType performType = PerformType.get(nodeModel.getExamineMode());
            this.saveTask(createTask, performType, taskActors, execution, nodeModel);
        }
        this.taskNotify(taskEventType, execution::getFlwTask, nodeModel, flowCreator);
        return Optional.of(createTask);
    }

    protected FlwTask getAllowedFlwTask(Long taskId, FlowCreator flowCreator, Map<String, Object> args, TaskState taskState) {
        FlwTask flwTask = this.taskDao.selectCheckById(taskId);
        if (null != args) {
            flwTask.setVariable(args);
        }
        if (null == taskState || TaskState.allowedCheck(taskState)) {
            Assert.isNull(this.isAllowed(flwTask, flowCreator.getCreateId()), "\u5f53\u524d\u53c2\u4e0e\u8005 [" + flowCreator.getCreateBy() + "]\u4e0d\u5141\u8bb8\u6267\u884c\u4efb\u52a1[taskId=" + taskId + "]");
        }
        return flwTask;
    }

    protected boolean moveToHisTask(FlwTask flwTask, TaskState taskState, FlowCreator flowCreator) {
        List<FlwTaskActor> taskActors = this.taskActorDao.selectListByTaskId(flwTask.getId());
        if (taskState != TaskState.autoComplete && taskState != TaskState.autoReject && taskState != TaskState.autoJump && ObjectUtils.isEmpty(taskActors)) {
            return true;
        }
        FlwHisTask hisTask = FlwHisTask.of(flwTask);
        hisTask.setTaskState(taskState);
        hisTask.setFlowCreator(flowCreator);
        hisTask.calculateDuration();
        if (TaskType.agent.eq(flwTask.getTaskType())) {
            FlwTaskActor agentFlwTaskActor = taskActors.stream().filter(t -> t.agentActor() && t.eqActorId(flowCreator.getCreateId())).findFirst().orElse(null);
            if (null != agentFlwTaskActor) {
                hisTask.taskType(TaskType.agentAssist);
                taskActors.stream().filter(t -> Objects.equals(agentFlwTaskActor.getAgentId(), t.getActorId())).findFirst().ifPresent(t -> {
                    hisTask.setAssignorId(t.getActorId());
                    hisTask.setAssignor(t.getActorName());
                    FlwTaskActor flwTaskActor = FlwTaskActor.ofAgentIt(flowCreator);
                    flwTaskActor.setId(t.getId());
                    this.taskActorDao.updateById(flwTaskActor);
                });
                this.hisTaskDao.insert(hisTask);
                this.hisTaskActorDao.insert(FlwHisTaskActor.of(agentFlwTaskActor));
                this.taskActorDao.deleteByTaskIdAndAgentType(flwTask.getId(), 0);
                FlwTask newFlwTask = new FlwTask();
                newFlwTask.setId(flwTask.getId());
                newFlwTask.taskType(TaskType.agentReturn);
                newFlwTask.setAssignorId(flowCreator.getCreateId());
                newFlwTask.setAssignor(flowCreator.getCreateBy());
                return this.taskDao.updateById(newFlwTask);
            }
            ArrayList<FlwTaskActor> newFlwTaskActor = new ArrayList<FlwTaskActor>();
            for (FlwTaskActor taskActor : taskActors) {
                if (taskActor.agentActor()) {
                    this.taskActorDao.deleteById(taskActor.getId());
                    continue;
                }
                newFlwTaskActor.add(taskActor);
            }
            taskActors = newFlwTaskActor;
            flwTask.taskType(TaskType.agentOwn);
        } else if (TaskType.agentReturn.eq(flwTask.getTaskType())) {
            this.hisTaskActorDao.deleteByTaskId(flwTask.getId());
            this.hisTaskDao.deleteById(flwTask.getId());
            hisTask.taskType(TaskType.agentAssist);
        }
        if (PerformType.countersign.eq(flwTask.getPerformType()) && TaskState.complete.ne(taskState.getValue()) && TaskState.autoJump.ne(taskState.getValue())) {
            List<FlwTask> flwTaskList = this.taskDao.selectListByParentTaskId(flwTask.getParentTaskId());
            flwTaskList.forEach(t -> {
                FlwHisTask ht = FlwHisTask.of(t);
                ht.setTaskState(taskState);
                ht.setFlowCreator(flowCreator);
                ht.calculateDuration();
                ht.setTaskType(hisTask.getTaskType());
                this.hisTaskDao.insert(ht);
            });
            List<Long> taskIds = flwTaskList.stream().map(FlowEntity::getId).collect(Collectors.toList());
            this.moveToHisTaskActor(this.taskActorDao.selectListByTaskIds(taskIds));
            return this.taskDao.deleteByIds(taskIds);
        }
        if (PerformType.orSign.eq(flwTask.getPerformType())) {
            taskActors.stream().filter(t -> Objects.equals(flowCreator.getCreateId(), t.getActorId())).findFirst().ifPresent(t -> t.setWeight(1));
        }
        Assert.isFalse(this.hisTaskDao.insert(hisTask), "Migration to FlwHisTask table failed");
        this.moveToHisTaskActor(taskActors);
        return this.taskDao.deleteById(flwTask.getId());
    }

    protected void moveToHisTaskActor(List<FlwTaskActor> taskActors) {
        if (null != taskActors) {
            taskActors.forEach(t -> {
                this.hisTaskActorDao.insert(FlwHisTaskActor.of(t));
                this.taskActorDao.deleteById(t.getId());
            });
        }
    }

    protected void taskNotify(TaskEventType eventType, Supplier<FlwTask> supplier, NodeModel nodeModel, FlowCreator flowCreator) {
        if (null != this.taskListener) {
            this.taskListener.notify(eventType, supplier, nodeModel, flowCreator);
        }
    }

    @Override
    public boolean executeTaskTrigger(Execution execution, FlwTask flwTask) {
        NodeModel nodeModel = execution.getProcessModel().getNode(flwTask.getTaskKey());
        nodeModel.executeTrigger(execution, e -> {
            TaskTrigger taskTrigger = execution.getEngine().getContext().getTaskTrigger();
            if (null == taskTrigger) {
                return false;
            }
            return taskTrigger.execute(nodeModel, execution);
        });
        this.taskNotify(TaskEventType.trigger, () -> flwTask, nodeModel, execution.getFlowCreator());
        nodeModel.nextNode().ifPresent(nextNode -> nextNode.execute(execution.getEngine().getContext(), execution));
        return true;
    }

    @Override
    public boolean completeActiveTasksByInstanceId(Long instanceId, FlowCreator flowCreator) {
        List<FlwTask> flwTasks = this.taskDao.selectListByInstanceId(instanceId);
        if (ObjectUtils.isNotEmpty(flwTasks)) {
            for (FlwTask flwTask : flwTasks) {
                if (this.moveToHisTask(flwTask, TaskState.terminate, flowCreator)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void updateTaskById(FlwTask flwTask, FlowCreator flowCreator) {
        this.taskDao.updateById(flwTask);
        this.taskNotify(TaskEventType.update, () -> flwTask, null, flowCreator);
    }

    @Override
    public boolean viewTask(Long taskId, FlwTaskActor taskActor) {
        if (this.taskActorDao.selectCountByTaskIdAndActorId(taskId, taskActor.getActorId()) > 0L) {
            FlwTask flwTask = new FlwTask();
            flwTask.setId(taskId);
            flwTask.setViewed(1);
            return this.taskDao.updateById(flwTask);
        }
        return false;
    }

    @Override
    public FlwTask claimRole(Long taskId, FlowCreator flowCreator) {
        return this.claim(taskId, AgentType.claimRole, TaskEventType.claimRole, flowCreator);
    }

    @Override
    public FlwTask claimDepartment(Long taskId, FlowCreator flowCreator) {
        return this.claim(taskId, AgentType.claimDepartment, TaskEventType.claimDepartment, flowCreator);
    }

    protected FlwTask claim(Long taskId, AgentType agentType, TaskEventType eventType, FlowCreator flowCreator) {
        FlwTask flwTask = this.taskDao.selectCheckById(taskId);
        FlwTaskActor taskActor = this.isAllowed(flwTask, flowCreator.getCreateId());
        if (null == taskActor) {
            Assert.illegal("\u5f53\u524d\u6267\u884c\u7528\u6237ID [" + flowCreator.getCreateBy() + "] \u4e0d\u5141\u8bb8\u8ba4\u9886\u4efb\u52a1 [taskId=" + taskId + "]");
        }
        this.taskActorDao.deleteById(taskActor.getId());
        this.taskActorDao.insert(FlwTaskActor.ofAgent(agentType, flowCreator, flwTask, taskActor));
        this.taskNotify(eventType, () -> flwTask, null, flowCreator);
        return flwTask;
    }

    @Override
    public boolean transferTask(FlowCreator flowCreator, FlowCreator assigneeFlowCreator) {
        List<FlwTaskActor> flwTaskActors = this.taskActorDao.selectListByActorId(flowCreator.getCreateId());
        if (ObjectUtils.isEmpty(flwTaskActors)) {
            return false;
        }
        for (FlwTaskActor flwTaskActor : flwTaskActors) {
            FlwTask ft = new FlwTask();
            ft.setId(flwTaskActor.getTaskId());
            ft.taskType(TaskType.transfer);
            ft.setAssignorId(flowCreator.getCreateId());
            ft.setAssignor(flowCreator.getCreateBy());
            if (!this.taskDao.updateById(ft)) continue;
            FlwHisTaskActor fta = new FlwHisTaskActor();
            fta.setId(flwTaskActor.getId());
            fta.setActorId(assigneeFlowCreator.getCreateId());
            fta.setActorName(assigneeFlowCreator.getCreateBy());
            this.taskActorDao.updateById(fta);
        }
        return true;
    }

    @Override
    public boolean assigneeTask(Long taskId, TaskType taskType, FlowCreator flowCreator, List<FlowCreator> assigneeFlowCreators, Function<FlwTask, Boolean> check) {
        FlwTaskActor flwTaskActor = this.getAllowedFlwTaskActor(taskId, flowCreator);
        FlwTask dbFlwTask = this.taskDao.selectById(taskId);
        if (null != check && !check.apply(dbFlwTask).booleanValue()) {
            return false;
        }
        FlwTask flwTask = new FlwTask();
        flwTask.setId(taskId);
        flwTask.taskType(taskType);
        if (taskType == TaskType.agent) {
            FlowCreator afc = assigneeFlowCreators.get(0);
            flwTask.setAssignorId(afc.getCreateId());
            flwTask.setAssignor(assigneeFlowCreators.stream().map(FlowCreator::getCreateBy).collect(Collectors.joining(", ")));
            assigneeFlowCreators.forEach(t -> this.taskActorDao.insert(FlwTaskActor.ofAgent(AgentType.agent, t, dbFlwTask, flwTaskActor)));
        } else {
            flwTask.setAssignorId(flowCreator.getCreateId());
            flwTask.setAssignor(flowCreator.getCreateBy());
            this.taskActorDao.deleteById(flwTaskActor.getId());
            FlowCreator afc = assigneeFlowCreators.get(0);
            this.assignTask(flwTaskActor.getInstanceId(), taskId, flwTaskActor.getActorType(), FlwTaskActor.ofFlowCreator(afc));
        }
        this.taskDao.updateById(flwTask);
        this.taskNotify(TaskEventType.assignment, () -> {
            dbFlwTask.taskType(taskType);
            dbFlwTask.setAssignorId(flwTask.getAssignorId());
            dbFlwTask.setAssignor(flwTask.getAssignor());
            return dbFlwTask;
        }, null, flowCreator);
        return true;
    }

    protected FlwTaskActor getAllowedFlwTaskActor(Long taskId, FlowCreator flowCreator) {
        List<FlwTaskActor> taskActors = this.taskActorDao.selectListByTaskIdAndActorId(taskId, flowCreator.getCreateId());
        return this.taskAccessStrategy.getAllowedFlwTaskActor(taskId, flowCreator, taskActors);
    }

    @Override
    public boolean resolveTask(Long taskId, FlowCreator flowCreator) {
        FlwTaskActor flwTaskActor = this.getAllowedFlwTaskActor(taskId, flowCreator);
        FlwTask flwTask = this.taskDao.selectCheckById(taskId);
        FlwHisTaskActor taskActor = new FlwHisTaskActor();
        taskActor.setId(flwTaskActor.getId());
        taskActor.setActorId(flwTask.getAssignorId());
        taskActor.setActorName(flwTask.getAssignor());
        if (this.taskActorDao.updateById(taskActor)) {
            FlwTask temp = new FlwTask();
            temp.setId(taskId);
            temp.taskType(TaskType.delegateReturn);
            temp.setAssignorId(flowCreator.getCreateId());
            temp.setAssignor(flowCreator.getCreateBy());
            Assert.isFalse(this.taskDao.updateById(temp), "resolveTask failed");
            this.taskNotify(TaskEventType.delegateResolve, () -> {
                flwTask.setTaskType(temp.getTaskType());
                flwTask.setAssignorId(temp.getCreateId());
                flwTask.setAssignor(temp.getCreateBy());
                return flwTask;
            }, null, flowCreator);
        }
        return true;
    }

    @Override
    public Optional<FlwTask> reclaimTask(Long taskId, FlowCreator flowCreator) {
        Optional<FlwTask> flwTaskOptional = this.undoHisTask(taskId, flowCreator, TaskType.reclaim, hisTask -> {
            boolean checkReclaim = true;
            if (PerformType.sort.eq(hisTask.getPerformType()) || PerformType.countersign.eq(hisTask.getPerformType())) {
                boolean bl = checkReclaim = this.taskDao.selectCountByParentTaskId(hisTask.getParentTaskId()) < 1L;
            }
            if (checkReclaim) {
                Assert.isTrue(this.taskDao.selectCountByParentTaskId(taskId) == 0L, "Do not allow reclaim task");
            }
            List<FlwTask> flwTaskList = this.taskDao.selectListByInstanceId(hisTask.getInstanceId());
            Assert.isEmpty(flwTaskList, "No approval tasks found");
            FlwTask existFlwTask = flwTaskList.get(0);
            if (!PerformType.countersign.eq(existFlwTask.getPerformType())) {
                Assert.isFalse(Objects.equals(existFlwTask.getParentTaskId(), taskId), "Do not allow cross level reclaim task");
            }
            flwTaskList.forEach(flwTask -> this.moveToHisTask((FlwTask)flwTask, TaskState.revoke, flowCreator));
        });
        flwTaskOptional.ifPresent(flwTask -> this.taskNotify(TaskEventType.reclaim, () -> flwTask, null, flowCreator));
        return flwTaskOptional;
    }

    @Override
    public FlwTask resume(Long taskId, FlowCreator flowCreator) {
        FlwHisInstance fhi;
        FlwHisTask histTask = this.hisTaskDao.selectCheckById(taskId);
        Assert.isTrue(ObjectUtils.isEmpty(histTask.getCreateBy()) || !Objects.equals(histTask.getCreateBy(), flowCreator.getCreateBy()), "\u5f53\u524d\u53c2\u4e0e\u8005[" + flowCreator.getCreateBy() + "]\u4e0d\u5141\u8bb8\u5524\u9192\u5386\u53f2\u4efb\u52a1[taskId=" + taskId + "]");
        Long instanceId = histTask.getInstanceId();
        FlwInstance flwInstance = this.instanceDao.selectById(instanceId);
        if (null == flwInstance && null != (fhi = this.hisInstanceDao.selectById(instanceId)) && this.instanceDao.insert(fhi.toFlwInstance())) {
            FlwHisInstance temp = new FlwHisInstance();
            temp.setId(instanceId);
            temp.setInstanceState(InstanceState.active);
            this.hisInstanceDao.updateById(temp);
        }
        FlwTask flwTask = histTask.cloneTask(null);
        this.taskDao.insert(flwTask);
        List<FlwHisTaskActor> hisTaskActors = this.hisTaskActorDao.selectListByTaskId(taskId);
        hisTaskActors.forEach(t -> this.taskActorDao.insert(FlwTaskActor.ofFlwHisTaskActor(flwTask.getId(), t)));
        this.updateCurrentNode(flwTask);
        this.taskNotify(TaskEventType.resume, () -> flwTask, null, flowCreator);
        return flwTask;
    }

    @Override
    public Optional<FlwTask> withdrawTask(Long taskId, FlowCreator flowCreator) {
        return this.undoHisTask(taskId, flowCreator, TaskType.withdraw, hisTask -> {
            List<FlwTask> flwTasks = null;
            PerformType performType = PerformType.get(hisTask.getPerformType());
            if (performType == PerformType.countersign) {
                flwTasks = this.taskDao.selectListByParentTaskId(hisTask.getId());
            } else {
                List<Long> hisTaskIds = this.hisTaskDao.selectListByInstanceIdAndTaskNameAndParentTaskId(hisTask.getInstanceId(), hisTask.getTaskName(), hisTask.getParentTaskId()).stream().map(FlowEntity::getId).collect(Collectors.toList());
                if (ObjectUtils.isNotEmpty(hisTaskIds)) {
                    flwTasks = this.taskDao.selectListByParentTaskIds(hisTaskIds);
                }
            }
            Assert.isEmpty(flwTasks, "\u540e\u7eed\u6d3b\u52a8\u4efb\u52a1\u5df2\u5b8c\u6210\u6216\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u64a4\u56de.");
            List<Long> taskIds = flwTasks.stream().map(FlowEntity::getId).collect(Collectors.toList());
            List<Long> taskActorIds = this.taskActorDao.selectListByTaskIds(taskIds).stream().map(FlwTaskActor::getId).collect(Collectors.toList());
            if (ObjectUtils.isNotEmpty(taskActorIds)) {
                this.taskActorDao.deleteByIds(taskActorIds);
            }
            this.taskDao.deleteByIds(flwTasks.stream().map(FlowEntity::getId).collect(Collectors.toList()));
            this.taskNotify(TaskEventType.withdraw, () -> hisTask, null, flowCreator);
        });
    }

    @Override
    public Optional<FlwTask> rejectTask(FlwTask currentFlwTask, FlowCreator flowCreator, Map<String, Object> args) {
        Assert.isTrue(currentFlwTask.startNode(), "\u4e0a\u4e00\u6b65\u4efb\u52a1ID\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u9a73\u56de\u81f3\u4e0a\u4e00\u6b65\u5904\u7406");
        this.executeTask(currentFlwTask.getId(), flowCreator, args, TaskState.reject, TaskEventType.reject);
        Long parentTaskId = currentFlwTask.getParentTaskId();
        Optional<FlwTask> flwTaskOptional = this.undoHisTask(parentTaskId, flowCreator, TaskType.reject, null);
        flwTaskOptional.ifPresent(flwTask -> this.taskNotify(TaskEventType.recreate, () -> flwTask, null, flowCreator));
        return flwTaskOptional;
    }

    protected Optional<FlwTask> undoHisTask(Long hisTaskId, FlowCreator flowCreator, TaskType taskType, Consumer<FlwHisTask> hisTaskConsumer) {
        FlwHisTask hisTask = this.hisTaskDao.selectCheckById(hisTaskId);
        if (null != hisTaskConsumer) {
            hisTaskConsumer.accept(hisTask);
        }
        if (hisTask.startNode()) {
            FlwTask flwTask = hisTask.undoTask(taskType);
            this.taskDao.insert(flwTask);
            this.taskActorDao.insert(FlwTaskActor.ofFlwTask(flwTask));
        } else if (PerformType.countersign.eq(hisTask.getPerformType())) {
            List<FlwHisTask> hisTasks = this.hisTaskDao.selectListByParentTaskId(hisTask.getParentTaskId());
            List<FlwHisTaskActor> hisTaskActors = this.hisTaskActorDao.selectListByTaskIds(hisTasks.stream().map(FlowEntity::getId).collect(Collectors.toList()));
            if (null != hisTaskActors) {
                HashMap<String, FlwHisTaskActor> taskActorMap = new HashMap<String, FlwHisTaskActor>();
                for (FlwHisTaskActor t2 : hisTaskActors) {
                    FlwHisTaskActor t1 = (FlwHisTaskActor)taskActorMap.get(t2.getActorId());
                    if (null != t1 && t2.getTaskId() <= t1.getTaskId()) continue;
                    taskActorMap.put(t2.getActorId(), t2);
                }
                taskActorMap.forEach((k, v) -> hisTasks.stream().filter(t -> Objects.equals(t.getId(), v.getTaskId())).findFirst().ifPresent(t -> {
                    FlwTask flwTask = t.undoTask(taskType);
                    this.taskDao.insert(flwTask);
                    this.taskActorDao.insert(FlwTaskActor.of(flwTask.getId(), v));
                }));
            }
        } else {
            FlwTask flwTask = hisTask.undoTask(taskType);
            this.taskDao.insert(flwTask);
            List<FlwHisTaskActor> hisTaskActors = this.hisTaskActorDao.selectListByTaskId(hisTask.getId());
            if (null != hisTaskActors) {
                hisTaskActors.forEach(t -> this.taskActorDao.insert(FlwTaskActor.of(flwTask.getId(), t)));
            }
        }
        this.updateCurrentNode(hisTask);
        return Optional.of(hisTask);
    }

    protected void assignTask(Long instanceId, Long taskId, int actorType, FlwTaskActor taskActor) {
        taskActor.setId(null);
        taskActor.setInstanceId(instanceId);
        taskActor.setTaskId(taskId);
        taskActor.setActorType(actorType);
        this.taskActorDao.insert(taskActor);
    }

    @Override
    public List<FlwTask> createNewTask(Long taskId, TaskType taskType, PerformType performType, List<FlwTaskActor> taskActors, FlowCreator flowCreator, Function<FlwTask, Execution> executionFunction) {
        FlwTask flwTask = this.taskDao.selectCheckById(taskId);
        FlwTask newFlwTask = flwTask.cloneTask(flowCreator.getCreateId(), flowCreator.getCreateBy());
        newFlwTask.taskType(taskType);
        newFlwTask.setPerformType(performType);
        newFlwTask.setParentTaskId(taskId);
        Execution execution = executionFunction.apply(newFlwTask);
        execution.setFlowCreator(flowCreator);
        return this.saveTask(newFlwTask, performType, taskActors, execution, null);
    }

    @Override
    public List<FlwTask> getTimeoutOrRemindTasks() {
        return this.taskDao.selectListTimeoutOrRemindTasks(DateUtils.getCurrentDate());
    }

    @Override
    public NodeModel getTaskModel(Long taskId) {
        FlwExtInstance extInstance;
        ProcessModel model;
        NodeModel nodeModel;
        FlwTask flwTask = this.hisTaskDao.selectById(taskId);
        if (null == flwTask) {
            flwTask = this.taskDao.selectCheckById(taskId);
        }
        if (null == (nodeModel = (model = (extInstance = this.extInstanceDao.selectById(flwTask.getInstanceId())).model()).getNode(flwTask.getTaskKey()))) {
            Assert.illegal("Cannot find NodeModel. taskId = " + taskId);
        }
        return nodeModel;
    }

    @Override
    public List<FlwTask> createTask(NodeModel nodeModel, Execution execution, Function<FlwTask, FlwTask> taskFunction) {
        FlwTask flwTask = this.createTaskBase(nodeModel, execution);
        if (null != taskFunction) {
            flwTask = taskFunction.apply(flwTask);
        }
        List<FlwTaskActor> taskActors = execution.getTaskActorProvider().getTaskActors(nodeModel, execution);
        ArrayList<FlwTask> flwTasks = new ArrayList<FlwTask>();
        Integer nodeType = nodeModel.getType();
        if (!TaskType.cc.eq(nodeType)) {
            this.updateCurrentNode(flwTask);
        }
        if (TaskType.major.eq(nodeType)) {
            flwTasks.addAll(this.saveTask(flwTask, PerformType.start, taskActors, execution, nodeModel));
            nodeModel.nextNode().ifPresent(nextNode -> nextNode.execute(execution.getEngine().getContext(), execution));
        } else if (TaskType.approval.eq(nodeType)) {
            PerformType performType = PerformType.get(nodeModel.getExamineMode());
            flwTasks.addAll(this.saveTask(flwTask, performType, taskActors, execution, nodeModel));
        } else if (TaskType.cc.eq(nodeType)) {
            this.saveTaskCc(nodeModel, flwTask, execution.getFlowCreator());
            Optional<NodeModel> nextNodeOptional = nodeModel.nextNode();
            if (nextNodeOptional.isPresent()) {
                boolean _exec = true;
                NodeModel ccNextNode = nextNodeOptional.get();
                NodeModel _cnn = execution.getProcessModel().getNode(ccNextNode.getNodeKey());
                if (_cnn.getParentNode().parallelNode() && (ccNextNode.getParentNode().parallelNode() || this.taskDao.selectCountByInstanceId(flwTask.getInstanceId()) > 0L)) {
                    _exec = false;
                }
                if (_exec) {
                    ccNextNode.execute(execution.getEngine().getContext(), execution);
                }
            } else {
                execution.endInstance(nodeModel);
            }
        } else if (TaskType.conditionNode.eq(nodeType)) {
            FlwTask singleFlwTask = flwTask.cloneTask(null);
            PerformType performType = PerformType.get(nodeModel.getExamineMode());
            flwTasks.addAll(this.saveTask(singleFlwTask, performType, taskActors, execution, nodeModel));
        } else if (TaskType.callProcess.eq(nodeType)) {
            FlowCreator flowCreator = execution.getFlowCreator();
            String callProcess = nodeModel.getCallProcess();
            Assert.isEmpty(callProcess, "The execution parameter callProcess does not exist");
            String[] callProcessArr = callProcess.split(":");
            ProcessService processService = execution.getEngine().processService();
            FlwProcess flwProcess = Objects.equals(2, callProcessArr.length) ? processService.getProcessById(Long.valueOf(callProcessArr[0])) : processService.getProcessByKey(flowCreator.getTenantId(), callProcessArr[0]);
            if (null == flwProcess) {
                Assert.illegal("No found flwProcess, callProcess=" + callProcess);
            }
            long instanceId = flwTask.getInstanceId();
            execution.getEngine().startProcessInstance(flwProcess, flowCreator, null, () -> {
                FlwInstance flwInstance = new FlwInstance();
                flwInstance.setCurrentNodeKey(nodeModel.getNodeKey());
                flwInstance.setParentInstanceId(instanceId);
                return flwInstance;
            }).ifPresent(instance -> {
                FlwHisTask flwHisTask = FlwHisTask.ofCallInstance(nodeModel, instance);
                if (this.hisTaskDao.insert(flwHisTask)) {
                    nodeModel.setCallProcess(nodeModel.getCallProcess() + ":" + instance.getId());
                    this.taskNotify(TaskEventType.callProcess, () -> flwHisTask, nodeModel, flowCreator);
                }
            });
        } else if (TaskType.timer.eq(nodeType)) {
            flwTask.loadExpireTime(nodeModel.getExtendConfig(), true);
            flwTasks.addAll(this.saveTask(flwTask, PerformType.timer, taskActors, execution, nodeModel));
        } else if (TaskType.trigger.eq(nodeType)) {
            flwTask.loadExpireTime(nodeModel.getExtendConfig(), false);
            if (null == flwTask.getExpireTime()) {
                execution.setFlwTask(flwTask);
                nodeModel.executeTrigger(execution, e -> this.taskTrigger.execute(nodeModel, execution));
                FlwHisTask hisTask = FlwHisTask.of(flwTask);
                hisTask.setTaskState(TaskState.complete);
                hisTask.setFlowCreator(execution.getFlowCreator());
                hisTask.calculateDuration();
                this.hisTaskDao.insert(hisTask);
                this.taskNotify(TaskEventType.trigger, () -> hisTask, nodeModel, execution.getFlowCreator());
                nodeModel.nextNode().ifPresent(nextNode -> nextNode.execute(execution.getEngine().getContext(), execution));
            } else {
                flwTasks.addAll(this.saveTask(flwTask, PerformType.trigger, taskActors, execution, nodeModel));
            }
        }
        return flwTasks;
    }

    public void saveTaskCc(NodeModel nodeModel, FlwTask flwTask, FlowCreator flowCreator) {
        List<NodeAssignee> nodeUserList = nodeModel.getNodeAssigneeList();
        if (ObjectUtils.isNotEmpty(nodeUserList)) {
            this.taskDao.insert(flwTask);
            FlwHisTask flwHisTask = FlwHisTask.of(flwTask, TaskState.complete);
            flwHisTask.taskType(TaskType.cc);
            flwHisTask.setPerformType(PerformType.copy);
            flwHisTask.calculateDuration();
            this.hisTaskDao.insert(flwHisTask);
            this.taskDao.deleteById(flwTask.getId());
            for (NodeAssignee nodeUser : nodeUserList) {
                this.hisTaskActorDao.insert(FlwHisTaskActor.ofNodeAssignee(nodeUser, flwHisTask.getInstanceId(), flwHisTask.getId()));
            }
            this.taskNotify(TaskEventType.cc, () -> flwHisTask, nodeModel, flowCreator);
        }
    }

    private FlwTask createTaskBase(NodeModel nodeModel, Execution execution) {
        FlwTask flwTask = new FlwTask();
        flwTask.setFlowCreator(execution.getFlowCreator());
        flwTask.setCreateTime(DateUtils.getCurrentDate());
        flwTask.setInstanceId(execution.getFlwInstance().getId());
        flwTask.setTaskName(nodeModel.getNodeName());
        flwTask.setTaskKey(nodeModel.getNodeKey());
        flwTask.setTaskType(nodeModel.getType());
        flwTask.setPerformType(nodeModel.getExamineMode());
        flwTask.setActionUrl(nodeModel.getActionUrl());
        FlwTask executionTask = execution.getFlwTask();
        if (null == executionTask || null == executionTask.getId()) {
            flwTask.setParentTaskId(0L);
        } else {
            flwTask.setParentTaskId(executionTask.getId());
        }
        Map<String, Object> args = execution.getArgs();
        Integer term = nodeModel.getTerm();
        if (null != term && term > 0) {
            flwTask.setExpireTime(DateUtils.toDate(DateUtils.now().plusHours(term.intValue())));
            if (null == args) {
                args = new HashMap<String, Object>();
            }
            args.put("termMode", nodeModel.getTermMode());
        }
        flwTask.setVariable(args);
        flwTask.setRemindRepeat(0);
        flwTask.setViewed(0);
        return flwTask;
    }

    protected List<FlwTask> saveTask(FlwTask flwTask, PerformType performType, List<FlwTaskActor> taskActors, Execution execution, NodeModel nodeModel) {
        ArrayList<FlwTask> flwTasks = new ArrayList<FlwTask>();
        flwTask.setPerformType(performType);
        FlowCreator flowCreator = execution.getFlowCreator();
        if (performType == PerformType.timer || performType == PerformType.trigger) {
            this.taskDao.insert(flwTask);
            flwTasks.add(flwTask);
            return flwTasks;
        }
        if (performType == PerformType.start) {
            this.taskDao.insert(flwTask);
            FlwHisTask flwHisTask = FlwHisTask.of(flwTask, TaskState.complete);
            flwHisTask.calculateDuration();
            if (this.hisTaskDao.insert(flwHisTask)) {
                execution.setFlwTask(flwHisTask);
                this.taskDao.deleteById(flwTask.getId());
                this.hisTaskActorDao.insert(FlwHisTaskActor.ofFlwHisTask(flwHisTask));
                flwTask.setId(flwHisTask.getId());
                flwTasks.add(flwTask);
                this.taskNotify(TaskEventType.start, () -> flwTask, nodeModel, flowCreator);
            }
            return flwTasks;
        }
        if (ObjectUtils.isEmpty(taskActors) && execution.getTaskActorProvider().abnormal(flwTask, performType, taskActors, execution, nodeModel)) {
            return flwTasks;
        }
        int actorType = nodeModel.actorType();
        if (performType == PerformType.orSign) {
            this.taskDao.insert(flwTask);
            taskActors.forEach(t -> this.assignTask(flwTask.getInstanceId(), flwTask.getId(), this.assignActorType(actorType, t.getActorType()), (FlwTaskActor)t));
            flwTasks.add(flwTask);
            this.taskNotify(TaskEventType.create, () -> flwTask, nodeModel, flowCreator);
            return flwTasks;
        }
        if (performType == PerformType.sort) {
            this.taskDao.insert(flwTask);
            flwTasks.add(flwTask);
            FlwTaskActor nextFlwTaskActor = execution.getNextFlwTaskActor();
            if (null == nextFlwTaskActor) {
                nextFlwTaskActor = taskActors.get(0);
            }
            this.assignTask(flwTask.getInstanceId(), flwTask.getId(), this.assignActorType(actorType, nextFlwTaskActor.getActorType()), nextFlwTaskActor);
            this.taskNotify(TaskEventType.create, () -> flwTask, nodeModel, flowCreator);
            return flwTasks;
        }
        taskActors.forEach(t -> {
            FlwTask newFlwTask = flwTask.cloneTask(null);
            this.taskDao.insert(newFlwTask);
            flwTasks.add(newFlwTask);
            this.assignTask(newFlwTask.getInstanceId(), newFlwTask.getId(), this.assignActorType(actorType, t.getActorType()), (FlwTaskActor)t);
        });
        flwTasks.forEach(t -> this.taskNotify(TaskEventType.create, () -> t, nodeModel, flowCreator));
        return flwTasks;
    }

    protected int assignActorType(int actorType, Integer dbActorType) {
        return null == dbActorType ? actorType : dbActorType;
    }

    @Override
    public FlwTaskActor isAllowed(FlwTask flwTask, String userId) {
        if (null == flwTask.getCreateId()) {
            return null;
        }
        if (ObjectUtils.isEmpty(userId)) {
            return null;
        }
        List<FlwTaskActor> actors = this.taskActorDao.selectListByTaskId(flwTask.getId());
        return this.taskAccessStrategy.isAllowed(userId, actors);
    }

    @Override
    public boolean addTaskActor(Long taskId, PerformType performType, List<FlwTaskActor> flwTaskActors, FlowCreator flowCreator) {
        FlwTask flwTask = this.taskDao.selectCheckById(taskId);
        Assert.isTrue(ObjectUtils.isEmpty(flwTaskActors), "actorIds cannot be empty");
        List<FlwTaskActor> taskActorList = this.getTaskActorsByTaskId(taskId);
        Map<String, FlwTaskActor> taskActorMap = taskActorList.stream().collect(Collectors.toMap(FlwTaskActor::getActorId, t -> t));
        for (FlwTaskActor flwTaskActor : flwTaskActors) {
            if (null != taskActorMap.get(flwTaskActor.getActorId())) continue;
            if (PerformType.countersign.eq(flwTask.getPerformType())) {
                FlwTask newFlwTask = flwTask.cloneTask(flowCreator.getCreateId(), flowCreator.getCreateBy());
                this.taskDao.insert(newFlwTask);
                this.assignTask(flwTask.getInstanceId(), newFlwTask.getId(), 0, flwTaskActor);
                continue;
            }
            this.assignTask(flwTask.getInstanceId(), taskId, 0, flwTaskActor);
        }
        FlwTask temp = new FlwTask();
        temp.setId(taskId);
        temp.setPerformType(performType);
        if (this.taskDao.updateById(temp)) {
            this.taskNotify(TaskEventType.addTaskActor, () -> flwTask, null, flowCreator);
            return true;
        }
        return false;
    }

    protected List<FlwTaskActor> getTaskActorsByTaskId(Long taskId) {
        List<FlwTaskActor> taskActorList = this.taskActorDao.selectListByTaskId(taskId);
        Assert.isTrue(ObjectUtils.isEmpty(taskActorList), "not found task actor");
        return taskActorList;
    }

    @Override
    public boolean removeTaskActor(Long taskId, List<String> actorIds, FlowCreator flowCreator) {
        FlwTask flwTask = this.taskDao.selectCheckById(taskId);
        Assert.isTrue(ObjectUtils.isEmpty(actorIds), "actorIds cannot be empty");
        if (PerformType.countersign.eq(flwTask.getPerformType())) {
            List<FlwTaskActor> taskActorList = this.taskActorDao.selectListByInstanceId(flwTask.getInstanceId());
            if (ObjectUtils.isEmpty(taskActorList)) {
                return false;
            }
            taskActorList.forEach(t -> {
                if (actorIds.contains(t.getActorId())) {
                    this.taskActorDao.deleteById(t.getId());
                    this.taskDao.deleteById(t.getTaskId());
                }
            });
        } else if (!this.taskActorDao.deleteByTaskIdAndActorIds(taskId, actorIds)) {
            return false;
        }
        this.taskNotify(TaskEventType.removeTaskActor, () -> flwTask, null, flowCreator);
        return true;
    }

    @Override
    public void endCallProcessTask(Long callProcessId, Long callInstanceId) {
        List<FlwHisTask> flwHisTasks = this.hisTaskDao.selectListByCallProcessIdAndCallInstanceId(callProcessId, callInstanceId);
        if (ObjectUtils.isNotEmpty(flwHisTasks)) {
            FlwHisTask dbHis = flwHisTasks.get(0);
            FlwHisTask his = new FlwHisTask();
            his.setId(dbHis.getId());
            his.setCreateTime(dbHis.getCreateTime());
            his.setTaskState(TaskState.complete);
            his.calculateDuration();
            his.setCreateTime(null);
            this.hisTaskDao.updateById(his);
        }
    }

    @Override
    public boolean cascadeRemoveByInstanceIds(List<Long> instanceIds) {
        this.hisTaskActorDao.deleteByInstanceIds(instanceIds);
        this.hisTaskDao.deleteByInstanceIds(instanceIds);
        this.taskActorDao.deleteByInstanceIds(instanceIds);
        this.taskDao.deleteByInstanceIds(instanceIds);
        return true;
    }
}

