/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.bpm.engine.model;

import com.aizuda.bpm.engine.FlowDataTransfer;
import com.aizuda.bpm.engine.assist.ObjectUtils;
import com.aizuda.bpm.engine.core.Execution;
import com.aizuda.bpm.engine.core.FlowLongContext;
import com.aizuda.bpm.engine.core.enums.NodeSetType;
import com.aizuda.bpm.engine.core.enums.TaskType;
import com.aizuda.bpm.engine.model.ConditionNode;
import com.aizuda.bpm.engine.model.DynamicAssignee;
import com.aizuda.bpm.engine.model.NodeExpression;
import com.aizuda.bpm.engine.model.NodeModel;
import com.aizuda.bpm.engine.model.ProcessModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ModelHelper {
    public static List<NodeModel> getNextChildNodes(FlowLongContext flowLongContext, Execution execution, NodeModel rootNodeModel, String currentNodeKey) {
        NodeModel currentNodeModel = rootNodeModel.getNode(currentNodeKey);
        if (currentNodeModel.approvalOrMajor()) {
            NodeModel childNode = currentNodeModel.getChildNode();
            if (null == childNode) {
                return ModelHelper.getChildNode(flowLongContext, execution, rootNodeModel, currentNodeModel);
            }
            return ModelHelper.getNextChildNodes(flowLongContext, execution, rootNodeModel, childNode);
        }
        return null;
    }

    private static List<NodeModel> getNextChildNodes(FlowLongContext flowLongContext, Execution execution, NodeModel rootNodeModel, NodeModel childNode) {
        ArrayList<NodeModel> nextNodes = new ArrayList<NodeModel>();
        if (childNode.conditionNode()) {
            flowLongContext.getFlowConditionHandler().getConditionNode(flowLongContext, execution, childNode).ifPresent(t -> nextNodes.add(t.getChildNode()));
        } else if (childNode.parallelNode()) {
            childNode.getParallelNodes().forEach(t -> nextNodes.add(t.getChildNode()));
        } else if (childNode.inclusiveNode()) {
            flowLongContext.getFlowConditionHandler().getInclusiveNodes(flowLongContext, execution, childNode).ifPresent(optList -> {
                if (Objects.equals(1, optList.size()) && null == ((ConditionNode)optList.get(0)).getChildNode()) {
                    nextNodes.add(childNode.getChildNode());
                } else {
                    optList.forEach(t -> nextNodes.add(t.getChildNode()));
                }
            });
        } else if (childNode.routeNode()) {
            Optional<ConditionNode> opt = flowLongContext.getFlowConditionHandler().getRouteNode(flowLongContext, execution, childNode);
            if (opt.isPresent()) {
                nextNodes.add(rootNodeModel.getNode(opt.get().getNodeKey()));
            } else if (null != childNode.getChildNode()) {
                nextNodes.addAll(ModelHelper.getNextChildNodes(flowLongContext, execution, rootNodeModel, childNode.getChildNode()));
            }
        } else if (!TaskType.end.eq(childNode.getType())) {
            nextNodes.add(childNode);
        }
        return nextNodes;
    }

    private static List<NodeModel> getChildNode(FlowLongContext flowLongContext, Execution execution, NodeModel rootNodeModel, NodeModel nodeModel) {
        ArrayList<NodeModel> nextNodes = new ArrayList<NodeModel>();
        NodeModel parentNode = nodeModel.getParentNode();
        if (null == parentNode || TaskType.major.eq(parentNode.getType())) {
            return nextNodes;
        }
        if (parentNode.conditionNode()) {
            NodeModel parentChildNode = parentNode.getChildNode();
            if (null == parentChildNode || Objects.equals(parentChildNode.getNodeKey(), nodeModel.getNodeKey())) {
                return ModelHelper.getChildNode(flowLongContext, execution, rootNodeModel, parentNode);
            }
            nextNodes.addAll(ModelHelper.getNextChildNodes(flowLongContext, execution, rootNodeModel, parentChildNode));
        } else if (parentNode.parallelNode()) {
            nextNodes.add(parentNode.getChildNode());
        } else if (parentNode.inclusiveNode()) {
            nextNodes.add(parentNode.getChildNode());
        } else if (parentNode.routeNode()) {
            flowLongContext.getFlowConditionHandler().getRouteNode(flowLongContext, execution, parentNode).ifPresent(t -> nextNodes.add(parentNode.getNode(t.getNodeKey())));
        }
        return nextNodes;
    }

    public static NodeModel findNextNode(NodeModel nodeModel, List<String> currentTask) {
        NodeModel childNode;
        NodeModel parentNode = nodeModel.getParentNode();
        if (null == parentNode || TaskType.major.eq(parentNode.getType())) {
            return null;
        }
        if (parentNode.conditionNode() && null != (childNode = parentNode.getChildNode()) && !Objects.equals(childNode.getNodeKey(), nodeModel.getNodeKey())) {
            return childNode;
        }
        if (parentNode.parallelNode() || parentNode.inclusiveNode()) {
            if (null == currentTask) {
                return parentNode.getChildNode();
            }
            if (Collections.disjoint(currentTask, ModelHelper.getAllNextConditionNodeKeys(parentNode))) {
                childNode = parentNode.getChildNode();
                if (null != childNode && Objects.equals(childNode.getNodeKey(), nodeModel.getNodeKey())) {
                    return null;
                }
                return childNode;
            }
            return null;
        }
        return ModelHelper.findNextNode(parentNode, currentTask);
    }

    public static List<String> getAllPreviousNodeKeys(NodeModel nodeModel) {
        List<String> getNodeKeys = ModelHelper.getAllParentNodeKeys(nodeModel.getNodeKey(), nodeModel.getParentNode());
        return getNodeKeys.stream().distinct().collect(Collectors.toList());
    }

    private static List<String> getAllParentNodeKeys(String currentNodeKey, NodeModel nodeModel) {
        ArrayList<String> nodeKeys = new ArrayList<String>();
        if (null != nodeModel) {
            if (!nodeModel.ccNode()) {
                if (nodeModel.conditionNode()) {
                    nodeKeys.addAll(ModelHelper.getAllConditionNodeKeys(currentNodeKey, nodeModel));
                } else {
                    nodeKeys.add(nodeModel.getNodeKey());
                }
            }
            nodeKeys.addAll(ModelHelper.getAllParentNodeKeys(currentNodeKey, nodeModel.getParentNode()));
        }
        return nodeKeys;
    }

    private static List<String> getAllConditionNodeKeys(String currentNodeKey, NodeModel nodeModel) {
        List<ConditionNode> conditionNodes;
        ArrayList<String> nodeKeys = new ArrayList<String>();
        if (null != nodeModel && ObjectUtils.isNotEmpty(conditionNodes = nodeModel.getConditionNodes())) {
            for (ConditionNode conditionNode : conditionNodes) {
                NodeModel childNodeMode = conditionNode.getChildNode();
                if (null == childNodeMode) continue;
                if (childNodeMode.conditionNode()) {
                    nodeKeys.addAll(ModelHelper.getAllConditionNodeKeys(currentNodeKey, childNodeMode));
                    continue;
                }
                List<String> allNextNodeKeys = ModelHelper.getAllNextConditionNodeKeys(childNodeMode);
                if (!allNextNodeKeys.contains(currentNodeKey)) continue;
                ArrayList<String> legalNodeKeys = new ArrayList<String>();
                for (String t : allNextNodeKeys) {
                    if (currentNodeKey.equals(t)) break;
                    legalNodeKeys.add(t);
                }
                nodeKeys.addAll(legalNodeKeys);
            }
        }
        return nodeKeys;
    }

    private static List<String> getAllNextConditionNodeKeys(NodeModel nodeModel) {
        ArrayList<String> nodeKeys = new ArrayList<String>();
        if (null != nodeModel) {
            if (nodeModel.conditionNode()) {
                List<ConditionNode> conditionNodes = nodeModel.getConditionNodes();
                if (ObjectUtils.isNotEmpty(conditionNodes)) {
                    for (ConditionNode conditionNode : conditionNodes) {
                        nodeKeys.addAll(ModelHelper.getAllNextConditionNodeKeys(conditionNode.getChildNode()));
                    }
                }
                nodeKeys.addAll(ModelHelper.getAllNextConditionNodeKeys(nodeModel.getChildNode()));
            } else if (nodeModel.parallelNode()) {
                for (NodeModel node : nodeModel.getParallelNodes()) {
                    nodeKeys.addAll(ModelHelper.getAllNextConditionNodeKeys(node));
                }
            } else if (nodeModel.inclusiveNode()) {
                for (ConditionNode conditionNode : nodeModel.getInclusiveNodes()) {
                    nodeKeys.addAll(ModelHelper.getAllNextConditionNodeKeys(conditionNode.getChildNode()));
                }
            } else {
                NodeModel childNodeModel;
                if (!nodeModel.ccNode()) {
                    nodeKeys.add(nodeModel.getNodeKey());
                }
                if (null != (childNodeModel = nodeModel.getChildNode())) {
                    nodeKeys.addAll(ModelHelper.getAllNextConditionNodeKeys(childNodeModel));
                }
            }
        }
        return nodeKeys;
    }

    public static List<NodeModel> getUnsetAssigneeNodes(NodeModel rootNodeModel) {
        List<NodeModel> nodeModels = ModelHelper.getRootNodeAllChildNodes(rootNodeModel);
        return nodeModels.stream().filter(t -> ObjectUtils.isEmpty(t.getNodeAssigneeList()) && NodeSetType.initiatorThemselves.ne(t.getSetType()) && (TaskType.approval.eq(t.getType()) || TaskType.cc.eq(t.getType()))).collect(Collectors.toList());
    }

    public static List<NodeModel> getRootNodeAllChildNodes(NodeModel rootNodeModel) {
        ArrayList<NodeModel> nodeModels = new ArrayList<NodeModel>();
        if (null != rootNodeModel) {
            if (rootNodeModel.conditionNode()) {
                List<ConditionNode> conditionNodes = rootNodeModel.getConditionNodes();
                if (ObjectUtils.isNotEmpty(conditionNodes)) {
                    for (ConditionNode conditionNode : conditionNodes) {
                        nodeModels.addAll(ModelHelper.getRootNodeAllChildNodes(conditionNode.getChildNode()));
                    }
                }
                nodeModels.addAll(ModelHelper.getRootNodeAllChildNodes(rootNodeModel.getChildNode()));
            } else if (rootNodeModel.parallelNode()) {
                for (NodeModel nodeModel : rootNodeModel.getParallelNodes()) {
                    nodeModels.addAll(ModelHelper.getRootNodeAllChildNodes(nodeModel));
                }
            } else if (rootNodeModel.inclusiveNode()) {
                for (ConditionNode conditionNode : rootNodeModel.getInclusiveNodes()) {
                    nodeModels.addAll(ModelHelper.getRootNodeAllChildNodes(conditionNode.getChildNode()));
                }
            } else {
                nodeModels.add(rootNodeModel);
                NodeModel childNodeModel = rootNodeModel.getChildNode();
                if (null != childNodeModel) {
                    nodeModels.addAll(ModelHelper.getRootNodeAllChildNodes(childNodeModel));
                }
            }
        }
        return nodeModels;
    }

    public static boolean checkDuplicateNodeKeys(NodeModel rootNodeModel) {
        List<NodeModel> allNextNodes = ModelHelper.getRootNodeAllChildNodes(rootNodeModel);
        HashSet<String> set = new HashSet<String>();
        for (NodeModel nextNode : allNextNodes) {
            if (set.add(nextNode.getNodeKey())) continue;
            return true;
        }
        return false;
    }

    public static int checkConditionNode(NodeModel nodeModel) {
        if (null != nodeModel) {
            List<ConditionNode> conditionNodes = nodeModel.getConditionNodes();
            if (ObjectUtils.isEmpty(conditionNodes)) {
                return ModelHelper.checkConditionNode(nodeModel.getChildNode());
            }
            int i = 0;
            int j = 0;
            HashSet<String> nodeKeys = new HashSet<String>();
            for (ConditionNode conditionNode : conditionNodes) {
                if (!nodeKeys.add(conditionNode.getNodeKey())) {
                    return 3;
                }
                List<List<NodeExpression>> conditionList = conditionNode.getConditionList();
                if (ObjectUtils.isEmpty(conditionList)) {
                    ++i;
                }
                if (null == conditionNode.getChildNode()) {
                    ++j;
                }
                if (i <= 1 && j <= 1) continue;
                break;
            }
            if (i > 1) {
                return 1;
            }
            if (j > 1) {
                return 2;
            }
            Iterator<ConditionNode> iterator = conditionNodes.iterator();
            if (iterator.hasNext()) {
                ConditionNode conditionNode;
                conditionNode = iterator.next();
                return ModelHelper.checkConditionNode(conditionNode.getChildNode());
            }
        }
        return 0;
    }

    public static boolean checkExistApprovalNode(NodeModel rootNodeModel) {
        List<NodeModel> allNextNodes = ModelHelper.getRootNodeAllChildNodes(rootNodeModel);
        return allNextNodes.stream().anyMatch(t -> TaskType.approval.eq(t.getType()));
    }

    public static String generateNodeKey() {
        return "flk" + System.currentTimeMillis();
    }

    public static Map<String, DynamicAssignee> getAssigneeMap(NodeModel rootNodeModel) {
        return ModelHelper.getRootNodeAllChildNodes(rootNodeModel).stream().collect(Collectors.toMap(NodeModel::getNodeKey, DynamicAssignee::ofNodeModel));
    }

    public static NodeModel getNodeModel(String nodeKey, NodeModel rootNodeModel) {
        return ModelHelper.getRootNodeAllChildNodes(rootNodeModel).stream().filter(e -> Objects.equals(nodeKey, e.getNodeKey())).findFirst().orElse(null);
    }

    public static void reloadProcessModel(ProcessModel processModel, Consumer<ProcessModel> consumer) {
        Map modelData = (Map)FlowDataTransfer.get("flwProcessDynamicAssignee");
        if (ObjectUtils.isNotEmpty(modelData)) {
            modelData.forEach((key, value) -> {
                NodeModel thisNodeModel;
                if (value instanceof DynamicAssignee && null != (thisNodeModel = processModel.getNode((String)key))) {
                    DynamicAssignee dynamicAssignee = (DynamicAssignee)value;
                    thisNodeModel.setNodeAssigneeList(dynamicAssignee.getAssigneeList());
                }
            });
            consumer.accept(processModel);
            FlowDataTransfer.removeByKey("flwProcessDynamicAssignee");
        }
    }

    public static List<String> getAllUsedNodeKeys(FlowLongContext flowLongContext, Execution execution, NodeModel rootNodeModel, String currentNodeKey) {
        ArrayList<String> currentUsedNodeKeys = new ArrayList<String>();
        if (null != rootNodeModel) {
            String nodeKey = rootNodeModel.getNodeKey();
            if (Objects.equals(currentNodeKey, nodeKey)) {
                currentUsedNodeKeys.add(nodeKey);
            } else if (rootNodeModel.conditionNode()) {
                List<ConditionNode> conditionNodes = rootNodeModel.getConditionNodes();
                if (ObjectUtils.isNotEmpty(conditionNodes)) {
                    flowLongContext.getFlowConditionHandler().getConditionNode(flowLongContext, execution, rootNodeModel).ifPresent(t -> {
                        currentUsedNodeKeys.add(t.getNodeKey());
                        ModelHelper.getChildAllUsedNodeKeys(currentUsedNodeKeys, flowLongContext, execution, t.getChildNode(), currentNodeKey);
                    });
                }
                ModelHelper.getChildAllUsedNodeKeys(currentUsedNodeKeys, flowLongContext, execution, rootNodeModel.getChildNode(), currentNodeKey);
            } else {
                currentUsedNodeKeys.add(nodeKey);
                NodeModel childNodeModel = rootNodeModel.getChildNode();
                if (null != childNodeModel) {
                    ModelHelper.getChildAllUsedNodeKeys(currentUsedNodeKeys, flowLongContext, execution, childNodeModel, currentNodeKey);
                }
            }
        }
        return currentUsedNodeKeys;
    }

    public static void getChildAllUsedNodeKeys(List<String> currentUsedNodeKeys, FlowLongContext flowLongContext, Execution execution, NodeModel rootNodeModel, String currentNodeKey) {
        if (!currentUsedNodeKeys.contains(currentNodeKey)) {
            currentUsedNodeKeys.addAll(ModelHelper.getAllUsedNodeKeys(flowLongContext, execution, rootNodeModel, currentNodeKey));
        }
    }
}

