/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.bpm.engine.model;

import com.aizuda.bpm.engine.ModelInstance;
import com.aizuda.bpm.engine.TaskTrigger;
import com.aizuda.bpm.engine.assist.Assert;
import com.aizuda.bpm.engine.assist.ObjectUtils;
import com.aizuda.bpm.engine.core.Execution;
import com.aizuda.bpm.engine.core.FlowLongContext;
import com.aizuda.bpm.engine.core.enums.NodeSetType;
import com.aizuda.bpm.engine.core.enums.TaskType;
import com.aizuda.bpm.engine.model.ConditionNode;
import com.aizuda.bpm.engine.model.ModelHelper;
import com.aizuda.bpm.engine.model.NodeAssignee;
import com.aizuda.bpm.engine.model.NodeCandidate;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class NodeModel
implements ModelInstance,
Serializable {
    private String nodeName;
    private String nodeKey;
    private String callProcess;
    private String actionUrl;
    private Integer type;
    private Integer setType;
    private List<NodeAssignee> nodeAssigneeList;
    private NodeCandidate nodeCandidate;
    private Integer examineLevel;
    private Integer examineMode;
    private Integer directorLevel;
    private Integer directorMode;
    private Integer selectMode;
    private Boolean termAuto;
    private Integer term;
    private Integer termMode;
    private Integer typeOfApprove;
    private Integer passWeight;
    private Integer rejectStrategy;
    private Integer rejectStart;
    private List<ConditionNode> conditionNodes;
    private List<NodeModel> parallelNodes;
    private List<ConditionNode> inclusiveNodes;
    private List<ConditionNode> routeNodes;
    private Boolean remind;
    private Boolean allowSelection;
    private Boolean allowTransfer;
    private Boolean allowAppendNode;
    private Boolean allowRollback;
    private Integer approveSelf;
    private Map<String, Object> extendConfig;
    private NodeModel childNode;
    private NodeModel parentNode;
    private String triggerType;
    private String delayType;

    @Override
    public boolean execute(FlowLongContext flowLongContext, Execution execution) {
        if (TaskType.conditionBranch.eq(this.type)) {
            flowLongContext.getFlowConditionHandler().getConditionNode(flowLongContext, execution, this).ifPresent(t -> this.executeConditionNode(flowLongContext, execution, (ConditionNode)t));
            return true;
        }
        if (TaskType.parallelBranch.eq(this.type)) {
            for (NodeModel parallelNode : this.parallelNodes) {
                if (TaskType.conditionNode.eq(parallelNode.getType())) {
                    parallelNode.getChildNode().execute(flowLongContext, execution);
                    continue;
                }
                parallelNode.execute(flowLongContext, execution);
            }
            return true;
        }
        if (TaskType.inclusiveBranch.eq(this.type)) {
            flowLongContext.getFlowConditionHandler().getInclusiveNodes(flowLongContext, execution, this).ifPresent(t -> t.forEach(s -> this.executeConditionNode(flowLongContext, execution, (ConditionNode)s)));
            return true;
        }
        if (TaskType.routeBranch.eq(this.type)) {
            Optional<ConditionNode> routeNodeOptional = flowLongContext.getFlowConditionHandler().getRouteNode(flowLongContext, execution, this);
            if (routeNodeOptional.isPresent()) {
                execution.getEngine().executeJumpTask(execution.getFlwTask().getId(), routeNodeOptional.get().getNodeKey(), execution.getFlowCreator(), execution.getArgs(), TaskType.routeJump);
            } else {
                this.nextNode().ifPresent(nextNode -> flowLongContext.createTask(execution, (NodeModel)nextNode));
            }
            return true;
        }
        if (TaskType.approval.eq(this.type) || TaskType.cc.eq(this.type) || TaskType.callProcess.eq(this.type) || TaskType.timer.eq(this.type) || TaskType.trigger.eq(this.type)) {
            flowLongContext.createTask(execution, this);
        } else if (TaskType.end.eq(this.type)) {
            return execution.endInstance(this);
        }
        if (null == this.getChildNode() && null == this.getConditionNodes() && !this.nextNode().isPresent() && !TaskType.approval.eq(this.type)) {
            execution.endInstance(this);
        }
        return true;
    }

    public void executeConditionNode(FlowLongContext flowLongContext, Execution execution, ConditionNode conditionNode) {
        NodeModel childNode = conditionNode.getChildNode();
        if (null == childNode) {
            childNode = this.getChildNode();
        }
        if (null != childNode) {
            childNode.execute(flowLongContext, execution);
        } else if (this.nextNode().isPresent()) {
            this.nextNode().ifPresent(nodeModel -> nodeModel.execute(flowLongContext, execution));
        } else {
            execution.endInstance(this);
        }
    }

    public NodeModel getNode(String nodeKey) {
        if (Objects.equals(this.nodeKey, nodeKey)) {
            return this;
        }
        NodeModel fromConditionNode = this.getFromConditionNodes(nodeKey, this.conditionNodes);
        if (fromConditionNode != null) {
            return fromConditionNode;
        }
        NodeModel fromParallelNode = this.getFromNodeModels(nodeKey, this.parallelNodes);
        if (fromParallelNode != null) {
            return fromParallelNode;
        }
        NodeModel fromInclusiveNode = this.getFromConditionNodes(nodeKey, this.inclusiveNodes);
        if (fromInclusiveNode != null) {
            return fromInclusiveNode;
        }
        if (null != this.childNode) {
            return this.childNode.getNode(nodeKey);
        }
        return null;
    }

    private NodeModel getFromNodeModels(String nodeKey, List<NodeModel> nodeModels) {
        if (null != nodeModels) {
            for (NodeModel nodeModel : nodeModels) {
                NodeModel selectNode = nodeModel.getNode(nodeKey);
                if (null == selectNode) continue;
                return selectNode;
            }
        }
        return null;
    }

    private NodeModel getFromConditionNodes(String nodeKey, List<ConditionNode> conditionNodes) {
        if (null != conditionNodes) {
            for (ConditionNode conditionNode : conditionNodes) {
                NodeModel nodeModel;
                NodeModel conditionChildNode = conditionNode.getChildNode();
                if (null == conditionChildNode || null == (nodeModel = conditionChildNode.getNode(nodeKey))) continue;
                return nodeModel;
            }
        }
        return null;
    }

    public Optional<NodeModel> nextNode() {
        return this.nextNode(null);
    }

    public Optional<NodeModel> nextNode(List<String> currentTask) {
        NodeModel nextNode = this.getChildNode();
        if (null == nextNode) {
            nextNode = ModelHelper.findNextNode(this, currentTask);
        } else if (TaskType.end.eq(nextNode.getType())) {
            nextNode = null;
        }
        return Optional.ofNullable(nextNode);
    }

    public NodeModel parentApprovalNode() {
        NodeModel parentNode = this.getParentNode();
        if (parentNode.approvalOrMajor()) {
            return parentNode;
        }
        return parentNode.parentApprovalNode();
    }

    public boolean approvalOrMajor() {
        return TaskType.approval.eq(this.type) || TaskType.major.eq(this.type);
    }

    public boolean conditionNode() {
        return TaskType.conditionNode.eq(this.type) || TaskType.conditionBranch.eq(this.type);
    }

    public boolean ccNode() {
        return TaskType.cc.eq(this.type);
    }

    public boolean parallelNode() {
        return TaskType.parallelBranch.eq(this.type);
    }

    public boolean inclusiveNode() {
        return TaskType.inclusiveBranch.eq(this.type);
    }

    public boolean routeNode() {
        return TaskType.routeBranch.eq(this.type);
    }

    public int actorType() {
        if (NodeSetType.role.eq(this.setType)) {
            return 1;
        }
        if (NodeSetType.department.eq(this.setType)) {
            return 2;
        }
        return 0;
    }

    public void executeTrigger(Execution execution, Function<Exception, Boolean> function) {
        boolean flag;
        block4: {
            Object _trigger;
            flag = false;
            Map<String, Object> extendConfig = this.getExtendConfig();
            if (null != extendConfig && null != (_trigger = extendConfig.get("trigger"))) {
                try {
                    Class<?> triggerClass = Class.forName((String)_trigger);
                    if (TaskTrigger.class.isAssignableFrom(triggerClass)) {
                        TaskTrigger taskTrigger = (TaskTrigger)ObjectUtils.newInstance(triggerClass);
                        flag = taskTrigger.execute(this, execution);
                    }
                }
                catch (Exception e) {
                    if (null == function) break block4;
                    flag = function.apply(e);
                }
            }
        }
        Assert.isFalse(flag, "trigger execute error");
    }

    public NodeModel cloneBaseInfo() {
        NodeModel nodeModel = new NodeModel();
        nodeModel.setNodeName(this.nodeName);
        nodeModel.setNodeKey(this.nodeKey);
        nodeModel.setCallProcess(this.callProcess);
        nodeModel.setActionUrl(this.actionUrl);
        nodeModel.setType(this.type);
        nodeModel.setSetType(this.setType);
        nodeModel.setNodeAssigneeList(this.nodeAssigneeList);
        nodeModel.setNodeCandidate(this.nodeCandidate);
        nodeModel.setExamineLevel(this.examineLevel);
        nodeModel.setExamineMode(this.examineMode);
        nodeModel.setDirectorLevel(this.directorLevel);
        nodeModel.setDirectorMode(this.directorMode);
        nodeModel.setSelectMode(this.selectMode);
        nodeModel.setTermAuto(this.termAuto);
        nodeModel.setTerm(this.term);
        nodeModel.setTermMode(this.termMode);
        nodeModel.setTypeOfApprove(this.typeOfApprove);
        nodeModel.setPassWeight(this.passWeight);
        nodeModel.setRejectStrategy(this.rejectStrategy);
        nodeModel.setRejectStart(this.rejectStart);
        nodeModel.setRemind(this.remind);
        nodeModel.setAllowSelection(this.allowSelection);
        nodeModel.setAllowTransfer(this.allowTransfer);
        nodeModel.setAllowAppendNode(this.allowAppendNode);
        nodeModel.setAllowRollback(this.allowRollback);
        nodeModel.setApproveSelf(this.approveSelf);
        nodeModel.setExtendConfig(this.extendConfig);
        nodeModel.setTriggerType(this.triggerType);
        nodeModel.setDelayType(this.delayType);
        return nodeModel;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getNodeKey() {
        return this.nodeKey;
    }

    public String getCallProcess() {
        return this.callProcess;
    }

    public String getActionUrl() {
        return this.actionUrl;
    }

    public Integer getType() {
        return this.type;
    }

    public Integer getSetType() {
        return this.setType;
    }

    public List<NodeAssignee> getNodeAssigneeList() {
        return this.nodeAssigneeList;
    }

    public NodeCandidate getNodeCandidate() {
        return this.nodeCandidate;
    }

    public Integer getExamineLevel() {
        return this.examineLevel;
    }

    public Integer getExamineMode() {
        return this.examineMode;
    }

    public Integer getDirectorLevel() {
        return this.directorLevel;
    }

    public Integer getDirectorMode() {
        return this.directorMode;
    }

    public Integer getSelectMode() {
        return this.selectMode;
    }

    public Boolean getTermAuto() {
        return this.termAuto;
    }

    public Integer getTerm() {
        return this.term;
    }

    public Integer getTermMode() {
        return this.termMode;
    }

    public Integer getTypeOfApprove() {
        return this.typeOfApprove;
    }

    public Integer getPassWeight() {
        return this.passWeight;
    }

    public Integer getRejectStrategy() {
        return this.rejectStrategy;
    }

    public Integer getRejectStart() {
        return this.rejectStart;
    }

    public List<ConditionNode> getConditionNodes() {
        return this.conditionNodes;
    }

    public List<NodeModel> getParallelNodes() {
        return this.parallelNodes;
    }

    public List<ConditionNode> getInclusiveNodes() {
        return this.inclusiveNodes;
    }

    public List<ConditionNode> getRouteNodes() {
        return this.routeNodes;
    }

    public Boolean getRemind() {
        return this.remind;
    }

    public Boolean getAllowSelection() {
        return this.allowSelection;
    }

    public Boolean getAllowTransfer() {
        return this.allowTransfer;
    }

    public Boolean getAllowAppendNode() {
        return this.allowAppendNode;
    }

    public Boolean getAllowRollback() {
        return this.allowRollback;
    }

    public Integer getApproveSelf() {
        return this.approveSelf;
    }

    public Map<String, Object> getExtendConfig() {
        return this.extendConfig;
    }

    public NodeModel getChildNode() {
        return this.childNode;
    }

    public NodeModel getParentNode() {
        return this.parentNode;
    }

    public String getTriggerType() {
        return this.triggerType;
    }

    public String getDelayType() {
        return this.delayType;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public void setNodeKey(String nodeKey) {
        this.nodeKey = nodeKey;
    }

    public void setCallProcess(String callProcess) {
        this.callProcess = callProcess;
    }

    public void setActionUrl(String actionUrl) {
        this.actionUrl = actionUrl;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setSetType(Integer setType) {
        this.setType = setType;
    }

    public void setNodeAssigneeList(List<NodeAssignee> nodeAssigneeList) {
        this.nodeAssigneeList = nodeAssigneeList;
    }

    public void setNodeCandidate(NodeCandidate nodeCandidate) {
        this.nodeCandidate = nodeCandidate;
    }

    public void setExamineLevel(Integer examineLevel) {
        this.examineLevel = examineLevel;
    }

    public void setExamineMode(Integer examineMode) {
        this.examineMode = examineMode;
    }

    public void setDirectorLevel(Integer directorLevel) {
        this.directorLevel = directorLevel;
    }

    public void setDirectorMode(Integer directorMode) {
        this.directorMode = directorMode;
    }

    public void setSelectMode(Integer selectMode) {
        this.selectMode = selectMode;
    }

    public void setTermAuto(Boolean termAuto) {
        this.termAuto = termAuto;
    }

    public void setTerm(Integer term) {
        this.term = term;
    }

    public void setTermMode(Integer termMode) {
        this.termMode = termMode;
    }

    public void setTypeOfApprove(Integer typeOfApprove) {
        this.typeOfApprove = typeOfApprove;
    }

    public void setPassWeight(Integer passWeight) {
        this.passWeight = passWeight;
    }

    public void setRejectStrategy(Integer rejectStrategy) {
        this.rejectStrategy = rejectStrategy;
    }

    public void setRejectStart(Integer rejectStart) {
        this.rejectStart = rejectStart;
    }

    public void setConditionNodes(List<ConditionNode> conditionNodes) {
        this.conditionNodes = conditionNodes;
    }

    public void setParallelNodes(List<NodeModel> parallelNodes) {
        this.parallelNodes = parallelNodes;
    }

    public void setInclusiveNodes(List<ConditionNode> inclusiveNodes) {
        this.inclusiveNodes = inclusiveNodes;
    }

    public void setRouteNodes(List<ConditionNode> routeNodes) {
        this.routeNodes = routeNodes;
    }

    public void setRemind(Boolean remind) {
        this.remind = remind;
    }

    public void setAllowSelection(Boolean allowSelection) {
        this.allowSelection = allowSelection;
    }

    public void setAllowTransfer(Boolean allowTransfer) {
        this.allowTransfer = allowTransfer;
    }

    public void setAllowAppendNode(Boolean allowAppendNode) {
        this.allowAppendNode = allowAppendNode;
    }

    public void setAllowRollback(Boolean allowRollback) {
        this.allowRollback = allowRollback;
    }

    public void setApproveSelf(Integer approveSelf) {
        this.approveSelf = approveSelf;
    }

    public void setExtendConfig(Map<String, Object> extendConfig) {
        this.extendConfig = extendConfig;
    }

    public void setChildNode(NodeModel childNode) {
        this.childNode = childNode;
    }

    public void setParentNode(NodeModel parentNode) {
        this.parentNode = parentNode;
    }

    public void setTriggerType(String triggerType) {
        this.triggerType = triggerType;
    }

    public void setDelayType(String delayType) {
        this.delayType = delayType;
    }
}

