/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.bpm.engine.model;

import com.aizuda.bpm.engine.model.ConditionNode;
import com.aizuda.bpm.engine.model.NodeModel;
import java.io.Serializable;
import java.util.List;

public class ProcessModel
implements Serializable {
    private String name;
    private String key;
    private String instanceUrl;
    private NodeModel nodeConfig;

    public NodeModel getNode(String nodeKey) {
        return null == this.nodeConfig ? null : this.nodeConfig.getNode(nodeKey);
    }

    public void buildParentNode(NodeModel rootNode) {
        this.buildParentConditionNodes(rootNode, rootNode.getConditionNodes());
        List<NodeModel> parallelNodes = rootNode.getParallelNodes();
        if (null != parallelNodes) {
            for (NodeModel nodeModel : parallelNodes) {
                nodeModel.setParentNode(rootNode);
                this.buildParentNode(nodeModel);
            }
        }
        this.buildParentConditionNodes(rootNode, rootNode.getInclusiveNodes());
        NodeModel childNode = rootNode.getChildNode();
        if (null != childNode) {
            childNode.setParentNode(rootNode);
            this.buildParentNode(childNode);
        }
    }

    private void buildParentConditionNodes(NodeModel rootNode, List<ConditionNode> conditionNodes) {
        if (null != conditionNodes) {
            for (ConditionNode conditionNode : conditionNodes) {
                NodeModel conditionChildNode = conditionNode.getChildNode();
                if (null == conditionChildNode) continue;
                conditionChildNode.setParentNode(rootNode);
                this.buildParentNode(conditionChildNode);
            }
        }
    }

    public ProcessModel cleanParentNode() {
        return this.cleanParentNode(this.nodeConfig);
    }

    public ProcessModel cleanParentNode(NodeModel rootNode) {
        rootNode.setParentNode(null);
        this.cleanConditionParentNode(rootNode.getConditionNodes());
        List<NodeModel> parallelNodes = rootNode.getParallelNodes();
        if (null != parallelNodes) {
            for (NodeModel nodeModel : parallelNodes) {
                this.cleanParentNode(nodeModel);
            }
        }
        this.cleanConditionParentNode(rootNode.getInclusiveNodes());
        NodeModel childNode = rootNode.getChildNode();
        if (null != childNode) {
            this.cleanParentNode(childNode);
        }
        return this;
    }

    protected void cleanConditionParentNode(List<ConditionNode> conditionNodes) {
        if (null != conditionNodes) {
            for (ConditionNode conditionNode : conditionNodes) {
                NodeModel conditionChildNode = conditionNode.getChildNode();
                if (null == conditionChildNode) continue;
                this.cleanParentNode(conditionChildNode);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.key;
    }

    public String getInstanceUrl() {
        return this.instanceUrl;
    }

    public NodeModel getNodeConfig() {
        return this.nodeConfig;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setInstanceUrl(String instanceUrl) {
        this.instanceUrl = instanceUrl;
    }

    public void setNodeConfig(NodeModel nodeConfig) {
        this.nodeConfig = nodeConfig;
    }
}

