/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.nlp.understanding;

import com.alibaba.dashscope.api.SynchronizeHalfDuplexApi;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.common.Function;
import com.alibaba.dashscope.common.OutputMode;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.common.Task;
import com.alibaba.dashscope.common.TaskGroup;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.nlp.understanding.UnderstandingParam;
import com.alibaba.dashscope.nlp.understanding.UnderstandingResult;
import com.alibaba.dashscope.protocol.ApiServiceOption;
import com.alibaba.dashscope.protocol.HttpMethod;
import com.alibaba.dashscope.protocol.Protocol;
import com.alibaba.dashscope.protocol.StreamingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Understanding {
    private static final Logger log = LoggerFactory.getLogger(Understanding.class);
    private final SynchronizeHalfDuplexApi<UnderstandingParam> syncApi;
    private final ApiServiceOption serviceOption = this.defaultApiServiceOption();

    private ApiServiceOption defaultApiServiceOption() {
        return ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.HTTP)).httpMethod(HttpMethod.POST)).streamingMode(StreamingMode.OUT)).outputMode(OutputMode.ACCUMULATE)).taskGroup(TaskGroup.NLP.getValue())).task(Task.NLU.getValue())).function(Function.UNDERSTANDING.getValue())).isSSE(false)).streamingMode(StreamingMode.NONE)).build();
    }

    public Understanding() {
        this.syncApi = new SynchronizeHalfDuplexApi(this.serviceOption);
    }

    public Understanding(String protocol) {
        this.serviceOption.setProtocol(Protocol.of(protocol));
        this.syncApi = new SynchronizeHalfDuplexApi(this.serviceOption);
    }

    public Understanding(String protocol, String baseUrl) {
        this.serviceOption.setProtocol(Protocol.of(protocol));
        if (Protocol.HTTP.getValue().equals(protocol)) {
            this.serviceOption.setBaseHttpUrl(baseUrl);
        } else {
            this.serviceOption.setBaseWebSocketUrl(baseUrl);
        }
        this.syncApi = new SynchronizeHalfDuplexApi(this.serviceOption);
    }

    public UnderstandingResult call(UnderstandingParam param) throws ApiException, NoApiKeyException, InputRequiredException {
        param.validate();
        return UnderstandingResult.fromDashScopeResult(this.syncApi.call(param));
    }

    public void call(UnderstandingParam param, final ResultCallback<UnderstandingResult> callback) throws ApiException, NoApiKeyException, InputRequiredException {
        param.validate();
        this.syncApi.call(param, new ResultCallback<DashScopeResult>(){

            @Override
            public void onEvent(DashScopeResult message) {
                callback.onEvent(UnderstandingResult.fromDashScopeResult(message));
            }

            @Override
            public void onComplete() {
                callback.onComplete();
            }

            @Override
            public void onError(Exception e) {
                callback.onError(e);
            }
        });
    }

    public static class Models {
        public static final String OPENNLU_V1 = "opennlu-v1";
    }
}

