/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.doris.visitor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLPivot;
import com.alibaba.druid.sql.ast.SQLUnpivot;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLTableSampling;
import com.alibaba.druid.sql.dialect.doris.ast.DorisExprTableSource;
import com.alibaba.druid.sql.dialect.doris.visitor.DorisASTVisitor;
import com.alibaba.druid.sql.dialect.starrocks.visitor.StarRocksOutputVisitor;
import java.util.List;

public class DorisOutputVisitor
extends StarRocksOutputVisitor
implements DorisASTVisitor {
    public DorisOutputVisitor(StringBuilder appender) {
        super(appender);
        this.dbType = DbType.doris;
    }

    public DorisOutputVisitor(StringBuilder appender, DbType dbType) {
        super(appender, dbType);
        dbType = DbType.doris;
    }

    public DorisOutputVisitor(StringBuilder appender, boolean parameterized) {
        super(appender, parameterized);
        this.dbType = DbType.doris;
    }

    @Override
    public void printSqlSetQuantifier(SQLSelectQueryBlock x) {
        int distinctOption = x.getDistionOption();
        if (1 == distinctOption) {
            this.print0(this.ucase ? "ALL " : "all ");
        } else if (2 == distinctOption) {
            this.print0(this.ucase ? "DISTINCT " : "distinct ");
        } else if (3 == distinctOption) {
            this.print0(this.ucase ? "UNIQUE " : "unique ");
        } else if (5 == distinctOption) {
            this.print0(this.ucase ? "ALL EXCEPT " : "all except ");
        }
    }

    @Override
    public boolean visit(DorisExprTableSource x) {
        SQLUnpivot unpivot;
        SQLPivot pivot;
        SQLTableSampling sampling;
        this.printTableSourceExpr(x.getExpr());
        if (!x.getPartitions().isEmpty()) {
            this.println();
            this.print(this.ucase ? "PARTITION(" : "partition(");
            this.printAndAccept(x.getPartitions(), ", ");
            this.print(")");
        }
        if (!x.getTablets().isEmpty()) {
            this.println();
            this.print(this.ucase ? "TABLET(" : "tablet(");
            this.printAndAccept(x.getTablets(), ", ");
            this.print(")");
        }
        if ((sampling = x.getSampling()) != null) {
            this.println();
            sampling.accept(this);
        }
        if (x.getRepeatable() != null) {
            this.println();
            this.print0(this.ucase ? "REPEATABLE " : "repeatable ");
            x.getRepeatable().accept(this);
        }
        String alias = x.getAlias();
        List<SQLName> columns = x.getColumnsDirect();
        if (alias != null) {
            this.print(' ');
            if (columns != null && columns.size() > 0) {
                this.print0(this.ucase ? " AS " : " as ");
            } else if (x.isNeedAsTokenForAlias()) {
                this.print0(this.ucase ? "AS " : "as ");
            }
            this.print0(alias);
        }
        if (columns != null && columns.size() > 0) {
            this.print(" (");
            this.printAndAccept(columns, ", ");
            this.print(')');
        }
        if ((pivot = x.getPivot()) != null) {
            this.println();
            pivot.accept(this);
        }
        if ((unpivot = x.getUnpivot()) != null) {
            this.println();
            unpivot.accept(this);
        }
        if (this.isPrettyFormat() && x.hasAfterComment()) {
            this.print(' ');
            this.printlnComment(x.getAfterCommentsDirect());
        }
        return false;
    }

    @Override
    public boolean visit(SQLTableSampling x) {
        SQLExpr size;
        SQLExpr rows;
        this.print0(this.ucase ? "TABLESAMPLE" : "tablesample");
        this.print('(');
        SQLExpr percent = x.getPercent();
        if (percent != null) {
            percent.accept(this);
            this.print0(this.ucase ? " PERCENT" : " percent");
        }
        if ((rows = x.getRows()) != null) {
            rows.accept(this);
            this.print0(this.ucase ? " ROWS" : " rows");
        }
        if ((size = x.getByteLength()) != null) {
            size.accept(this);
        }
        this.print(')');
        return false;
    }

    @Override
    public void printInsertOverWrite(SQLInsertStatement x) {
        this.print0(this.ucase ? "INSERT OVERWRITE TABLE " : "insert overwrite table ");
    }
}

