/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront_2012_03_15.model;

import com.amazonaws.services.cloudfront_2012_03_15.model.InvalidationSummary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvalidationList {
    private String marker;
    private String nextMarker;
    private Integer maxItems;
    private Boolean isTruncated;
    private List<InvalidationSummary> invalidationSummaries;

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public InvalidationList withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public void setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
    }

    public InvalidationList withNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
    }

    public InvalidationList withMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
        return this;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public void setIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
    }

    public InvalidationList withIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
        return this;
    }

    public Boolean getIsTruncated() {
        return this.isTruncated;
    }

    public List<InvalidationSummary> getInvalidationSummaries() {
        if (this.invalidationSummaries == null) {
            this.invalidationSummaries = new ArrayList<InvalidationSummary>();
        }
        return this.invalidationSummaries;
    }

    public void setInvalidationSummaries(Collection<InvalidationSummary> invalidationSummaries) {
        if (invalidationSummaries == null) {
            this.invalidationSummaries = null;
            return;
        }
        ArrayList<InvalidationSummary> invalidationSummariesCopy = new ArrayList<InvalidationSummary>(invalidationSummaries.size());
        invalidationSummariesCopy.addAll(invalidationSummaries);
        this.invalidationSummaries = invalidationSummariesCopy;
    }

    public InvalidationList withInvalidationSummaries(InvalidationSummary ... invalidationSummaries) {
        if (this.getInvalidationSummaries() == null) {
            this.setInvalidationSummaries(new ArrayList<InvalidationSummary>(invalidationSummaries.length));
        }
        for (InvalidationSummary value : invalidationSummaries) {
            this.getInvalidationSummaries().add(value);
        }
        return this;
    }

    public InvalidationList withInvalidationSummaries(Collection<InvalidationSummary> invalidationSummaries) {
        if (invalidationSummaries == null) {
            this.invalidationSummaries = null;
        } else {
            ArrayList<InvalidationSummary> invalidationSummariesCopy = new ArrayList<InvalidationSummary>(invalidationSummaries.size());
            invalidationSummariesCopy.addAll(invalidationSummaries);
            this.invalidationSummaries = invalidationSummariesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker != null) {
            sb.append("Marker: " + this.marker + ", ");
        }
        if (this.nextMarker != null) {
            sb.append("NextMarker: " + this.nextMarker + ", ");
        }
        if (this.maxItems != null) {
            sb.append("MaxItems: " + this.maxItems + ", ");
        }
        if (this.isTruncated != null) {
            sb.append("IsTruncated: " + this.isTruncated + ", ");
        }
        if (this.invalidationSummaries != null) {
            sb.append("InvalidationSummaries: " + this.invalidationSummaries + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.getNextMarker() == null ? 0 : this.getNextMarker().hashCode());
        hashCode = 31 * hashCode + (this.getMaxItems() == null ? 0 : this.getMaxItems().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.getInvalidationSummaries() == null ? 0 : this.getInvalidationSummaries().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvalidationList)) {
            return false;
        }
        InvalidationList other = (InvalidationList)obj;
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.getNextMarker() == null ^ this.getNextMarker() == null) {
            return false;
        }
        if (other.getNextMarker() != null && !other.getNextMarker().equals(this.getNextMarker())) {
            return false;
        }
        if (other.getMaxItems() == null ^ this.getMaxItems() == null) {
            return false;
        }
        if (other.getMaxItems() != null && !other.getMaxItems().equals(this.getMaxItems())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.getInvalidationSummaries() == null ^ this.getInvalidationSummaries() == null) {
            return false;
        }
        return other.getInvalidationSummaries() == null || other.getInvalidationSummaries().equals(this.getInvalidationSummaries());
    }
}

