/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.junitextensions;

import com.azure.core.test.TestMode;
import com.azure.core.test.annotation.LiveOnly;
import com.azure.core.test.implementation.TestingHelpers;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class LiveOnlyExtension
implements ExecutionCondition {
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        LiveOnly liveOnly = AnnotationSupport.findAnnotation((Optional)context.getElement(), LiveOnly.class).orElse(null);
        if (liveOnly != null) {
            TestMode testMode = TestingHelpers.getTestMode();
            return testMode != TestMode.LIVE ? ConditionEvaluationResult.disabled((String)("LiveOnly annotation set and test ignored in " + (Object)((Object)testMode))) : ConditionEvaluationResult.enabled((String)("LiveOnly annotation set and test enabled in " + (Object)((Object)testMode)));
        }
        return ConditionEvaluationResult.enabled((String)"LiveOnly annotation not set.");
    }
}

