/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.models;

import com.azure.core.exception.UnexpectedLengthException;
import com.azure.core.test.implementation.TestingHelpers;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.net.UnknownHostException;

public class NetworkCallError
implements JsonSerializable<NetworkCallError> {
    private String className;
    private String errorMessage;
    private Throwable throwable;

    public NetworkCallError() {
    }

    public NetworkCallError(Throwable throwable) {
        this.throwable = throwable;
        this.className = throwable.getClass().getName();
        this.errorMessage = throwable.getMessage();
    }

    public Throwable get() {
        switch (this.className) {
            case "java.lang.NullPointerException": {
                return new NullPointerException(this.errorMessage);
            }
            case "java.lang.IndexOutOfBoundsException": {
                return new IndexOutOfBoundsException(this.errorMessage);
            }
            case "java.net.UnknownHostException": {
                return new UnknownHostException(this.errorMessage);
            }
            case "com.azure.core.exception.UnexpectedLengthException": {
                return new UnexpectedLengthException(this.errorMessage, 0L, 0L);
            }
        }
        return this.throwable;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeStringField("ClassName", this.className).writeStringField("ErrorMessage", this.errorMessage).writeEndObject();
    }

    public static NetworkCallError fromJson(JsonReader jsonReader) throws IOException {
        return TestingHelpers.readObject(jsonReader, NetworkCallError::new, (callError, fieldName, reader) -> {
            if ("ClassName".equals(fieldName)) {
                callError.className = reader.getString();
            } else if ("ErrorMessage".equals(fieldName)) {
                callError.errorMessage = reader.getString();
            } else {
                reader.skipChildren();
            }
        });
    }
}

