/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ConfigDataSource {
    MYSQL("mysql", "show tables", "show table status", "show full fields from %s", "NAME", "COMMENT", "FIELD", "TYPE", "COMMENT", "KEY"),
    ORACLE("oracle", "SELECT * FROM USER_TABLES", "SELECT * FROM USER_TAB_COMMENTS", "SELECT A.COLUMN_NAME, A.DATA_TYPE, B.COMMENTS  FROM USER_TAB_COLUMNS A, USER_COL_COMMENTS B WHERE A.TABLE_NAME=B.TABLE_NAME AND A.COLUMN_NAME = B.COLUMN_NAME AND A.TABLE_NAME='%s'", "TABLE_NAME", "COMMENTS", "COLUMN_NAME", "DATA_TYPE", "COMMENTS", "COLUMN_NAME");

    private final String db;
    private final String tablesSql;
    private final String tableCommentsSql;
    private final String tableFieldsSql;
    private final String tableName;
    private final String tableComment;
    private final String fieldName;
    private final String fieldType;
    private final String fieldComment;
    private final String fieldKey;

    private ConfigDataSource(String db, String tablesSql, String tableCommentsSql, String tableFieldsSql, String tableName, String tableComment, String fieldName, String fieldType, String fieldComment, String fieldKey) {
        this.db = db;
        this.tablesSql = tablesSql;
        this.tableCommentsSql = tableCommentsSql;
        this.tableFieldsSql = tableFieldsSql;
        this.tableName = tableName;
        this.tableComment = tableComment;
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.fieldComment = fieldComment;
        this.fieldKey = fieldKey;
    }

    public static ConfigDataSource getConfigDataSource(String dbType) {
        for (ConfigDataSource dt : ConfigDataSource.values()) {
            if (!dt.getDb().equals(dbType)) continue;
            return dt;
        }
        return MYSQL;
    }

    public String getDb() {
        return this.db;
    }

    public String getTablesSql() {
        return this.tablesSql;
    }

    public String getTableCommentsSql() {
        return this.tableCommentsSql;
    }

    public String getTableFieldsSql() {
        return this.tableFieldsSql;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableComment() {
        return this.tableComment;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public String getFieldComment() {
        return this.fieldComment;
    }

    public String getFieldKey() {
        return this.fieldKey;
    }
}

