/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.boot;

import com.frameworkset.common.poolman.ConfigSQLExecutor;
import com.frameworkset.common.poolman.util.DBConf;
import com.frameworkset.common.poolman.util.SQLManager;
import com.frameworkset.util.SimpleStringUtil;
import java.util.Map;
import org.frameworkset.spi.assemble.GetProperties;
import org.frameworkset.spi.assemble.PropertiesContainer;
import org.frameworkset.spi.assemble.PropertiesInterceptor;
import org.frameworkset.spi.assemble.PropertyContext;
import org.frameworkset.spi.boot.BBossProperties;
import org.frameworkset.spi.boot.BaseBBossProperties;
import org.frameworkset.spi.remote.http.ClientConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BBossStarter
extends BaseBBossProperties {
    @Autowired
    private BBossProperties properties;
    private static final Logger log = LoggerFactory.getLogger(BBossStarter.class);

    public void start() {
        this.initHttp();
        this.initDs();
    }

    private void initDs() {
        String temp = null;
        temp = this.propertiesInterceptor == null ? this.properties.getPropertiesInterceptor() : this.propertiesInterceptor;
        if (temp != null && !temp.trim().equals("")) {
            temp = temp.trim();
        }
        if (this.getDb() == null) {
            if (this.properties.getDb() != null && this.properties.getDb().getUrl() != null) {
                if (temp != null && !temp.equals("")) {
                    try {
                        Class<?> clz = Class.forName(temp);
                        PropertiesInterceptor propertiesInterceptor = (PropertiesInterceptor)clz.newInstance();
                        PropertyContext propertyContext = new PropertyContext();
                        propertyContext.setValue((Object)this.properties.getDb());
                        propertiesInterceptor.convert(propertyContext);
                    }
                    catch (Exception e) {
                        log.error("Init Ds " + temp, (Throwable)e);
                    }
                }
                this.initDS(this.properties.getDb());
            }
        } else if (this.getDb().getUrl() != null) {
            if (temp != null && !temp.equals("")) {
                try {
                    Class<?> clz = Class.forName(temp);
                    PropertiesInterceptor propertiesInterceptor = (PropertiesInterceptor)clz.newInstance();
                    PropertyContext propertyContext = new PropertyContext();
                    propertyContext.setValue((Object)this.getDb());
                    propertiesInterceptor.convert(propertyContext);
                }
                catch (Exception e) {
                    log.error("Init Ds " + temp, (Throwable)e);
                }
            }
            this.initDS(this.getDb());
        }
    }

    private PropertiesContainer initHttp() {
        PropertiesContainer propertiesContainer = null;
        if (this.getHttp() == null) {
            if (this.properties.getHttp() != null) {
                String[] stringArray;
                Map properties = this.properties.buildProperties();
                propertiesContainer = new PropertiesContainer();
                propertiesContainer.addAll(properties);
                if (this.properties.getHttp().getName() != null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = this.properties.getHttp().getName();
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = "default";
                }
                String[] httpNames = stringArray;
                ClientConfiguration.bootClientConfiguations((String[])httpNames, (GetProperties)propertiesContainer);
            }
        } else {
            String[] stringArray;
            Map properties = this.buildProperties();
            propertiesContainer = new PropertiesContainer();
            propertiesContainer.addAll(properties);
            if (this.getHttp().getName() != null) {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = this.getHttp().getName();
            } else {
                String[] stringArray5 = new String[1];
                stringArray = stringArray5;
                stringArray5[0] = "default";
            }
            String[] httpNames = stringArray;
            ClientConfiguration.bootClientConfiguations((String[])httpNames, (GetProperties)propertiesContainer);
        }
        return propertiesContainer;
    }

    private void initDS(BaseBBossProperties.Db db) {
        DBConf temConf = new DBConf();
        temConf.setPoolname(db.getName());
        temConf.setDriver(db.getDriver());
        temConf.setJdbcurl(db.getUrl());
        temConf.setUsername(db.getUser());
        temConf.setPassword(db.getPassword());
        temConf.setReadOnly(null);
        temConf.setTxIsolationLevel(null);
        temConf.setValidationQuery(db.getValidateSQL());
        temConf.setJndiName(db.getName() + "_jndi");
        temConf.setInitialConnections(db.getInitSize() != null ? Integer.parseInt(db.getInitSize()) : 10);
        temConf.setMinimumSize(db.getMinIdleSize() != null ? Integer.parseInt(db.getMinIdleSize()) : 10);
        temConf.setMaximumSize(db.getMaxSize() != null ? Integer.parseInt(db.getMaxSize()) : 50);
        temConf.setUsepool(db.getUsePool() != null ? Boolean.parseBoolean(db.getUsePool()) : true);
        temConf.setExternal(false);
        temConf.setExternaljndiName(null);
        temConf.setShowsql(db.getShowSql() != null ? Boolean.parseBoolean(db.getShowSql()) : true);
        temConf.setEncryptdbinfo(false);
        temConf.setQueryfetchsize(db.getJdbcFetchSize() != null ? Integer.valueOf(Integer.parseInt(db.getJdbcFetchSize())) : null);
        temConf.setDbAdaptor(db.getDbAdaptor());
        temConf.setDbtype(db.getDbtype());
        temConf.setBalance(db.getBalance());
        temConf.setEnableBalance(SimpleStringUtil.isNotEmpty((String)db.getEnableBalance()) && db.getEnableBalance().equals("true"));
        boolean ff = db.getColumnLableUpperCase() == null ? true : db.getColumnLableUpperCase().equals("true");
        temConf.setColumnLableUpperCase(ff);
        ff = db.getEnableShutdownHook() == null ? true : db.getEnableShutdownHook().equals("true");
        temConf.setEnableShutdownHook(ff);
        SQLManager.startPool((DBConf)temConf);
    }

    public ConfigSQLExecutor getConfigRestClient(String configFile) {
        ConfigSQLExecutor configSQLExecutor = new ConfigSQLExecutor(configFile);
        return configSQLExecutor;
    }
}

