/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.jdbc.config;

import com.centit.framework.core.dao.ExtendedQueryPool;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.QueryLogUtils;
import com.centit.support.security.SecurityOptUtils;
import com.zaxxer.hikari.HikariDataSource;
import java.io.IOException;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;
import org.springframework.dao.annotation.PersistenceExceptionTranslationPostProcessor;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@EnableTransactionManagement(proxyTargetClass=true)
public class JdbcConfig
implements EnvironmentAware {
    protected Logger logger = LoggerFactory.getLogger(JdbcConfig.class);
    protected Environment env;

    public void setEnvironment(@Autowired Environment environment) {
        if (environment != null) {
            this.env = environment;
        }
    }

    @Bean(destroyMethod="close")
    public DataSource dataSource() {
        HikariDataSource ds = new HikariDataSource();
        ds.setDriverClassName(this.env.getProperty("jdbc.driver"));
        ds.setUsername(SecurityOptUtils.decodeSecurityString((String)this.env.getProperty("jdbc.user")));
        ds.setPassword(SecurityOptUtils.decodeSecurityString((String)this.env.getProperty("jdbc.password")));
        ds.setJdbcUrl(this.env.getProperty("jdbc.url"));
        ds.setMaxLifetime((long)NumberBaseOpt.castObjectToInteger((Object)this.env.getProperty("jdbc.maxLifeTime"), (Integer)18000).intValue());
        ds.setMaximumPoolSize(NumberBaseOpt.castObjectToInteger((Object)this.env.getProperty("jdbc.maxActive"), (Integer)100).intValue());
        ds.setConnectionTimeout((long)NumberBaseOpt.castObjectToInteger((Object)this.env.getProperty("jdbc.maxWait"), (Integer)5000).intValue());
        ds.setMinimumIdle(NumberBaseOpt.castObjectToInteger((Object)this.env.getProperty("jdbc.minIdle"), (Integer)5).intValue());
        ds.setValidationTimeout((long)NumberBaseOpt.castObjectToInteger((Object)this.env.getProperty("jdbc.validationTimeout"), (Integer)60000).intValue());
        DBType dbType = DBType.mapDBType((String)this.env.getProperty("jdbc.url"));
        String validationQuery = this.env.getProperty("jdbc.validationQuery");
        boolean testWhileIdle = BooleanBaseOpt.castObjectToBoolean((Object)this.env.getProperty("jdbc.testWhileIdle"), (Boolean)true);
        if (StringUtils.isBlank((CharSequence)validationQuery)) {
            validationQuery = DBType.getDBValidationQuery((DBType)dbType);
        }
        if (testWhileIdle && StringUtils.isNotBlank((CharSequence)validationQuery)) {
            ds.setConnectionTestQuery(validationQuery);
        }
        if (StringRegularOpt.isTrue((String)this.env.getProperty("jdbc.show.sql"))) {
            QueryLogUtils.setJdbcShowSql((boolean)true);
        }
        try {
            ExtendedQueryPool.loadResourceExtendedSqlMap((DBType)dbType);
        }
        catch (DocumentException e) {
            this.logger.error(e.getMessage());
        }
        try {
            ExtendedQueryPool.loadExtendedSqlMaps((String)(this.env.getProperty("app.home", ".") + "/sqlscript"), (DBType)dbType);
        }
        catch (IOException | DocumentException e) {
            this.logger.error(e.getMessage());
        }
        return ds;
    }

    @Lazy
    @Bean
    public DataSourceTransactionManager transactionManager(@Autowired DataSource dataSource) {
        DataSourceTransactionManager transactionManager = new DataSourceTransactionManager();
        transactionManager.setDataSource(dataSource);
        return transactionManager;
    }

    @Lazy
    @Bean
    public PersistenceExceptionTranslationPostProcessor persistenceExceptionTranslationPostProcessor() {
        return new PersistenceExceptionTranslationPostProcessor();
    }
}

