/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.jdbc.dao;

import com.alibaba.fastjson2.JSONArray;
import com.centit.framework.core.po.EntityWithDeleteTag;
import com.centit.framework.core.po.EntityWithVersionTag;
import com.centit.framework.jdbc.dao.DataFilter;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.common.LeftRightPair;
import com.centit.support.common.ObjectException;
import com.centit.support.compiler.Lexer;
import com.centit.support.database.jsonmaptable.GeneralJsonObjectDao;
import com.centit.support.database.jsonmaptable.JsonObjectDao;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.SimpleTableReference;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.database.orm.JpaMetadata;
import com.centit.support.database.orm.OrmDaoUtils;
import com.centit.support.database.orm.OrmUtils;
import com.centit.support.database.orm.TableMapInfo;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.DatabaseAccess;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryAndParams;
import com.centit.support.database.utils.QueryUtils;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;

public abstract class BaseDaoImpl<T extends Serializable, PK extends Serializable> {
    protected static Logger logger = LoggerFactory.getLogger(BaseDaoImpl.class);
    private Class<?> poClass = null;
    private Class<?> pkClass = null;
    protected JdbcTemplate jdbcTemplate;
    private static final int DEFAULT_CASCADE_DEPTH = 3;
    private Map<String, DataFilter> insideFieldFilter = null;

    @Resource
    public void setDataSource(DataSource dataSource) {
        if (this.jdbcTemplate == null || dataSource != this.jdbcTemplate.getDataSource()) {
            this.jdbcTemplate = new JdbcTemplate(dataSource);
        }
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public DataSource getDataSource() {
        return this.jdbcTemplate != null ? this.jdbcTemplate.getDataSource() : null;
    }

    @Deprecated
    public Connection getConnection() throws CannotGetJdbcConnectionException {
        return DataSourceUtils.getConnection((DataSource)this.getDataSource());
    }

    public DBType getDBtype() {
        return (DBType)this.jdbcTemplate.execute(conn -> DBType.mapDBType((Connection)conn));
    }

    @Deprecated
    public void releaseConnection(Connection con) {
        DataSourceUtils.releaseConnection((Connection)con, (DataSource)this.getDataSource());
    }

    private void fetchTypeParams() {
        ParameterizedType genType = (ParameterizedType)this.getClass().getGenericSuperclass();
        Type[] params = genType.getActualTypeArguments();
        this.poClass = (Class)params[0];
        this.pkClass = (Class)params[1];
    }

    public Class<?> getPoClass() {
        if (this.poClass == null) {
            this.fetchTypeParams();
        }
        return this.poClass;
    }

    public Class<?> getPkClass() {
        if (this.pkClass == null) {
            this.fetchTypeParams();
        }
        return this.pkClass;
    }

    public String encapsulateFilterToSql(String fieldsSql, String filterQuery, String tableAlias, String orderBySql, boolean withExtFilter) {
        boolean addAlias = StringUtils.isNotBlank((CharSequence)tableAlias);
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        StringBuilder sqlBuilder = new StringBuilder("select ");
        sqlBuilder.append(fieldsSql).append(" from ").append(mapInfo.getTableName());
        if (addAlias) {
            sqlBuilder.append(" ").append(tableAlias);
        }
        sqlBuilder.append(" where 1=1 ");
        if (withExtFilter) {
            sqlBuilder.append("{").append(mapInfo.getTableName());
            if (addAlias) {
                sqlBuilder.append(" ").append(tableAlias);
            }
            sqlBuilder.append(" }");
        }
        if (StringUtils.isNotBlank((CharSequence)filterQuery)) {
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)Lexer.getFirstWord((String)filterQuery), (CharSequence[])new CharSequence[]{"[", "and", "or"})) {
                sqlBuilder.append(filterQuery);
            } else {
                sqlBuilder.append(" and ").append(filterQuery);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)orderBySql)) {
            sqlBuilder.append(" order by ").append(orderBySql);
        }
        return sqlBuilder.toString();
    }

    public String encapsulateFilterToFields(Collection<String> fields, String filterQuery, String tableAlias, boolean withExtFilter) {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        String fieldsSql = fields != null && fields.size() > 0 ? GeneralJsonObjectDao.buildPartFieldSql((TableInfo)mapInfo, fields, (String)tableAlias, (boolean)true) : GeneralJsonObjectDao.buildFieldSql((TableInfo)mapInfo, (String)tableAlias, (int)1);
        return this.encapsulateFilterToSql(fieldsSql, filterQuery, tableAlias, mapInfo.getOrderBy(), withExtFilter);
    }

    public Map<String, String> getFilterField() {
        return null;
    }

    public Map<String, DataFilter> obtainInsideFilters(TableMapInfo mapInfo) {
        if (this.insideFieldFilter == null) {
            this.insideFieldFilter = new HashMap<String, DataFilter>();
            Map<String, String> filters = this.getFilterField();
            if (filters != null && filters.size() > 0) {
                for (Map.Entry<String, String> ent : filters.entrySet()) {
                    SimpleTableField col;
                    DataFilter dataFilter = new DataFilter(ent.getKey(), ent.getValue());
                    if (dataFilter.getFilterSql().equalsIgnoreCase("EQUAL")) {
                        col = mapInfo.findFieldByName(dataFilter.getFormule());
                        if (col == null) continue;
                        dataFilter.setFilterSql(col.getColumnName() + " = :" + dataFilter.getValueName());
                        this.insideFieldFilter.put(dataFilter.getFormule(), dataFilter);
                        continue;
                    }
                    if (dataFilter.getFilterSql().equalsIgnoreCase("LIKE")) {
                        col = mapInfo.findFieldByName(dataFilter.getFormule());
                        if (col == null) continue;
                        dataFilter.setFilterSql(col.getColumnName() + " like :" + dataFilter.getValueName());
                        if (StringUtils.isBlank((CharSequence)dataFilter.getPretreatment())) {
                            dataFilter.setPretreatment("LIKE");
                        }
                        this.insideFieldFilter.put(dataFilter.getFormule(), dataFilter);
                        continue;
                    }
                    if (dataFilter.getFilterSql().equalsIgnoreCase("IN")) {
                        col = mapInfo.findFieldByName(dataFilter.getFormule());
                        if (col == null) continue;
                        dataFilter.setFilterSql(col.getColumnName() + " in (:" + dataFilter.getValueName() + ")");
                        this.insideFieldFilter.put(dataFilter.getFormule(), dataFilter);
                        continue;
                    }
                    dataFilter.setFilterSql(JpaMetadata.translateSqlPropertyToColumn((TableMapInfo)mapInfo, (String)dataFilter.getFilterSql(), null));
                    this.insideFieldFilter.put(dataFilter.getFormule(), dataFilter);
                }
            }
        }
        return this.insideFieldFilter;
    }

    public String fetchSelfOrderSql(Map<String, Object> filterMap) {
        Map<String, DataFilter> filterList;
        DataFilter df;
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        String selfOrderBy = GeneralJsonObjectDao.fetchSelfOrderSql((TableInfo)mapInfo, filterMap);
        if (StringUtils.equals((CharSequence)selfOrderBy, (CharSequence)mapInfo.getOrderBy()) && (df = (filterList = this.obtainInsideFilters(mapInfo)).get("ORDER_BY")) != null) {
            return df.getFilterSql();
        }
        return selfOrderBy;
    }

    public LeftRightPair<QueryAndNamedParams, TableField[]> buildQueryByParamsWithFields(Map<String, Object> filterMap, Collection<String> fields, Collection<String> extentFilters, QueryUtils.IFilterTranslater powerTranslater) {
        String selfOrderBy = this.fetchSelfOrderSql(filterMap);
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        Pair q = fields != null && fields.size() > 0 ? GeneralJsonObjectDao.buildPartFieldSqlWithFields((TableInfo)mapInfo, fields, null, (boolean)true) : GeneralJsonObjectDao.buildFieldSqlWithFields((TableInfo)mapInfo, null, (boolean)true);
        QueryAndNamedParams queryAndParams = this.buildFilterByParams(filterMap, extentFilters, powerTranslater);
        String querySql = this.encapsulateFilterToSql((String)q.getLeft(), queryAndParams.getQuery(), null, selfOrderBy, false);
        queryAndParams.setQuery(querySql);
        return new LeftRightPair((Object)queryAndParams, q.getRight());
    }

    protected QueryAndNamedParams buildQueryByParams(Map<String, Object> filterMap, Collection<String> fields, Collection<String> extentFilters, QueryUtils.IFilterTranslater powerTranslater) {
        String selfOrderBy = this.fetchSelfOrderSql(filterMap);
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        String sql = fields != null && fields.size() > 0 ? GeneralJsonObjectDao.buildPartFieldSql((TableInfo)mapInfo, fields, null, (boolean)true) : GeneralJsonObjectDao.buildFieldSql((TableInfo)mapInfo, null, (int)1);
        QueryAndNamedParams queryAndParams = this.buildFilterByParams(filterMap, extentFilters, powerTranslater);
        String querySql = this.encapsulateFilterToSql(sql, queryAndParams.getQuery(), null, selfOrderBy, false);
        queryAndParams.setQuery(querySql);
        return queryAndParams;
    }

    protected QueryAndNamedParams buildFilterByParams(Map<String, Object> filterMap, Collection<String> extentFilters, QueryUtils.IFilterTranslater powerTranslater) {
        Map<String, Object> leftFilterMap;
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        HashMap<String, Object> queryParams = new HashMap<String, Object>(filterMap.size() + 4);
        Map<String, DataFilter> filterList = this.obtainInsideFilters(mapInfo);
        HashMap<String, LeftRightPair> filterGroup = new HashMap<String, LeftRightPair>();
        if (!filterList.isEmpty()) {
            leftFilterMap = new HashMap<String, Object>(filterMap.size() + 4);
            for (Map.Entry<String, Object> ent : filterMap.entrySet()) {
                if (ent.getValue() == null) continue;
                DataFilter df = filterList.get(ent.getKey());
                if (df != null) {
                    StringBuilder currentBuild;
                    LeftRightPair groupFilter;
                    boolean haveGroupSign;
                    String plCol = df.getValueName();
                    String groupName = "nog";
                    boolean bl = haveGroupSign = !(plCol.length() <= 3 || plCol.charAt(0) != 'g' && plCol.charAt(0) != 'G' || plCol.charAt(1) < '0' || plCol.charAt(1) > '9' || plCol.charAt(2) != '_' && plCol.charAt(3) != '_');
                    if (haveGroupSign) {
                        groupName = "g" + plCol.charAt(1);
                    }
                    if ((groupFilter = (LeftRightPair)filterGroup.get(groupName)) == null) {
                        currentBuild = new StringBuilder();
                        groupFilter = new LeftRightPair((Object)1, (Object)currentBuild);
                        filterGroup.put(groupName, groupFilter);
                    } else {
                        groupFilter.setLeft((Object)((Integer)groupFilter.getLeft() + 1));
                        currentBuild = (StringBuilder)groupFilter.getRight();
                        currentBuild.append(haveGroupSign ? " or " : " and ");
                    }
                    queryParams.put(df.getValueName(), QueryUtils.pretreatParameter((String)df.getPretreatment(), (Object)ent.getValue()));
                    currentBuild.append(df.getFilterSql());
                    continue;
                }
                leftFilterMap.put(ent.getKey(), ent.getValue());
            }
        } else {
            leftFilterMap = filterMap;
        }
        if (leftFilterMap.size() > 0) {
            GeneralJsonObjectDao.buildFilterSqlPieces((TableInfo)mapInfo, null, leftFilterMap, filterGroup);
            queryParams.putAll(leftFilterMap);
        }
        StringBuilder filterQuery = new StringBuilder();
        if (extentFilters != null && extentFilters.size() > 0) {
            QueryUtils.IFilterTranslater translater = powerTranslater != null ? powerTranslater : new QueryUtils.SimpleFilterTranslater(filterMap);
            HashMap<String, String> tableAlias = new HashMap<String, String>(2);
            tableAlias.put(mapInfo.getTableName(), "");
            translater.setTableAlias(tableAlias);
            QueryAndNamedParams powerFilter = QueryUtils.translateQueryFilter(extentFilters, (QueryUtils.IFilterTranslater)translater, (boolean)true);
            if (powerFilter != null && StringUtils.isNotBlank((CharSequence)powerFilter.getQuery())) {
                filterQuery.append(" and ").append(powerFilter.getQuery());
                queryParams.putAll(powerFilter.getParams());
            }
        }
        for (Map.Entry ent : filterGroup.entrySet()) {
            filterQuery.append(" and ");
            if ((Integer)((LeftRightPair)ent.getValue()).getLeft() > 1 && !"nog".equals(ent.getKey())) {
                filterQuery.append("(").append(((StringBuilder)((LeftRightPair)ent.getValue()).getRight()).toString()).append(")");
                continue;
            }
            filterQuery.append(((StringBuilder)((LeftRightPair)ent.getValue()).getRight()).toString());
        }
        return new QueryAndNamedParams(filterQuery.toString(), queryParams);
    }

    private void innerSaveNewObject(Object o) {
        EntityWithVersionTag ewvto;
        SimpleTableField field;
        Object obj;
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(o.getClass());
        if (o instanceof EntityWithVersionTag && (obj = mapInfo.getObjectFieldValue(o, field = mapInfo.findFieldByColumn((ewvto = (EntityWithVersionTag)o).obtainVersionProperty()))) == null) {
            mapInfo.setObjectFieldValue(o, field, ewvto.calcNextVersion());
        }
        if (mapInfo.hasGeneratedKeys()) {
            SimpleTableField filed;
            Map ids = (Map)this.jdbcTemplate.execute(conn -> OrmDaoUtils.saveNewObjectAndFetchGeneratedKeys((Connection)conn, (Object)o));
            if (ids != null && !ids.isEmpty() && (filed = mapInfo.fetchGeneratedKey()) != null) {
                mapInfo.setObjectFieldValue(o, filed, ids.values().iterator().next());
            }
        } else {
            this.jdbcTemplate.execute(conn -> OrmDaoUtils.saveNewObject((Connection)conn, (Object)o));
        }
    }

    public void saveNewObject(T o) {
        this.innerSaveNewObject(o);
    }

    private int deleteObjectWithVersion(Object o) {
        return (Integer)this.jdbcTemplate.execute(conn -> {
            TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(o.getClass());
            GeneralJsonObjectDao sqlDialect = GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)mapInfo);
            EntityWithVersionTag ewvto = (EntityWithVersionTag)o;
            SimpleTableField field = mapInfo.findFieldByColumn(ewvto.obtainVersionProperty());
            Object oleVsersion = mapInfo.getObjectFieldValue(o, field);
            Map idMap = OrmUtils.fetchObjectDatabaseField((Object)o, (TableMapInfo)mapInfo);
            if (!GeneralJsonObjectDao.checkHasAllPkColumns((TableInfo)mapInfo, (Map)idMap)) {
                throw new SQLException("\u7f3a\u5c11\u4e3b\u952e\u5bf9\u5e94\u7684\u5c5e\u6027\u3002");
            }
            String sql = "delete from " + mapInfo.getTableName() + " where " + GeneralJsonObjectDao.buildFilterSqlByPk((TableInfo)mapInfo, null) + " and " + field.getColumnName() + " = :_oldVersion";
            idMap.put("_oldVersion", oleVsersion);
            return DatabaseAccess.doExecuteNamedSql((Connection)conn, (String)sql, (Map)idMap);
        });
    }

    private int innerDeleteObjectForce(Object o) {
        if (o instanceof EntityWithVersionTag) {
            return this.deleteObjectWithVersion(o);
        }
        if (o == null) {
            return 0;
        }
        return (Integer)this.jdbcTemplate.execute(conn -> OrmDaoUtils.deleteObject((Connection)conn, (Object)o));
    }

    public int deleteObjectForce(T o) {
        return this.innerDeleteObjectForce(o);
    }

    public int deleteObjectForceById(Object id) {
        if (id == null) {
            return 0;
        }
        return (Integer)this.jdbcTemplate.execute(conn -> OrmDaoUtils.deleteObjectById((Connection)conn, (Object)id, this.getPoClass()));
    }

    private int innerDeleteObject(Object o) {
        if (o instanceof EntityWithDeleteTag) {
            ((EntityWithDeleteTag)o).setDeleted(true);
            return this.innerUpdateObject(o);
        }
        return this.innerDeleteObjectForce(o);
    }

    public int deleteObject(T o) {
        return this.innerDeleteObject(o);
    }

    public int deleteObjectById(Object id) {
        T o = this.getObjectById(id);
        if (o != null) {
            return this.innerDeleteObject(o);
        }
        return 0;
    }

    private int updateObjectWithVersion(Object o, Collection<String> fields) {
        return (Integer)this.jdbcTemplate.execute(conn -> {
            TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(o.getClass());
            GeneralJsonObjectDao sqlDialect = GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)mapInfo);
            try {
                OrmUtils.prepareObjectForUpdate((Object)o, (TableMapInfo)mapInfo, (JsonObjectDao)sqlDialect);
            }
            catch (IOException e) {
                throw new ObjectException((Throwable)e);
            }
            EntityWithVersionTag ewvto = (EntityWithVersionTag)o;
            SimpleTableField field = mapInfo.findFieldByColumn(ewvto.obtainVersionProperty());
            Object oleVsersion = mapInfo.getObjectFieldValue(o, field);
            mapInfo.setObjectFieldValue(o, field, ewvto.calcNextVersion());
            Map objMap = OrmUtils.fetchObjectDatabaseField((Object)o, (TableMapInfo)mapInfo);
            if (!GeneralJsonObjectDao.checkHasAllPkColumns((TableInfo)mapInfo, (Map)objMap)) {
                throw new SQLException("\u7f3a\u5c11\u4e3b\u952e\u5bf9\u5e94\u7684\u5c5e\u6027\u3002");
            }
            String sql = GeneralJsonObjectDao.buildUpdateSql((TableInfo)mapInfo, fields == null ? objMap.keySet() : fields);
            if (sql == null) {
                return 0;
            }
            sql = sql + " where " + GeneralJsonObjectDao.buildFilterSqlByPk((TableInfo)mapInfo, null) + " and " + field.getColumnName() + " = :_oldVersion";
            objMap.put("_oldVersion", oleVsersion);
            return DatabaseAccess.doExecuteNamedSql((Connection)conn, (String)sql, (Map)objMap);
        });
    }

    private int innerUpdateObject(Object o) {
        if (o instanceof EntityWithVersionTag) {
            return this.updateObjectWithVersion(o, null);
        }
        return (Integer)this.jdbcTemplate.execute(conn -> OrmDaoUtils.updateObject((Connection)conn, (Object)o));
    }

    public int updateObject(T o) {
        return this.innerUpdateObject(o);
    }

    public int updateObject(Collection<String> fields, T object) throws ObjectException {
        if (object instanceof EntityWithVersionTag) {
            return this.updateObjectWithVersion(object, fields);
        }
        return (Integer)this.jdbcTemplate.execute(conn -> OrmDaoUtils.updateObject((Connection)conn, (Collection)fields, (Object)object));
    }

    public int updateObject(String[] fields, T object) throws ObjectException {
        if (object instanceof EntityWithVersionTag) {
            return this.updateObjectWithVersion(object, CollectionsOpt.arrayToList((Object[])fields));
        }
        return this.updateObject(CollectionsOpt.arrayToList((Object[])fields), object);
    }

    public int updateObjectWithNullField(T object, boolean includeLazy) throws ObjectException {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        List fields = includeLazy ? mapInfo.getAllFieldsName() : mapInfo.getFieldsNameWithoutLazy();
        return this.updateObject(fields, object);
    }

    public int updateObjectWithNullField(T object) throws ObjectException {
        return this.updateObjectWithNullField(object, false);
    }

    public int checkObjectExists(T object) {
        return (Integer)this.jdbcTemplate.execute(conn -> OrmDaoUtils.checkObjectExists((Connection)conn, (Object)object));
    }

    public int checkObjectExistsById(Object id) {
        return (Integer)this.jdbcTemplate.execute(conn -> OrmDaoUtils.checkObjectExistsById((Connection)conn, (Object)id, this.getPoClass()));
    }

    public T getObjectById(Object id) {
        if (id == null) {
            return null;
        }
        return (T)((Serializable)this.jdbcTemplate.execute(conn -> (Serializable)OrmDaoUtils.getObjectById((Connection)conn, (Object)id, this.getPoClass())));
    }

    public int mergeObject(T o) {
        if (this.checkObjectExists(o) > 0) {
            return this.innerUpdateObject(o);
        }
        this.innerSaveNewObject(o);
        return 1;
    }

    public T getObjectExcludeLazyById(Object id) {
        return (T)((Serializable)this.jdbcTemplate.execute(conn -> (Serializable)OrmDaoUtils.getObjectExcludeLazyById((Connection)conn, (Object)id, this.getPoClass())));
    }

    public T getObjectWithReferences(Object id) {
        T obj = this.getObjectById(id);
        if (obj == null) {
            return null;
        }
        return this.fetchObjectReferences(obj);
    }

    public T fetchObjectLazyColumn(T o, String columnName) {
        return (T)((Serializable)this.jdbcTemplate.execute(conn -> (Serializable)OrmDaoUtils.fetchObjectLazyColumn((Connection)conn, (Object)o, (String)columnName)));
    }

    public T fetchObjectLazyColumns(T o) {
        return (T)((Serializable)this.jdbcTemplate.execute(conn -> (Serializable)OrmDaoUtils.fetchObjectLazyColumns((Connection)conn, (Object)o)));
    }

    private List<?> innerFetchObjectReference(T object, SimpleTableReference ref) {
        if (object == null || ref == null || ref.getReferenceColumns().size() < 1) {
            return null;
        }
        Class refType = ref.getTargetEntityType();
        TableMapInfo refMapInfo = JpaMetadata.fetchTableMapInfo((Class)refType);
        if (refMapInfo == null) {
            return null;
        }
        Map properties = ref.fetchChildFk(object);
        return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.listObjectsByProperties((Connection)conn, (Map)properties, (Class)refType));
    }

    public T fetchObjectReference(T object, String columnName) {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        SimpleTableReference ref = mapInfo.findReference(columnName);
        Class refType = ref.getTargetEntityType();
        List<?> refs = this.innerFetchObjectReference(object, ref);
        if (refs != null && refs.size() > 0) {
            if (ref.getReferenceFieldType().isAssignableFrom(refType)) {
                if (EntityWithDeleteTag.class.isAssignableFrom(refType)) {
                    for (Object refObject : refs) {
                        if (((EntityWithDeleteTag)refObject).isDeleted()) continue;
                        ref.setObjectFieldValue(object, refObject);
                        break;
                    }
                } else {
                    ref.setObjectFieldValue(object, refs.get(0));
                }
            } else if (Set.class.isAssignableFrom(ref.getReferenceFieldType())) {
                HashSet validRefDate = new HashSet(refs.size() + 1);
                if (EntityWithDeleteTag.class.isAssignableFrom(refType)) {
                    for (Object refObject : refs) {
                        if (((EntityWithDeleteTag)refObject).isDeleted()) continue;
                        validRefDate.add(refObject);
                    }
                } else {
                    validRefDate.addAll(refs);
                }
                ref.setObjectFieldValue(object, validRefDate);
            } else if (List.class.isAssignableFrom(ref.getReferenceFieldType())) {
                if (EntityWithDeleteTag.class.isAssignableFrom(refType)) {
                    ArrayList validRefDate = new ArrayList(refs.size());
                    for (Object refObject : refs) {
                        if (((EntityWithDeleteTag)refObject).isDeleted()) continue;
                        validRefDate.add(refObject);
                    }
                    ref.setObjectFieldValue(object, validRefDate);
                } else {
                    ref.setObjectFieldValue(object, refs);
                }
            }
        }
        return object;
    }

    public T fetchObjectReferences(T o) {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        if (mapInfo.hasReferences()) {
            for (SimpleTableReference ref : mapInfo.getReferences()) {
                this.fetchObjectReference(o, ref.getReferenceName());
            }
        }
        return o;
    }

    public int deleteObjectReference(T object, String columnName) {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        SimpleTableReference ref = mapInfo.findReference(columnName);
        List<?> refs = this.innerFetchObjectReference(object, ref);
        if (refs != null && refs.size() > 0) {
            for (Object refObject : refs) {
                this.innerDeleteObject(refObject);
            }
        }
        return 1;
    }

    public int deleteObjectReferences(T object) {
        int nRes = 0;
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        if (mapInfo.hasReferences()) {
            for (SimpleTableReference ref : mapInfo.getReferences()) {
                nRes += this.deleteObjectReference(object, ref.getReferenceName());
            }
        }
        return nRes;
    }

    public int deleteObjectReferenceForce(T object, String columnName) {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        SimpleTableReference ref = mapInfo.findReference(columnName);
        List<?> refs = this.innerFetchObjectReference(object, ref);
        if (refs != null && refs.size() > 0) {
            for (Object refObject : refs) {
                this.innerDeleteObjectForce(refObject);
            }
        }
        return 1;
    }

    public int deleteObjectReferencesForce(T object) {
        int nRes = 0;
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        if (mapInfo.hasReferences()) {
            for (SimpleTableReference ref : mapInfo.getReferences()) {
                nRes += this.deleteObjectReferenceForce(object, ref.getReferenceName());
            }
        }
        return nRes;
    }

    public int saveObjectReference(T object, String columnName) {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        SimpleTableReference ref = mapInfo.findReference(columnName);
        if (ref == null || ref.getReferenceColumns().size() < 1) {
            return 0;
        }
        Class refType = ref.getTargetEntityType();
        TableMapInfo refMapInfo = JpaMetadata.fetchTableMapInfo((Class)refType);
        if (refMapInfo == null) {
            return 0;
        }
        List<?> refs = this.innerFetchObjectReference(object, ref);
        Object newObj = ref.getObjectFieldValue(object);
        if (newObj == null) {
            if (refs != null && refs.size() > 0) {
                for (Object refObject : refs) {
                    this.innerDeleteObject(refObject);
                }
            }
            return 1;
        }
        OrmDaoUtils.OrmObjectComparator refObjComparator = new OrmDaoUtils.OrmObjectComparator(refMapInfo);
        if (ref.getReferenceFieldType().isAssignableFrom(refType)) {
            for (Map.Entry entry : ref.getReferenceColumns().entrySet()) {
                Object obj = mapInfo.getObjectFieldValue(object, (String)entry.getKey());
                refMapInfo.setObjectFieldValue(newObj, (String)entry.getValue(), obj);
            }
            boolean haveSaved = false;
            if (refs != null && refs.size() > 0) {
                for (Object refObject : refs) {
                    if (refObjComparator.compare(refObject, newObj) == 0) {
                        this.innerUpdateObject(newObj);
                        haveSaved = true;
                        continue;
                    }
                    this.innerDeleteObject(refObject);
                }
            }
            if (!haveSaved) {
                this.innerSaveNewObject(newObj);
            }
            return 1;
        }
        List newListObj = Set.class.isAssignableFrom(ref.getReferenceFieldType()) ? new ArrayList((Set)newObj) : (List)newObj;
        for (Map.Entry ent : ref.getReferenceColumns().entrySet()) {
            Object obj = mapInfo.getObjectFieldValue(object, (String)ent.getKey());
            for (Object subObj : newListObj) {
                refMapInfo.setObjectFieldValue(subObj, (String)ent.getValue(), obj);
            }
        }
        Triple triple = CollectionsOpt.compareTwoList(refs, newListObj, (Comparator)refObjComparator);
        int resN = 0;
        if (triple.getLeft() != null) {
            for (Object obj : (List)triple.getLeft()) {
                this.innerSaveNewObject(obj);
                ++resN;
            }
        }
        if (triple.getRight() != null) {
            for (Object obj : (List)triple.getRight()) {
                this.innerDeleteObject(obj);
                ++resN;
            }
        }
        if (triple.getMiddle() != null) {
            for (Pair pobj : (List)triple.getMiddle()) {
                if (!GeneralJsonObjectDao.checkNeedUpdate((Map)CollectionsOpt.objectToMap((Object)pobj.getLeft()), (Map)CollectionsOpt.objectToMap((Object)pobj.getRight()))) continue;
                resN += this.innerUpdateObject(pobj.getRight());
            }
        }
        return resN;
    }

    public int saveObjectReferences(T o) {
        int nRes = 0;
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        if (mapInfo.hasReferences()) {
            for (SimpleTableReference ref : mapInfo.getReferences()) {
                nRes += this.saveObjectReference(o, ref.getReferenceName());
            }
        }
        return nRes;
    }

    @Deprecated
    public T getObjectCascadeById(Object id) {
        return (T)((Serializable)this.jdbcTemplate.execute(conn -> (Serializable)OrmDaoUtils.getObjectCascadeById((Connection)conn, (Object)id, this.getPoClass(), (int)3)));
    }

    @Deprecated
    public T fetchObjectReferencesCascade(T object) {
        return (T)((Serializable)this.jdbcTemplate.execute(conn -> (Serializable)OrmDaoUtils.fetchObjectReferencesCascade((Connection)conn, (Object)object, this.getPoClass(), (int)3)));
    }

    @Deprecated
    public Integer updateObjectCascade(T object) {
        return (Integer)this.jdbcTemplate.execute(conn -> OrmDaoUtils.updateObjectCascade((Connection)conn, (Object)object, (int)3));
    }

    @Deprecated
    public Integer saveNewObjectCascade(T object) {
        return (Integer)this.jdbcTemplate.execute(conn -> OrmDaoUtils.saveNewObjectCascade((Connection)conn, (Object)object, (int)3));
    }

    public int deleteObjectsForceByProperties(Map<String, Object> properties, Collection<String> extentFilters, QueryUtils.IFilterTranslater powerTranslater) {
        QueryAndNamedParams filterAndParams = this.buildFilterByParams(properties, extentFilters, powerTranslater);
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        String deleteSql = "delete from " + mapInfo.getTableName() + " where 1=1 " + filterAndParams.getQuery();
        return (Integer)this.jdbcTemplate.execute(conn -> DatabaseAccess.doExecuteNamedSql((Connection)conn, (String)deleteSql, (Map)filterAndParams.getParams()));
    }

    public int deleteObjectsForceByProperties(Map<String, Object> properties) {
        return this.deleteObjectsForceByProperties(properties, null, null);
    }

    public int deleteObjectsByProperties(Map<String, Object> properties, Collection<String> extentFilters, QueryUtils.IFilterTranslater powerTranslater) {
        boolean hasDeleteTag = EntityWithDeleteTag.class.isAssignableFrom(this.getPoClass());
        List<T> deleteList = this.listObjectsByProperties(properties, extentFilters, powerTranslater);
        int deleteSum = 0;
        if (deleteList != null) {
            for (Serializable obj : deleteList) {
                if (hasDeleteTag) {
                    ((EntityWithDeleteTag)((Object)obj)).setDeleted(true);
                    deleteSum += this.innerUpdateObject(obj);
                    continue;
                }
                deleteSum += this.innerDeleteObjectForce(obj);
            }
        }
        return deleteSum;
    }

    public int deleteObjectsByProperties(Map<String, Object> properties) {
        return this.deleteObjectsByProperties(properties, null, null);
    }

    public List<T> listObjects() {
        return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.listAllObjects((Connection)conn, this.getPoClass()));
    }

    public T getObjectByProperties(Map<String, Object> properties) {
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        return (T)((Serializable)this.jdbcTemplate.execute(conn -> (Serializable)OrmDaoUtils.getObjectByProperties((Connection)conn, (Map)properties, this.getPoClass())));
    }

    public T getObjectByProperties(Map<String, Object> properties, Collection<String> filters, QueryUtils.IFilterTranslater powerTranslater) {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        Pair q = GeneralJsonObjectDao.buildFieldSqlWithFields((TableInfo)mapInfo, null, (boolean)false);
        QueryAndNamedParams queryAndParams = this.buildFilterByParams(properties, filters, powerTranslater);
        String querySql = this.encapsulateFilterToSql((String)q.getLeft(), queryAndParams.getQuery(), null, null, false);
        queryAndParams.setQuery(querySql);
        try {
            return (T)((Serializable)this.jdbcTemplate.execute(conn -> (Serializable)OrmDaoUtils.queryNamedParamsSql((Connection)conn, (QueryAndNamedParams)queryAndParams, rs -> (Serializable)OrmUtils.fetchObjectFormResultSet((ResultSet)rs, this.getPoClass(), (TableField[])((TableField[])q.getRight())))));
        }
        catch (ObjectException exception) {
            logger.error("\u6267\u884csql\u8bed\u53e5 " + querySql + " \u65f6\u629b\u51fa\u5f02\u5e38" + exception.getMessage());
            return null;
        }
    }

    public int countObjectByProperties(Map<String, Object> properties) {
        return this.countObjectByProperties(properties, null, null);
    }

    public int countObjectByProperties(Map<String, Object> properties, Collection<String> filters, QueryUtils.IFilterTranslater powerTranslater) {
        QueryAndNamedParams qap = this.buildQueryByParams(properties, null, filters, powerTranslater);
        String countSql = QueryUtils.buildGetCountSQLByReplaceFields((String)qap.getQuery());
        return NumberBaseOpt.castObjectToInteger((Object)DatabaseOptUtils.getScalarObjectQuery(this, countSql, qap.getParams()), (Integer)0);
    }

    public List<T> listObjectsByProperties(Map<String, Object> properties, Collection<String> filters, QueryUtils.IFilterTranslater powerTranslater) {
        QueryAndNamedParams qap = this.buildQueryByParams(properties, null, filters, powerTranslater);
        return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.queryObjectsByNamedParamsSql((Connection)conn, (String)qap.getQuery(), (Map)qap.getParams(), this.getPoClass()));
    }

    public List<T> listObjectsByProperties(Map<String, Object> properties, Collection<String> filters, QueryUtils.IFilterTranslater powerTranslater, int startPos, int maxSize) {
        QueryAndNamedParams qap = this.buildQueryByParams(properties, null, filters, powerTranslater);
        return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.queryObjectsByNamedParamsSql((Connection)conn, (String)qap.getQuery(), (Map)qap.getParams(), this.getPoClass(), (int)startPos, (int)maxSize));
    }

    public List<T> listObjectsByProperties(Map<String, Object> properties, Collection<String> filters, QueryUtils.IFilterTranslater powerTranslater, PageDesc pageDesc) {
        QueryAndNamedParams qap = this.buildQueryByParams(properties, null, filters, powerTranslater);
        return (List)this.jdbcTemplate.execute(conn -> {
            if (pageDesc != null && pageDesc.getPageSize() > 0 && pageDesc.getPageNo() > 0) {
                pageDesc.setTotalRows(Integer.valueOf(OrmDaoUtils.fetchObjectsCount((Connection)conn, (String)QueryUtils.buildGetCountSQLByReplaceFields((String)qap.getQuery()), (Map)qap.getParams())));
                return OrmDaoUtils.queryObjectsByNamedParamsSql((Connection)conn, (String)qap.getQuery(), (Map)qap.getParams(), this.getPoClass(), (int)pageDesc.getRowStart(), (int)pageDesc.getPageSize());
            }
            List objects = OrmDaoUtils.queryObjectsByNamedParamsSql((Connection)conn, (String)qap.getQuery(), (Map)qap.getParams(), this.getPoClass());
            if (pageDesc != null && objects != null) {
                pageDesc.setTotalRows(Integer.valueOf(objects.size()));
            }
            return objects;
        });
    }

    public List<T> listObjectsByProperties(Map<String, Object> properties) {
        return this.listObjectsByProperties(properties, null, null);
    }

    public List<T> listObjectsByProperties(Map<String, Object> properties, int startPos, int maxSize) {
        return this.listObjectsByProperties(properties, null, null, startPos, maxSize);
    }

    public List<T> listObjectsByProperties(Map<String, Object> properties, PageDesc pageDesc) {
        return this.listObjectsByProperties(properties, null, null, pageDesc);
    }

    private JSONArray listObjectsBySqlAsJson(String querySql, Object[] params, TableField[] fields, PageDesc pageDesc) {
        return (JSONArray)this.jdbcTemplate.execute(conn -> {
            try {
                if (pageDesc != null && pageDesc.getPageSize() > 0 && pageDesc.getPageNo() > 0) {
                    String pageQuerySql = QueryUtils.buildLimitQuerySQL((String)querySql, (int)pageDesc.getRowStart(), (int)pageDesc.getPageSize(), (boolean)false, (DBType)DBType.mapDBType((Connection)conn));
                    pageDesc.setTotalRows(NumberBaseOpt.castObjectToInteger((Object)DatabaseAccess.getScalarObjectQuery((Connection)conn, (String)QueryUtils.buildGetCountSQLByReplaceFields((String)querySql), (Object[])params)));
                    return GeneralJsonObjectDao.findObjectsBySql((Connection)conn, (String)pageQuerySql, (Object[])params, (TableField[])fields);
                }
                JSONArray ja = GeneralJsonObjectDao.findObjectsBySql((Connection)conn, (String)querySql, (Object[])params, (TableField[])fields);
                if (pageDesc != null && ja != null) {
                    pageDesc.setTotalRows(Integer.valueOf(ja.size()));
                }
                return ja;
            }
            catch (IOException | SQLException e) {
                throw new ObjectException((Throwable)e);
            }
        });
    }

    private JSONArray listObjectsBySqlAsJson(String querySql, Object[] params, TableField[] fields, int startPos, int maxSize) {
        return (JSONArray)this.jdbcTemplate.execute(conn -> {
            try {
                return GeneralJsonObjectDao.findObjectsBySql((Connection)conn, (String)QueryUtils.buildLimitQuerySQL((String)querySql, (int)startPos, (int)maxSize, (boolean)false, (DBType)DBType.mapDBType((Connection)conn)), (Object[])params, (TableField[])fields);
            }
            catch (IOException | SQLException e) {
                throw new ObjectException((Throwable)e);
            }
        });
    }

    public JSONArray listObjectsByPropertiesAsJson(Map<String, Object> properties, Collection<String> filters, QueryUtils.IFilterTranslater powerTranslater) {
        return this.listObjectsByPropertiesAsJson(properties, filters, powerTranslater, null);
    }

    public JSONArray listObjectsByPropertiesAsJson(Map<String, Object> properties) {
        return this.listObjectsByPropertiesAsJson(properties, null, null, null);
    }

    public JSONArray listObjectsByPropertiesAsJson(Map<String, Object> properties, Collection<String> filters, QueryUtils.IFilterTranslater powerTranslater, int startPos, int maxSize) {
        LeftRightPair<QueryAndNamedParams, TableField[]> queryAndFields = this.buildQueryByParamsWithFields(properties, null, filters, powerTranslater);
        QueryAndParams sqlQuery = QueryAndParams.createFromQueryAndNamedParams((QueryAndNamedParams)((QueryAndNamedParams)queryAndFields.getLeft()));
        return this.listObjectsBySqlAsJson(sqlQuery.getQuery(), sqlQuery.getParams(), (TableField[])queryAndFields.getRight(), startPos, maxSize);
    }

    public JSONArray listObjectsByPropertiesAsJson(Map<String, Object> properties, int startPos, int maxSize) {
        return this.listObjectsByPropertiesAsJson(properties, null, null, startPos, maxSize);
    }

    public JSONArray listObjectsByPropertiesAsJson(Map<String, Object> properties, Collection<String> filters, QueryUtils.IFilterTranslater powerTranslater, PageDesc pageDesc) {
        LeftRightPair<QueryAndNamedParams, TableField[]> queryAndFields = this.buildQueryByParamsWithFields(properties, null, filters, powerTranslater);
        QueryAndParams sqlQuery = QueryAndParams.createFromQueryAndNamedParams((QueryAndNamedParams)((QueryAndNamedParams)queryAndFields.getLeft()));
        return this.listObjectsBySqlAsJson(sqlQuery.getQuery(), sqlQuery.getParams(), (TableField[])queryAndFields.getRight(), pageDesc);
    }

    public JSONArray listObjectsByPropertiesAsJson(Map<String, Object> properties, PageDesc pageDesc) {
        return this.listObjectsByPropertiesAsJson(properties, null, null, pageDesc);
    }

    public JSONArray listObjectsPartFieldByPropertiesAsJson(Map<String, Object> properties, Collection<String> fields, Collection<String> filters, QueryUtils.IFilterTranslater powerTranslater) {
        return this.listObjectsPartFieldByPropertiesAsJson(properties, fields, filters, powerTranslater, null);
    }

    public JSONArray listObjectsPartFieldByPropertiesAsJson(Map<String, Object> properties, Collection<String> fields, Collection<String> filters, QueryUtils.IFilterTranslater powerTranslater, int startPos, int maxSize) {
        LeftRightPair<QueryAndNamedParams, TableField[]> queryAndFields = this.buildQueryByParamsWithFields(properties, fields, filters, powerTranslater);
        QueryAndParams sqlQuery = QueryAndParams.createFromQueryAndNamedParams((QueryAndNamedParams)((QueryAndNamedParams)queryAndFields.getLeft()));
        return this.listObjectsBySqlAsJson(sqlQuery.getQuery(), sqlQuery.getParams(), (TableField[])queryAndFields.getRight(), startPos, maxSize);
    }

    public JSONArray listObjectsPartFieldByPropertiesAsJson(Map<String, Object> properties, Collection<String> fields, Collection<String> filters, QueryUtils.IFilterTranslater powerTranslater, PageDesc pageDesc) {
        LeftRightPair<QueryAndNamedParams, TableField[]> queryAndFields = this.buildQueryByParamsWithFields(properties, fields, filters, powerTranslater);
        QueryAndParams sqlQuery = QueryAndParams.createFromQueryAndNamedParams((QueryAndNamedParams)((QueryAndNamedParams)queryAndFields.getLeft()));
        return this.listObjectsBySqlAsJson(sqlQuery.getQuery(), sqlQuery.getParams(), (TableField[])queryAndFields.getRight(), pageDesc);
    }

    public JSONArray listObjectsPartFieldByPropertiesAsJson(Map<String, Object> properties, Collection<String> fields) {
        return this.listObjectsPartFieldByPropertiesAsJson(properties, fields, null, null, null);
    }

    public JSONArray listObjectsPartFieldByPropertiesAsJson(Map<String, Object> properties, Collection<String> fields, int startPos, int maxSize) {
        return this.listObjectsPartFieldByPropertiesAsJson(properties, fields, null, null, startPos, maxSize);
    }

    public JSONArray listObjectsPartFieldByPropertiesAsJson(Map<String, Object> properties, Collection<String> fields, PageDesc pageDesc) {
        return this.listObjectsPartFieldByPropertiesAsJson(properties, fields, null, null, pageDesc);
    }

    public List<T> listObjectsBySql(String querySql, Map<String, Object> namedParams) {
        return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.queryObjectsByNamedParamsSql((Connection)conn, (String)querySql, (Map)namedParams, this.getPoClass()));
    }

    public List<T> listObjectsBySql(String querySql, Object[] params) {
        return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.queryObjectsByParamsSql((Connection)conn, (String)querySql, (Object[])params, this.getPoClass()));
    }

    @Deprecated
    public List<T> listObjectsByFilter(String whereSql, Object[] params, String tableAlias) {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        String fieldsSql = GeneralJsonObjectDao.buildFieldSql((TableInfo)mapInfo, (String)tableAlias, (int)1);
        String querySql = "select " + fieldsSql + " from " + mapInfo.getTableName() + (StringUtils.isNotBlank((CharSequence)tableAlias) ? " " + tableAlias + " " : " ") + whereSql;
        return this.listObjectsBySql(querySql, params);
    }

    public List<T> listObjectsByFilter(String whereSql, Map<String, Object> namedParams, String tableAlias) {
        QueryAndParams qap = QueryAndParams.createFromQueryAndNamedParams((String)whereSql, namedParams);
        return this.listObjectsByFilter(qap.getQuery(), qap.getParams(), tableAlias);
    }

    public List<T> listObjectsByFilter(String whereSql, Object[] params) {
        return this.listObjectsByFilter(whereSql, params, null);
    }

    public List<T> listObjectsByFilter(String whereSql, Map<String, Object> namedParams) {
        return this.listObjectsByFilter(whereSql, namedParams, null);
    }

    private Pair<String, TableField[]> buildQuerySqlWithFieldsAndWhere(String whereSql, String tableAlias) {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        Pair fieldsDesc = GeneralJsonObjectDao.buildFieldSqlWithFields((TableInfo)mapInfo, (String)tableAlias, (boolean)true);
        String querySql = "select " + (String)fieldsDesc.getLeft() + " from " + mapInfo.getTableName() + (StringUtils.isNotBlank((CharSequence)tableAlias) ? " " + tableAlias + " " : " ") + whereSql;
        return new ImmutablePair((Object)querySql, fieldsDesc.getRight());
    }

    public JSONArray listObjectsByFilterAsJson(String whereSql, Map<String, Object> namedParams, String tableAlias, PageDesc pageDesc) {
        Pair<String, TableField[]> fieldsDesc = this.buildQuerySqlWithFieldsAndWhere(whereSql, tableAlias);
        QueryAndParams sqlQuery = QueryAndParams.createFromQueryAndNamedParams((QueryAndNamedParams)new QueryAndNamedParams((String)fieldsDesc.getLeft(), namedParams));
        return this.listObjectsBySqlAsJson(sqlQuery.getQuery(), sqlQuery.getParams(), (TableField[])fieldsDesc.getRight(), pageDesc);
    }

    public JSONArray listObjectsByFilterAsJson(String whereSql, Map<String, Object> namedParams, PageDesc pageDesc) {
        return this.listObjectsByFilterAsJson(whereSql, namedParams, null, pageDesc);
    }

    public JSONArray listObjectsByFilterAsJson(String whereSql, Object[] params, String tableAlias, PageDesc pageDesc) {
        Pair<String, TableField[]> fieldsDesc = this.buildQuerySqlWithFieldsAndWhere(whereSql, tableAlias);
        return this.listObjectsBySqlAsJson((String)fieldsDesc.getLeft(), params, (TableField[])fieldsDesc.getRight(), pageDesc);
    }

    public JSONArray listObjectsByFilterAsJson(String whereSql, Object[] params, PageDesc pageDesc) {
        return this.listObjectsByFilterAsJson(whereSql, params, null, pageDesc);
    }
}

