/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.core.controller;

import com.centit.framework.core.dao.ExtendedQueryPool;
import com.centit.support.database.utils.DBType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sqlPool"})
@Api(value="\u6301\u4e45\u5316\u6846\u67b6\u4e2d\u7684sql\u8bed\u53e5\u8d44\u6e90", tags={"\u6846\u67b6\u4e2d\u7684sql\u8bed\u53e5\u8d44\u6e90"})
public class ExtendedQueryPoolController {
    protected Logger logger = LoggerFactory.getLogger(ExtendedQueryPoolController.class);
    @Value(value="${app.home:.}")
    private String appHome;
    @Value(value="${jdbc.url:}")
    private String jdbcUrl;
    @Value(value="${spring.datasource.url:}")
    private String springDatasourceUrl;

    public void setAppHome(String appHome) {
        this.appHome = appHome;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    @ApiOperation(value="\u91cd\u542f\u52a0\u8f7d[home]/sqlscript\u76ee\u5f55\u4e2d\u7684sql(*.xml)\u811a\u672c\u6587\u4ef6", notes="\u91cd\u542f\u52a0\u8f7dsql\u8bed\u53e5")
    @RequestMapping(value={"/reloadextendedsqlmap"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> reloadExtendedSqlMap() {
        boolean hasError = false;
        StringBuilder errorMsg = new StringBuilder();
        DBType dbType = DBType.mapDBType((String)(StringUtils.isBlank((CharSequence)this.jdbcUrl) ? this.springDatasourceUrl : this.jdbcUrl));
        try {
            ExtendedQueryPool.loadResourceExtendedSqlMap(dbType);
        }
        catch (DocumentException e) {
            hasError = true;
            errorMsg.append(e.getMessage());
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            ExtendedQueryPool.loadExtendedSqlMaps(this.appHome + "/sqlscript", dbType);
        }
        catch (IOException | DocumentException e) {
            hasError = true;
            errorMsg.append(e.getMessage());
            this.logger.error(e.getMessage(), e);
        }
        HashMap<String, Object> res = new HashMap<String, Object>(6);
        if (hasError) {
            res.put("code", 500);
            res.put("message", errorMsg.toString());
        } else {
            res.put("code", 0);
            res.put("message", "Reload Extended Sql Map succeed\uff01");
        }
        return res;
    }
}

