/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.jdbc.dao;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.JdbcTemplateUtils;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.database.orm.JpaMetadata;
import com.centit.support.database.orm.TableMapInfo;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.QueryUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;

public abstract class DatabaseOptUtils {
    protected static Logger logger = LoggerFactory.getLogger(DatabaseOptUtils.class);

    public static Map<String, Object> collectRequestParameters(HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry ent : parameterMap.entrySet()) {
            String valueName;
            String[] values;
            String key = (String)ent.getKey();
            if (key.startsWith("_") || (values = CollectionsOpt.removeBlankString((String[])((String[])ent.getValue()))) == null) continue;
            Object paramValue = values.length == 1 ? values[0] : values;
            String pretreatmentSql = key;
            ImmutableTriple paramDesc = QueryUtils.parseParameter((String)pretreatmentSql);
            String pretreatment = (String)paramDesc.getRight();
            String string = valueName = StringUtils.isBlank((CharSequence)((CharSequence)paramDesc.getMiddle())) ? (String)paramDesc.getLeft() : (String)paramDesc.getMiddle();
            if (StringUtils.isNotBlank((CharSequence)pretreatment)) {
                paramValue = QueryUtils.pretreatParameter((String)pretreatment, (Object)paramValue);
            }
            map.put(valueName, paramValue);
        }
        return map;
    }

    public static List<String> extraPoAllFieldNames(Class<?> poClass) {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(poClass);
        if (mapInfo == null) {
            return null;
        }
        return mapInfo.getAllFieldsName();
    }

    public static String[] extraPoAllFieldNamesAsArray(Class<?> poClass) {
        List<String> filedNames = DatabaseOptUtils.extraPoAllFieldNames(poClass);
        if (filedNames == null) {
            return null;
        }
        return filedNames.toArray(new String[filedNames.size()]);
    }

    public static Object callFunction(BaseDaoImpl<?, ?> baseDao, String procName, int sqlType, Object ... paramObjs) {
        return JdbcTemplateUtils.callFunction(baseDao.getJdbcTemplate(), procName, sqlType, paramObjs);
    }

    public static final boolean callProcedure(BaseDaoImpl<?, ?> baseDao, String procName, Object ... paramObjs) {
        return JdbcTemplateUtils.callProcedure(baseDao.getJdbcTemplate(), procName, paramObjs);
    }

    public static final boolean doExecuteSql(BaseDaoImpl<?, ?> baseDao, String sSql) throws DataAccessException {
        return JdbcTemplateUtils.doExecuteSql(baseDao.getJdbcTemplate(), sSql);
    }

    public static final int doExecuteSql(BaseDaoImpl<?, ?> baseDao, String sSql, Object[] values) throws DataAccessException {
        return JdbcTemplateUtils.doExecuteSql(baseDao.getJdbcTemplate(), sSql, values);
    }

    public static final int doExecuteNamedSql(BaseDaoImpl<?, ?> baseDao, String sSql, Map<String, Object> values) throws DataAccessException {
        return JdbcTemplateUtils.doExecuteNamedSql(baseDao.getJdbcTemplate(), sSql, values);
    }

    public static JSONArray listObjectsByNamedSqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, String[] fieldNames, String queryCountSql, Map<String, Object> namedParams, PageDesc pageDesc) {
        return JdbcTemplateUtils.listObjectsByNamedSqlAsJson(baseDao.getJdbcTemplate(), querySql, fieldNames, queryCountSql, namedParams, pageDesc);
    }

    public static JSONArray listObjectsByNamedSqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, String[] fieldNames, Map<String, Object> namedParams, PageDesc pageDesc) {
        return DatabaseOptUtils.listObjectsByNamedSqlAsJson(baseDao, querySql, fieldNames, QueryUtils.buildGetCountSQLByReplaceFields((String)querySql), namedParams, pageDesc);
    }

    public static JSONArray listObjectsByNamedSqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, String[] fieldNames, Map<String, Object> namedParams) {
        return JdbcTemplateUtils.listObjectsByNamedSqlAsJson(baseDao.getJdbcTemplate(), querySql, fieldNames, namedParams);
    }

    public static JSONArray listObjectsByNamedSqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, String queryCountSql, Map<String, Object> namedParams, PageDesc pageDesc) {
        return DatabaseOptUtils.listObjectsByNamedSqlAsJson(baseDao, querySql, null, queryCountSql, namedParams, pageDesc);
    }

    public static JSONArray listObjectsByNamedSqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, Map<String, Object> params) {
        return JdbcTemplateUtils.listObjectsByNamedSqlAsJson(baseDao.getJdbcTemplate(), querySql, params);
    }

    public static JSONArray listObjectsByNamedSqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, Map<String, Object> namedParams, PageDesc pageDesc) {
        return JdbcTemplateUtils.listObjectsByNamedSqlAsJson(baseDao.getJdbcTemplate(), querySql, namedParams, pageDesc);
    }

    public static JSONArray listObjectsBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, String[] fieldNames, String queryCountSql, Object[] params, PageDesc pageDesc) {
        return JdbcTemplateUtils.listObjectsBySqlAsJson(baseDao.getJdbcTemplate(), querySql, fieldNames, queryCountSql, params, pageDesc);
    }

    public static JSONArray listObjectsBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, String[] fieldNames, Object[] params) {
        return JdbcTemplateUtils.listObjectsBySqlAsJson(baseDao.getJdbcTemplate(), querySql, fieldNames, params);
    }

    public static JSONArray listObjectsBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, String[] fieldNames, Object[] params, PageDesc pageDesc) {
        return DatabaseOptUtils.listObjectsBySqlAsJson(baseDao, querySql, fieldNames, QueryUtils.buildGetCountSQLByReplaceFields((String)querySql), params, pageDesc);
    }

    public static JSONArray listObjectsBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, String queryCountSql, Object[] params, PageDesc pageDesc) {
        return DatabaseOptUtils.listObjectsBySqlAsJson(baseDao, querySql, null, queryCountSql, params, pageDesc);
    }

    public static JSONArray listObjectsBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, Object[] params, String[] fieldnames) {
        return JdbcTemplateUtils.listObjectsBySqlAsJson(baseDao.getJdbcTemplate(), querySql, params, fieldnames);
    }

    public static JSONArray listObjectsBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, Object[] params) {
        return JdbcTemplateUtils.listObjectsBySqlAsJson(baseDao.getJdbcTemplate(), querySql, params);
    }

    public static JSONArray listObjectsBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, Object[] params, PageDesc pageDesc) {
        return JdbcTemplateUtils.listObjectsBySqlAsJson(baseDao.getJdbcTemplate(), querySql, params, pageDesc);
    }

    public static List<Object[]> listObjectsBySql(BaseDaoImpl<?, ?> baseDao, String querySql) {
        return JdbcTemplateUtils.listObjectsBySql(baseDao.getJdbcTemplate(), querySql, null);
    }

    public static List<Object[]> listObjectsBySql(BaseDaoImpl<?, ?> baseDao, String querySql, Object[] params) {
        return JdbcTemplateUtils.listObjectsBySql(baseDao.getJdbcTemplate(), querySql, params);
    }

    public static List<Object[]> listObjectsBySql(BaseDaoImpl<?, ?> baseDao, String querySql, String queryCountSql, PageDesc pageDesc) {
        return JdbcTemplateUtils.listObjectsBySql(baseDao.getJdbcTemplate(), querySql, queryCountSql, null, pageDesc);
    }

    public static List<Object[]> listObjectsBySql(BaseDaoImpl<?, ?> baseDao, String querySql, String queryCountSql, Object[] params, PageDesc pageDesc) {
        return JdbcTemplateUtils.listObjectsBySql(baseDao.getJdbcTemplate(), querySql, queryCountSql, params, pageDesc);
    }

    public static List<Object[]> listObjectsBySql(BaseDaoImpl<?, ?> baseDao, String querySql, Object[] params, PageDesc pageDesc) {
        return JdbcTemplateUtils.listObjectsBySql(baseDao.getJdbcTemplate(), querySql, params, pageDesc);
    }

    public static JSONArray listObjectsBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql) {
        return JdbcTemplateUtils.listObjectsBySqlAsJson(baseDao.getJdbcTemplate(), querySql, null);
    }

    public static JSONArray listObjectsBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, PageDesc pageDesc) {
        return JdbcTemplateUtils.listObjectsBySqlAsJson(baseDao.getJdbcTemplate(), querySql, null, pageDesc);
    }

    public static List<Object[]> listObjectsByNamedSql(BaseDaoImpl<?, ?> baseDao, String querySql, Map<String, Object> namedParams) {
        return JdbcTemplateUtils.listObjectsByNamedSql(baseDao.getJdbcTemplate(), querySql, namedParams);
    }

    public static List<Object[]> listObjectsByNamedSql(BaseDaoImpl<?, ?> baseDao, String querySql, String queryCountSql, Map<String, Object> namedParams, PageDesc pageDesc) {
        return JdbcTemplateUtils.listObjectsByNamedSql(baseDao.getJdbcTemplate(), querySql, queryCountSql, namedParams, pageDesc);
    }

    public static List<Object[]> listObjectsByNamedSql(BaseDaoImpl<?, ?> baseDao, String querySql, Map<String, Object> namedParams, PageDesc pageDesc) {
        return JdbcTemplateUtils.listObjectsByNamedSql(baseDao.getJdbcTemplate(), querySql, namedParams, pageDesc);
    }

    public static JSONArray listObjectsByParamsDriverSqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, String[] fieldNames, String queryCountSql, Map<String, Object> namedParams, PageDesc pageDesc) {
        return JdbcTemplateUtils.listObjectsByParamsDriverSqlAsJson(baseDao.getJdbcTemplate(), querySql, fieldNames, queryCountSql, namedParams, pageDesc);
    }

    public static JSONArray listObjectsByParamsDriverSqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, String[] fieldNames, Map<String, Object> namedParams, PageDesc pageDesc) {
        return JdbcTemplateUtils.listObjectsByParamsDriverSqlAsJson(baseDao.getJdbcTemplate(), querySql, fieldNames, namedParams, pageDesc);
    }

    public static JSONArray listObjectsByParamsDriverSqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, String[] fieldNames, Map<String, Object> namedParams) {
        return JdbcTemplateUtils.listObjectsByParamsDriverSqlAsJson(baseDao.getJdbcTemplate(), querySql, fieldNames, namedParams);
    }

    public static JSONArray listObjectsByParamsDriverSqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, String queryCountSql, Map<String, Object> namedParams, PageDesc pageDesc) {
        return DatabaseOptUtils.listObjectsByParamsDriverSqlAsJson(baseDao, querySql, null, queryCountSql, namedParams, pageDesc);
    }

    public static JSONArray listObjectsByParamsDriverSqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, Map<String, Object> namedParams) {
        return JdbcTemplateUtils.listObjectsByParamsDriverSqlAsJson(baseDao.getJdbcTemplate(), querySql, namedParams);
    }

    public static JSONArray listObjectsByParamsDriverSqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, Map<String, Object> namedParams, PageDesc pageDesc) {
        return JdbcTemplateUtils.listObjectsByParamsDriverSqlAsJson(baseDao.getJdbcTemplate(), querySql, namedParams, pageDesc);
    }

    public static JSONObject getObjectBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, Object[] params, String[] fieldName) {
        return JdbcTemplateUtils.getObjectBySqlAsJson(baseDao.getJdbcTemplate(), querySql, params, fieldName);
    }

    public static JSONObject getObjectBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, Object[] params) {
        return DatabaseOptUtils.getObjectBySqlAsJson(baseDao, querySql, params, null);
    }

    public static JSONObject getObjectBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, Map<String, Object> params, String[] fieldName) {
        return JdbcTemplateUtils.getObjectBySqlAsJson(baseDao.getJdbcTemplate(), querySql, params, fieldName);
    }

    public static JSONObject getObjectBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, Map<String, Object> params) {
        return DatabaseOptUtils.getObjectBySqlAsJson(baseDao, querySql, params, null);
    }

    public static JSONObject getObjectBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql) {
        return JdbcTemplateUtils.getObjectBySqlAsJson(baseDao.getJdbcTemplate(), querySql);
    }

    public static Object getScalarObjectQuery(BaseDaoImpl<?, ?> baseDao, String sSql, Map<String, Object> values) {
        return JdbcTemplateUtils.getScalarObjectQuery(baseDao.getJdbcTemplate(), sSql, values);
    }

    public static Object getScalarObjectQuery(BaseDaoImpl<?, ?> baseDao, String sSql, Object[] values) {
        return JdbcTemplateUtils.getScalarObjectQuery(baseDao.getJdbcTemplate(), sSql, values);
    }

    public static Object getScalarObjectQuery(BaseDaoImpl<?, ?> baseDao, String sSql) throws SQLException, IOException {
        return JdbcTemplateUtils.getScalarObjectQuery(baseDao.getJdbcTemplate(), sSql);
    }

    public static Object getScalarObjectQuery(BaseDaoImpl<?, ?> baseDao, String sSql, Object value) throws SQLException, IOException {
        return JdbcTemplateUtils.getScalarObjectQuery(baseDao.getJdbcTemplate(), sSql, value);
    }

    public static Long getSequenceNextValue(BaseDaoImpl<?, ?> baseDao, String sequenceName) {
        return JdbcTemplateUtils.getSequenceNextValue(baseDao.getJdbcTemplate(), sequenceName);
    }

    public static int batchSaveNewObjects(BaseDaoImpl<?, ?> baseDao, Collection<?> objects) {
        return JdbcTemplateUtils.batchSaveNewObjects(baseDao.getJdbcTemplate(), objects);
    }

    public static int batchUpdateObjects(BaseDaoImpl<?, ?> baseDao, Collection<?> objects) {
        return JdbcTemplateUtils.batchUpdateObjects(baseDao.getJdbcTemplate(), objects);
    }

    public static int batchMergeObjects(BaseDaoImpl<?, ?> baseDao, Collection<?> objects) {
        return JdbcTemplateUtils.batchMergeObjects(baseDao.getJdbcTemplate(), objects);
    }

    public static int batchDeleteObjects(BaseDaoImpl<?, ?> baseDao, Collection<?> objects) {
        return JdbcTemplateUtils.batchDeleteObjects(baseDao.getJdbcTemplate(), objects);
    }

    public static <T> Integer batchUpdateObject(BaseDaoImpl<?, ?> baseDao, Collection<String> fields, T object, Map<String, Object> properties) {
        return JdbcTemplateUtils.batchUpdateObject(baseDao.getJdbcTemplate(), fields, object, properties);
    }

    public <T> Integer batchUpdateObject(BaseDaoImpl<?, ?> baseDao, String[] fields, T object, Map<String, Object> properties) {
        return DatabaseOptUtils.batchUpdateObject(baseDao, CollectionsOpt.arrayToList((Object[])fields), object, properties);
    }

    public static Integer batchUpdateObject(BaseDaoImpl<?, ?> baseDao, Class<?> type, Map<String, Object> propertiesValue, Map<String, Object> propertiesFilter) {
        return JdbcTemplateUtils.batchUpdateObject(baseDao.getJdbcTemplate(), type, propertiesValue, propertiesFilter);
    }

    public static <T> Integer replaceObjectsAsTabulation(BaseDaoImpl<?, ?> baseDao, List<T> oldDbObject, List<T> newObjects) {
        return JdbcTemplateUtils.replaceObjectsAsTabulation(baseDao.getJdbcTemplate(), oldDbObject, newObjects);
    }

    public static Integer replaceObjectsAsTabulation(BaseDaoImpl<?, ?> baseDao, Class<?> type, List<Map<String, Object>> oldDbObject, List<Map<String, Object>> newObjects) {
        return JdbcTemplateUtils.replaceObjectsAsTabulation(baseDao.getJdbcTemplate(), type, oldDbObject, newObjects);
    }

    public static DBType doGetDBType(BaseDaoImpl<?, ?> baseDao) {
        return JdbcTemplateUtils.doGetDBType(baseDao.getJdbcTemplate());
    }
}

