/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.model.security;

import org.apache.commons.lang3.StringUtils;

public interface CentitPasswordEncoder {
    public static int checkPasswordStrength(String password, int minLength) {
        if (StringUtils.isBlank((CharSequence)password)) {
            return -1;
        }
        int passwrodLen = password.length();
        int mathLength = passwrodLen >= minLength ? 1 : -1;
        int hasDigit = 0;
        int hasLowLetter = 0;
        int hasUpLetter = 0;
        int hasOtherLetter = 0;
        for (int i = 0; i < passwrodLen; ++i) {
            char c = password.charAt(i);
            if (c >= '0' && c <= '9') {
                hasDigit = 1;
                continue;
            }
            if (c >= 'a' && c <= 'z') {
                hasLowLetter = 1;
                continue;
            }
            if (c >= 'A' && c <= 'Z') {
                hasUpLetter = 1;
                continue;
            }
            hasOtherLetter = 1;
        }
        return mathLength * (hasDigit + hasLowLetter + hasUpLetter + hasOtherLetter);
    }

    public static int checkPasswordStrength(String password) {
        return CentitPasswordEncoder.checkPasswordStrength(password, 8);
    }

    public String encodePassword(String var1, Object var2);

    public String createPassword(String var1, Object var2);

    public boolean isPasswordValid(String var1, String var2, Object var3);

    default public boolean isCorrectPasswordFormat(String password) {
        return true;
    }
}

