/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.config;

import com.centit.framework.common.SysParametersUtils;
import com.centit.framework.filter.AssertUserLoginFilter;
import com.centit.framework.filter.RequestThreadLocalFilter;
import com.centit.support.algorithm.StringRegularOpt;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.Properties;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.apache.commons.lang3.StringUtils;
import org.h2.server.web.WebServlet;
import org.jasig.cas.client.session.SingleSignOutHttpSessionListener;
import org.springframework.security.web.session.HttpSessionEventPublisher;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestContextListener;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.filter.DelegatingFilterProxy;
import org.springframework.web.filter.FormContentFilter;
import org.springframework.web.filter.HiddenHttpMethodFilter;
import org.springframework.web.servlet.DispatcherServlet;

public abstract class WebConfig {
    @Deprecated
    public static void registerSpringSessionRepositoryFilter(ServletContext servletContext) {
    }

    public static void registerSpringContextLoaderListener(ServletContext servletContext) {
        servletContext.addListener(ContextLoaderListener.class);
    }

    public static void registerRequestContextListener(ServletContext servletContext) {
        servletContext.addListener(RequestContextListener.class);
    }

    public static void registerSingleSignOutHttpSessionListener(ServletContext servletContext) {
        Properties properties = SysParametersUtils.loadProperties();
        if (StringRegularOpt.isTrue((String)properties.getProperty("login.cas.enable"))) {
            servletContext.addListener(SingleSignOutHttpSessionListener.class);
        }
    }

    public static void registerHttpSessionEventPublisher(ServletContext servletContext) {
        servletContext.addListener(HttpSessionEventPublisher.class);
    }

    private static String[] makeUrlPatterns(String[] servletUrlPatterns, String ... otherUrlPatterns) {
        int nlen = servletUrlPatterns.length + (otherUrlPatterns == null ? 0 : otherUrlPatterns.length);
        String[] urlPatterns = new String[nlen];
        int n = 0;
        for (String servletUrl : servletUrlPatterns) {
            urlPatterns[n++] = servletUrl;
        }
        if (otherUrlPatterns != null) {
            for (String url : otherUrlPatterns) {
                urlPatterns[n++] = url;
            }
        }
        return urlPatterns;
    }

    public static FilterRegistration.Dynamic registerCharacterEncodingFilter(ServletContext servletContext, String[] servletUrlPatterns) {
        FilterRegistration.Dynamic encodingFilter = servletContext.addFilter("encodingFilter", CharacterEncodingFilter.class);
        encodingFilter.addMappingForUrlPatterns(null, false, WebConfig.makeUrlPatterns(servletUrlPatterns, "*.jsp", "*.html"));
        encodingFilter.setAsyncSupported(true);
        encodingFilter.setInitParameter("encoding", "UTF-8");
        encodingFilter.setInitParameter("forceEncoding", "true");
        return encodingFilter;
    }

    public static FilterRegistration.Dynamic registerHiddenHttpMethodFilter(ServletContext servletContext, String[] servletUrlPatterns) {
        FilterRegistration.Dynamic hiddenHttpMethodFilter = servletContext.addFilter("hiddenHttpMethodFilter", HiddenHttpMethodFilter.class);
        hiddenHttpMethodFilter.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), false, WebConfig.makeUrlPatterns(servletUrlPatterns, new String[0]));
        hiddenHttpMethodFilter.setAsyncSupported(true);
        return hiddenHttpMethodFilter;
    }

    public static FilterRegistration.Dynamic registerRequestThreadLocalFilter(ServletContext servletContext) {
        FilterRegistration.Dynamic requestThreadLocalFilter = servletContext.addFilter("requestThreadLocalFilter", RequestThreadLocalFilter.class);
        requestThreadLocalFilter.addMappingForUrlPatterns(null, false, new String[]{"/*"});
        requestThreadLocalFilter.setAsyncSupported(true);
        return requestThreadLocalFilter;
    }

    public static FilterRegistration.Dynamic registerAssertUserLoginFilter(ServletContext servletContext, String[] urlPatterns) {
        FilterRegistration.Dynamic requestThreadLocalFilter = servletContext.addFilter("assertUserLoginFilter", AssertUserLoginFilter.class);
        requestThreadLocalFilter.addMappingForUrlPatterns(null, false, urlPatterns);
        requestThreadLocalFilter.setAsyncSupported(true);
        return requestThreadLocalFilter;
    }

    public static FilterRegistration.Dynamic registerSpringSecurityFilter(ServletContext servletContext, String[] servletUrlPatterns) {
        FilterRegistration.Dynamic springSecurityFilterChain = servletContext.addFilter("springSecurityFilterChain", DelegatingFilterProxy.class);
        springSecurityFilterChain.addMappingForUrlPatterns(null, true, WebConfig.makeUrlPatterns(servletUrlPatterns, "/login/*", "/logout/*"));
        springSecurityFilterChain.setAsyncSupported(true);
        return springSecurityFilterChain;
    }

    public static FilterRegistration.Dynamic registerHttpPutFormContentFilter(ServletContext servletContext, String[] servletUrlPatterns) {
        FilterRegistration.Dynamic httpPutFormContentFilter = servletContext.addFilter("httpPutFormContentFilter", FormContentFilter.class);
        httpPutFormContentFilter.addMappingForUrlPatterns(null, false, WebConfig.makeUrlPatterns(servletUrlPatterns, new String[0]));
        httpPutFormContentFilter.setAsyncSupported(true);
        return httpPutFormContentFilter;
    }

    public static void initializeH2Console(ServletContext servletContext, boolean force) {
        boolean startH2Console = force;
        if (!startH2Console) {
            String type = SysParametersUtils.getStringValue((String)"session.persistence.db.type");
            boolean bl = startH2Console = type == null || StringUtils.equals((CharSequence)"jdbc", (CharSequence)type);
            if (startH2Console) {
                String dbUrl = SysParametersUtils.getStringValue((String)"session.jdbc.url");
                boolean bl2 = startH2Console = StringUtils.isBlank((CharSequence)dbUrl) || dbUrl.contains("jdbc:h2:");
            }
        }
        if (startH2Console) {
            ServletRegistration.Dynamic h2console = servletContext.addServlet("h2console", WebServlet.class);
            h2console.setInitParameter("webAllowOthers", "");
            h2console.addMapping(new String[]{"/h2console/*"});
            h2console.setLoadOnStartup(1);
            h2console.setAsyncSupported(true);
        }
    }

    public static void initializeH2Console(ServletContext servletContext) {
        WebConfig.initializeH2Console(servletContext, false);
    }

    public static void registerSpringConfig(ServletContext servletContext, Class<?> ... annotatedClasses) {
        AnnotationConfigWebApplicationContext springContext = new AnnotationConfigWebApplicationContext();
        springContext.register((Class[])annotatedClasses);
        servletContext.addListener((EventListener)new ContextLoaderListener((WebApplicationContext)springContext));
    }

    public static ServletRegistration.Dynamic registerServletConfig(ServletContext servletContext, String servletName, String servletUrlPattern, Class<?> ... annotatedClasses) {
        AnnotationConfigWebApplicationContext contextSer = new AnnotationConfigWebApplicationContext();
        contextSer.register((Class[])annotatedClasses);
        ServletRegistration.Dynamic servlet = servletContext.addServlet(servletName, (Servlet)new DispatcherServlet((WebApplicationContext)contextSer));
        servlet.addMapping(new String[]{servletUrlPattern});
        servlet.setLoadOnStartup(1);
        servlet.setAsyncSupported(true);
        return servlet;
    }
}

